/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.core.marker.volume.ClientVolumeBoxes;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.core.marker.volume.WorldSavedDataVolumeBoxes;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public enum EnumAddonSlot {
    EAST_UP_SOUTH(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE),
    EAST_UP_NORTH(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE),
    EAST_DOWN_SOUTH(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE),
    EAST_DOWN_NORTH(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE),
    WEST_UP_SOUTH(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE),
    WEST_UP_NORTH(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE),
    WEST_DOWN_SOUTH(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE),
    WEST_DOWN_NORTH(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE);

    public static final EnumAddonSlot[] VALUES;
    public final Map<EnumFacing.Axis, EnumFacing.AxisDirection> directions = new EnumMap<EnumFacing.Axis, EnumFacing.AxisDirection>(EnumFacing.Axis.class);

    private EnumAddonSlot(EnumFacing.AxisDirection x, EnumFacing.AxisDirection y, EnumFacing.AxisDirection z) {
        this.directions.put(EnumFacing.Axis.X, x);
        this.directions.put(EnumFacing.Axis.Y, y);
        this.directions.put(EnumFacing.Axis.Z, z);
    }

    public AxisAlignedBB getBoundingBox(VolumeBox box) {
        AxisAlignedBB boxBB = box.box.getBoundingBox();
        Vec3d boxOffset = new Vec3d(this.directions.get(EnumFacing.Axis.X) == EnumFacing.AxisDirection.POSITIVE ? boxBB.field_72336_d : boxBB.field_72340_a, this.directions.get(EnumFacing.Axis.Y) == EnumFacing.AxisDirection.POSITIVE ? boxBB.field_72337_e : boxBB.field_72338_b, this.directions.get(EnumFacing.Axis.Z) == EnumFacing.AxisDirection.POSITIVE ? boxBB.field_72334_f : boxBB.field_72339_c);
        return new AxisAlignedBB(boxOffset.field_72450_a, boxOffset.field_72448_b, boxOffset.field_72449_c, boxOffset.field_72450_a, boxOffset.field_72448_b, boxOffset.field_72449_c).func_186662_g(0.0625);
    }

    public static Pair<VolumeBox, EnumAddonSlot> getSelectingBoxAndSlot(EntityPlayer player, List<VolumeBox> boxes) {
        Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d end = start.func_178787_e(player.func_70040_Z().func_186678_a(4.0));
        VolumeBox bestBox = null;
        EnumAddonSlot bestSlot = null;
        double bestDist = 10000.0;
        for (VolumeBox box : boxes) {
            for (EnumAddonSlot slot : EnumAddonSlot.values()) {
                double dist;
                RayTraceResult ray = slot.getBoundingBox(box).func_72327_a(start, end);
                if (ray == null || !(bestDist > (dist = ray.field_72307_f.func_72438_d(start)))) continue;
                bestDist = dist;
                bestBox = box;
                bestSlot = slot;
            }
        }
        return Pair.of(bestBox, bestSlot);
    }

    public static Pair<VolumeBox, EnumAddonSlot> getSelectingBoxAndSlot(EntityPlayer player, WorldSavedDataVolumeBoxes volumeBoxes) {
        return EnumAddonSlot.getSelectingBoxAndSlot(player, volumeBoxes.boxes);
    }

    public static Pair<VolumeBox, EnumAddonSlot> getSelectingBoxAndSlot(EntityPlayer player, ClientVolumeBoxes clientVolumeBoxes) {
        return EnumAddonSlot.getSelectingBoxAndSlot(player, clientVolumeBoxes.boxes);
    }

    static {
        VALUES = EnumAddonSlot.values();
    }
}

