/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.core.marker.volume.IFastAddonRenderer;
import buildcraft.core.marker.volume.ISingleAddon;
import buildcraft.core.marker.volume.VolumeBox;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Addon {
    public VolumeBox box;

    @SideOnly(value=Side.CLIENT)
    public abstract IFastAddonRenderer<? extends Addon> getRenderer();

    public EnumAddonSlot getSlot() {
        return (EnumAddonSlot)((Object)((Map.Entry)this.box.addons.entrySet().stream().filter(slotAddon -> slotAddon.getValue() == this).findFirst().orElse(null)).getKey());
    }

    public AxisAlignedBB getBoundingBox() {
        return this.getSlot().getBoundingBox(this.box);
    }

    public boolean canBePlaceInto(VolumeBox box) {
        return !(this instanceof ISingleAddon) || box.addons.values().stream().noneMatch(addon -> addon.getClass() == this.getClass());
    }

    public void onAdded() {
    }

    public void onRemoved() {
    }

    public void onBoxSizeChange() {
    }

    public void onPlayerRightClick(EntityPlayer player) {
    }

    public abstract NBTTagCompound writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void toBytes(ByteBuf var1);

    public abstract void fromBytes(ByteBuf var1);
}

