/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker;

import buildcraft.core.BCCoreConfig;
import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.marker.VolumeCache;
import buildcraft.core.marker.VolumeConnection;
import buildcraft.core.marker.VolumeSavedData;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.net.MessageMarker;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VolumeSubCache
extends MarkerSubCache<VolumeConnection> {
    public VolumeSubCache(World world) {
        super(world, VolumeCache.CACHES.indexOf(VolumeCache.INSTANCE));
        VolumeSavedData data = (VolumeSavedData)world.func_72943_a(VolumeSavedData.class, "buildcraft_marker_volume");
        if (data == null) {
            data = new VolumeSavedData();
            world.func_72823_a("buildcraft_marker_volume", (WorldSavedData)data);
        }
        data.loadInto(this);
    }

    @Override
    public boolean tryConnect(BlockPos from, BlockPos to) {
        VolumeConnection fromConnection = (VolumeConnection)this.getConnection(from);
        VolumeConnection toConnection = (VolumeConnection)this.getConnection(to);
        if (fromConnection == null) {
            if (toConnection == null) {
                return VolumeConnection.tryCreateConnection(this, from, to);
            }
            return toConnection.addMarker(from);
        }
        if (toConnection == null) {
            return fromConnection.addMarker(to);
        }
        return fromConnection.mergeWith(toConnection);
    }

    @Override
    public boolean canConnect(BlockPos from, BlockPos to) {
        VolumeConnection fromConnection = (VolumeConnection)this.getConnection(from);
        VolumeConnection toConnection = (VolumeConnection)this.getConnection(to);
        if (fromConnection == null) {
            if (toConnection == null) {
                return VolumeConnection.canCreateConnection(this, from, to);
            }
            return toConnection.canAddMarker(from);
        }
        if (toConnection == null) {
            return fromConnection.canAddMarker(to);
        }
        return fromConnection.canMergeWith(toConnection);
    }

    @Override
    public ImmutableList<BlockPos> getValidConnections(BlockPos from) {
        VolumeConnection existing = (VolumeConnection)this.getConnection(from);
        EnumSet<EnumFacing.Axis> taken = EnumSet.noneOf(EnumFacing.Axis.class);
        if (existing != null) {
            taken.addAll(existing.getConnectedAxis());
        }
        ImmutableList.Builder valids = ImmutableList.builder();
        block0: for (EnumFacing face : EnumFacing.field_82609_l) {
            if (taken.contains(face.func_176740_k())) continue;
            for (int i = 1; i <= BCCoreConfig.markerMaxDistance; ++i) {
                BlockPos toTry = from.func_177967_a(face, i);
                if (!this.hasLoadedOrUnloadedMarker(toTry)) continue;
                if (!this.canConnect(from, toTry)) continue block0;
                valids.add((Object)toTry);
                continue block0;
            }
        }
        return valids.build();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LaserData_BC8.LaserType getPossibleLaserType() {
        return BuildCraftLaserManager.MARKER_VOLUME_POSSIBLE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean handleMessage(MessageMarker message) {
        List<BlockPos> positions = message.positions;
        if (message.connection) {
            if (message.add) {
                for (BlockPos p : positions) {
                    VolumeConnection existing = (VolumeConnection)this.getConnection(p);
                    this.destroyConnection(existing);
                }
                VolumeConnection con = new VolumeConnection(this, positions);
                this.addConnection(con);
            } else {
                for (BlockPos p : positions) {
                    VolumeConnection existing = (VolumeConnection)this.getConnection(p);
                    if (existing == null) continue;
                    existing.removeMarker(p);
                    this.refreshConnection(existing);
                }
            }
        }
        return false;
    }
}

