/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker;

import buildcraft.core.BCCoreConfig;
import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.marker.VolumeSubCache;
import buildcraft.lib.client.render.laser.LaserBoxRenderer;
import buildcraft.lib.marker.MarkerConnection;
import buildcraft.lib.misc.PositionUtil;
import buildcraft.lib.misc.data.Box;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VolumeConnection
extends MarkerConnection<VolumeConnection> {
    private static final double RENDER_SCALE = 0.06230529595015576;
    private final Set<BlockPos> makeup = new HashSet<BlockPos>();
    private final Box box = new Box();

    public static boolean tryCreateConnection(VolumeSubCache subCache, BlockPos from, BlockPos to) {
        if (VolumeConnection.canCreateConnection(subCache, from, to)) {
            VolumeConnection connection = new VolumeConnection(subCache);
            connection.makeup.add(from);
            connection.makeup.add(to);
            connection.createBox();
            subCache.addConnection(connection);
            return true;
        }
        return false;
    }

    public static boolean canCreateConnection(VolumeSubCache subCache, BlockPos from, BlockPos to) {
        EnumFacing directOffset = PositionUtil.getDirectFacingOffset(from, to);
        if (directOffset == null) {
            return false;
        }
        for (int i = 1; i <= BCCoreConfig.markerMaxDistance; ++i) {
            BlockPos offset = from.func_177967_a(directOffset, i);
            if (offset.equals((Object)to)) {
                return true;
            }
            if (!subCache.hasLoadedOrUnloadedMarker(offset)) continue;
            return false;
        }
        return false;
    }

    public VolumeConnection(VolumeSubCache subCache) {
        super(subCache);
    }

    public VolumeConnection(VolumeSubCache subCache, Collection<BlockPos> positions) {
        super(subCache);
        this.makeup.addAll(positions);
        this.createBox();
    }

    @Override
    public void removeMarker(BlockPos pos) {
        this.makeup.remove(pos);
        if (this.makeup.size() < 2) {
            this.makeup.clear();
        }
        this.createBox();
    }

    public boolean addMarker(BlockPos pos) {
        if (this.canAddMarker(pos)) {
            this.makeup.add(pos);
            this.createBox();
            this.subCache.refreshConnection(this);
            return true;
        }
        return false;
    }

    public boolean canAddMarker(BlockPos to) {
        EnumSet<EnumFacing.Axis> taken = this.getConnectedAxis();
        for (BlockPos from : this.makeup) {
            EnumFacing direct = PositionUtil.getDirectFacingOffset(from, to);
            if (direct == null || taken.contains(direct.func_176740_k())) continue;
            return true;
        }
        return false;
    }

    public boolean mergeWith(VolumeConnection other) {
        if (this.canMergeWith(other)) {
            this.makeup.addAll(other.makeup);
            other.makeup.clear();
            this.createBox();
            this.subCache.refreshConnection(other);
            this.subCache.refreshConnection(this);
            return true;
        }
        return false;
    }

    public boolean canMergeWith(VolumeConnection other) {
        EnumSet<EnumFacing.Axis> us = this.getConnectedAxis();
        EnumSet<EnumFacing.Axis> them = other.getConnectedAxis();
        if (us.size() != 1 || them.size() != 1) {
            return false;
        }
        if (us.equals(them)) {
            return false;
        }
        EnumSet<EnumFacing.Axis> blacklisted = EnumSet.copyOf(us);
        blacklisted.addAll(them);
        for (BlockPos from : this.makeup) {
            for (BlockPos to : other.makeup) {
                EnumFacing offset = PositionUtil.getDirectFacingOffset(from, to);
                if (offset == null || blacklisted.contains(offset.func_176740_k())) continue;
                return true;
            }
        }
        return false;
    }

    public EnumSet<EnumFacing.Axis> getConnectedAxis() {
        EnumSet<EnumFacing.Axis> taken = EnumSet.noneOf(EnumFacing.Axis.class);
        for (BlockPos a : this.getMarkerPositions()) {
            for (BlockPos b : this.getMarkerPositions()) {
                EnumFacing offset = PositionUtil.getDirectFacingOffset(a, b);
                if (offset == null) continue;
                taken.add(offset.func_176740_k());
            }
        }
        return taken;
    }

    @Override
    public Collection<BlockPos> getMarkerPositions() {
        return this.makeup;
    }

    private void createBox() {
        this.box.reset();
        for (BlockPos p : this.makeup) {
            this.box.extendToEncompass(p);
        }
    }

    public Box getBox() {
        return new Box(this.box.min(), this.box.max());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInWorld() {
        LaserBoxRenderer.renderLaserBoxStatic(this.box, BuildCraftLaserManager.MARKER_VOLUME_CONNECTED, true);
    }
}

