/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.core.BCCoreItems;
import buildcraft.core.item.ItemList_BC8;
import buildcraft.core.list.ContainerList;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.button.GuiImageButton;
import buildcraft.lib.gui.button.IButtonBehaviour;
import buildcraft.lib.gui.button.IButtonClickEventListener;
import buildcraft.lib.gui.button.IButtonClickEventTrigger;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.widget.WidgetPhantomSlot;
import buildcraft.lib.misc.StackUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class GuiList
extends GuiBC8<ContainerList>
implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftcore:textures/gui/list_new.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 191;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE_BASE, 0, 0, 176, 191);
    private static final GuiIcon ICON_HIGHLIGHT = new GuiIcon(TEXTURE_BASE, 176, 0, 16, 16);
    private static final GuiIcon ICON_ONE_STACK = new GuiIcon(TEXTURE_BASE, 0, 191, 20, 20);
    private static final int BUTTON_COUNT = 3;
    private final Map<Integer, Map<ListMatchHandler.Type, NonNullList<ItemStack>>> exampleCache = new HashMap<Integer, Map<ListMatchHandler.Type, NonNullList<ItemStack>>>();
    private GuiTextField textField;

    public GuiList(EntityPlayer iPlayer) {
        super(new ContainerList(iPlayer));
        this.field_146999_f = 176;
        this.field_147000_g = 191;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        for (int line = 0; line < ((ContainerList)this.container).slots.length; ++line) {
            ContainerList.WidgetListSlot[] arr = ((ContainerList)this.container).slots[line];
            for (int slot = 0; slot < arr.length; ++slot) {
                final ContainerList.WidgetListSlot listSlot = arr[slot];
                GuiRectangle rectangle = new GuiRectangle(8 + slot * 18, 32 + line * 34, 16, 16);
                ContainerList.WidgetListSlot widgetListSlot = listSlot;
                widgetListSlot.getClass();
                this.guiElements.add(new WidgetPhantomSlot.GuiElementPhantomSlot<GuiList>(widgetListSlot, this, (IGuiPosition)this.rootElement, rectangle){
                    {
                        ContainerList.WidgetListSlot widgetListSlot2 = x0;
                        widgetListSlot2.getClass();
                        super((WidgetPhantomSlot)widgetListSlot2, (GuiBC8)gui, parent, position);
                    }

                    @Override
                    protected boolean shouldDrawHighlight() {
                        return listSlot.slotIndex == 0 || !((ContainerList)((GuiList)this.gui).container).lines[listSlot.lineIndex].isOneStackMode();
                    }

                    @Override
                    public void drawBackground(float partialTicks) {
                        if (!this.shouldDrawHighlight()) {
                            ICON_HIGHLIGHT.drawAt(this);
                        }
                    }

                    @Override
                    @Nonnull
                    public ItemStack getStack() {
                        if (this.shouldDrawHighlight()) {
                            return super.getStack();
                        }
                        NonNullList data = ((GuiList)this.gui).getExamplesList(listSlot.lineIndex, ((ContainerList)GuiList.this.container).lines[listSlot.lineIndex].getSortingType());
                        if (data.size() >= listSlot.slotIndex) {
                            return (ItemStack)data.get(listSlot.slotIndex - 1);
                        }
                        return StackUtil.EMPTY;
                    }

                    @Override
                    public void onMouseClicked(int button) {
                        super.onMouseClicked(button);
                        if (this.contains(((GuiList)this.gui).mouse)) {
                            GuiList.this.clearExamplesCache(listSlot.lineIndex);
                        }
                    }
                });
            }
        }
        this.field_146292_n.clear();
        for (int sy = 0; sy < 2; ++sy) {
            int bOff = sy * 3;
            int bOffX = this.field_147003_i + 8 + 162 - 33;
            int bOffY = this.field_147009_r + 32 + sy * 34 + 18;
            GuiImageButton buttonPrecise = new GuiImageButton(this, bOff + 0, bOffX, bOffY, 11, TEXTURE_BASE, 176, 16, 176, 28);
            buttonPrecise.setToolTip(ToolTip.createLocalized("gui.list.nbt")).setBehaviour(IButtonBehaviour.TOGGLE);
            this.field_146292_n.add(buttonPrecise);
            GuiImageButton buttonType = new GuiImageButton(this, bOff + 1, bOffX + 11, bOffY, 11, TEXTURE_BASE, 176, 16, 185, 28);
            buttonType.setToolTip(ToolTip.createLocalized("gui.list.metadata")).setBehaviour(IButtonBehaviour.TOGGLE);
            this.field_146292_n.add(buttonType);
            GuiImageButton buttonMaterial = new GuiImageButton(this, bOff + 2, bOffX + 22, bOffY, 11, TEXTURE_BASE, 176, 16, 194, 28);
            buttonMaterial.setToolTip(ToolTip.createLocalized("gui.list.oredict")).setBehaviour(IButtonBehaviour.TOGGLE);
            this.field_146292_n.add(buttonMaterial);
        }
        for (GuiButton o : this.field_146292_n) {
            GuiImageButton b = (GuiImageButton)o;
            int lineId = b.field_146127_k / 3;
            int buttonId = b.field_146127_k % 3;
            if (((ContainerList)this.container).lines[lineId].getOption(buttonId)) {
                b.activate();
            }
            b.registerListener(this);
        }
        this.textField = new GuiTextField(6, this.field_146289_q, this.field_147003_i + 10, this.field_147009_r + 10, 156, 12);
        this.textField.func_146203_f(32);
        this.textField.func_146180_a(BCCoreItems.list.getName(((ContainerList)this.container).getListItemStack()));
        this.textField.func_146195_b(false);
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt(this.rootElement);
        for (int i = 0; i < 2; ++i) {
            if (!((ContainerList)this.container).lines[i].isOneStackMode()) continue;
            ICON_ONE_STACK.drawAt(this.field_147003_i + 6, this.field_147009_r + 30 + i * 34);
        }
    }

    @Override
    protected void drawForegroundLayer() {
        this.textField.func_146194_f();
    }

    private boolean isCarryingNonEmptyList() {
        ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemList_BC8 && stack.func_77978_p() != null;
    }

    private boolean hasListEquipped() {
        return !((ContainerList)this.container).getListItemStack().func_190926_b();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.textField.func_146206_l() && keyCode != 1) {
            this.textField.func_146201_a(typedChar, keyCode);
            ((ContainerList)this.container).setLabel(this.textField.func_146179_b());
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int b) throws IOException {
        super.func_73864_a(x, y, b);
        if (this.isCarryingNonEmptyList() || !this.hasListEquipped()) {
            return;
        }
        this.textField.func_146192_a(x, y, b);
    }

    @Override
    public void handleButtonClick(IButtonClickEventTrigger sender, int id, int buttonKey) {
        int buttonId = id % 3;
        int lineId = id / 3;
        ((ContainerList)this.container).switchButton(lineId, buttonId);
        this.clearExamplesCache(lineId);
    }

    private void clearExamplesCache(int lineId) {
        Map<ListMatchHandler.Type, NonNullList<ItemStack>> exampleList = this.exampleCache.get(lineId);
        if (exampleList != null) {
            exampleList.clear();
        }
    }

    private NonNullList<ItemStack> getExamplesList(int lineId, ListMatchHandler.Type type) {
        Map exampleList = this.exampleCache.computeIfAbsent(lineId, k -> new EnumMap(ListMatchHandler.Type.class));
        if (!exampleList.containsKey((Object)type)) {
            NonNullList<ItemStack> examples = ((ContainerList)this.container).lines[lineId].getExamples();
            ItemStack input = (ItemStack)((ContainerList)this.container).lines[lineId].stacks.get(0);
            if (!input.func_190926_b()) {
                NonNullList repetitions = NonNullList.func_191196_a();
                for (ItemStack is : examples) {
                    if (!StackUtil.isMatchingItem(input, is, true, false)) continue;
                    repetitions.add((Object)is);
                }
                examples.removeAll((Collection)repetitions);
            }
            exampleList.put(type, examples);
        }
        return (NonNullList)exampleList.get((Object)type);
    }
}

