/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.core.BCCoreItems;
import buildcraft.core.item.ItemList_BC8;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.widget.WidgetPhantomSlot;
import buildcraft.lib.list.ListHandler;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ContainerList
extends ContainerBC_Neptune {
    protected static final IdAllocator IDS = ContainerBC_Neptune.IDS.makeChild("list");
    private static final int ID_LABEL = IDS.allocId("LABEL");
    private static final int ID_BUTTON = IDS.allocId("BUTTON");
    public ListHandler.Line[] lines = ListHandler.getLines(this.getListItemStack());
    final WidgetListSlot[][] slots = new WidgetListSlot[this.lines.length][9];

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public ContainerList(EntityPlayer iPlayer) {
        super(iPlayer);
        for (int line = 0; line < this.lines.length; ++line) {
            for (int slot = 0; slot < 9; ++slot) {
                WidgetListSlot widget = new WidgetListSlot(line, slot);
                this.slots[line][slot] = this.addWidget(widget);
                widget.setStack(this.lines[line].getStack(slot), false);
            }
        }
        this.addFullPlayerInventory(103);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @Nonnull
    public ItemStack getListItemStack() {
        ItemStack toTry = this.player.func_184614_ca();
        if (!toTry.func_190926_b() && toTry.func_77973_b() instanceof ItemList_BC8) {
            return toTry;
        }
        toTry = this.player.func_184592_cb();
        if (!toTry.func_190926_b() && toTry.func_77973_b() instanceof ItemList_BC8) {
            return toTry;
        }
        return StackUtil.EMPTY;
    }

    void setStack(int lineIndex, int slotIndex, @Nonnull ItemStack stack) {
        this.lines[lineIndex].setStack(slotIndex, stack);
        ListHandler.saveLines(this.getListItemStack(), this.lines);
    }

    public void switchButton(int lineIndex, int button) {
        ListMatchHandler.Type type;
        this.lines[lineIndex].toggleOption(button);
        if (this.player.field_70170_p.field_72995_K) {
            this.sendMessage(ID_BUTTON, buffer -> {
                buffer.writeByte(lineIndex);
                buffer.writeByte(button);
            });
        } else if (!(button != 1 && button != 2 || (type = this.lines[lineIndex].getSortingType()) != ListMatchHandler.Type.MATERIAL && type != ListMatchHandler.Type.TYPE)) {
            WidgetListSlot[] widgetSlots = this.slots[lineIndex];
            for (int i = 1; i < widgetSlots.length; ++i) {
                widgetSlots[i].setStack(StackUtil.EMPTY, true);
            }
        }
        ListHandler.saveLines(this.getListItemStack(), this.lines);
    }

    public void setLabel(String text) {
        BCCoreItems.list.setName(this.getListItemStack(), text);
        if (this.player.field_70170_p.field_72995_K) {
            this.sendMessage(ID_LABEL, buffer -> buffer.func_180714_a(text));
        }
    }

    @Override
    public void readMessage(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readMessage(id, buffer, side, ctx);
        if (side == Side.SERVER) {
            if (id == ID_BUTTON) {
                short lineIndex = buffer.readUnsignedByte();
                short button = buffer.readUnsignedByte();
                this.switchButton(lineIndex, button);
            } else if (id == ID_LABEL) {
                this.setLabel(buffer.func_150789_c(1024));
            }
        }
    }

    class WidgetListSlot
    extends WidgetPhantomSlot {
        final int lineIndex;
        final int slotIndex;

        public WidgetListSlot(int lineIndex, int slotIndex) {
            super(ContainerList.this);
            this.lineIndex = lineIndex;
            this.slotIndex = slotIndex;
        }

        @Override
        protected void onSetStack() {
            ContainerList.this.setStack(this.lineIndex, this.slotIndex, this.getStack());
        }
    }
}

