/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.item;

import buildcraft.core.marker.volume.Addon;
import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.core.marker.volume.Lock;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.core.marker.volume.WorldSavedDataVolumeBoxes;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.misc.PositionUtil;
import buildcraft.lib.misc.VecUtil;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemMarkerConnector
extends ItemBC_Neptune {
    public ItemMarkerConnector(String id) {
        super(id);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            for (MarkerCache<?> cache : MarkerCache.CACHES) {
                if (!ItemMarkerConnector.interactCache(cache.getSubCache(world), player)) continue;
                player.func_184609_a(hand);
                break;
            }
        }
        return this.newVolumeCacheStuff_onItemRightClick(player.func_184586_b(hand), world, player, hand);
    }

    private static <S extends MarkerSubCache<?>> boolean interactCache(S cache, EntityPlayer player) {
        MarkerLineInteraction best = null;
        Vec3d playerPos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d playerLook = player.func_70040_Z();
        for (BlockPos marker : cache.getAllMarkers()) {
            ImmutableList<BlockPos> possibles = cache.getValidConnections(marker);
            for (BlockPos possible : possibles) {
                MarkerLineInteraction interaction = new MarkerLineInteraction(marker, possible, playerPos, playerLook);
                if (!interaction.didInteract()) continue;
                best = interaction.getBetter(best);
            }
        }
        if (best != null) {
            return cache.tryConnect(best.marker1, best.marker2) || cache.tryConnect(best.marker2, best.marker1);
        }
        return false;
    }

    public static boolean doesInteract(BlockPos a, BlockPos b, EntityPlayer player) {
        Vec3d playerPos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d playerLook = player.func_70040_Z();
        MarkerLineInteraction interaction = new MarkerLineInteraction(a, b, playerPos, playerLook);
        return interaction.didInteract();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ActionResult<ItemStack> newVolumeCacheStuff_onItemRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        WorldSavedDataVolumeBoxes volumeBoxes = WorldSavedDataVolumeBoxes.get(world);
        VolumeBox currentEditing = volumeBoxes.getCurrentEditing(player);
        Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d end = start.func_178787_e(player.func_70040_Z().func_186678_a(4.0));
        Pair<VolumeBox, EnumAddonSlot> selectingBoxAndSlot = EnumAddonSlot.getSelectingBoxAndSlot(player, volumeBoxes);
        VolumeBox addonBox = (VolumeBox)selectingBoxAndSlot.getLeft();
        EnumAddonSlot addonSlot = (EnumAddonSlot)((Object)selectingBoxAndSlot.getRight());
        if (addonBox != null && addonSlot != null) {
            if (!addonBox.addons.containsKey((Object)addonSlot)) return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            if (!addonBox.getLockTargetsStream().noneMatch(target -> target instanceof Lock.Target.TargetAddon && ((Lock.Target.TargetAddon)target).slot == addonSlot)) return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            if (player.func_70093_af()) {
                addonBox.addons.get((Object)addonSlot).onRemoved();
                addonBox.addons.remove((Object)addonSlot);
                volumeBoxes.func_76185_a();
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            addonBox.addons.get((Object)addonSlot).onPlayerRightClick(player);
            volumeBoxes.func_76185_a();
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_70093_af()) {
            VolumeBox box2;
            if (currentEditing != null) {
                currentEditing.cancelEditing();
                volumeBoxes.func_76185_a();
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            Iterator<VolumeBox> iterator = volumeBoxes.boxes.iterator();
            do {
                if (!iterator.hasNext()) return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                box2 = iterator.next();
            } while (box2.box.getBoundingBox().func_72327_a(start, end) == null);
            box2.addons.values().forEach(Addon::onRemoved);
            iterator.remove();
            volumeBoxes.func_76185_a();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (currentEditing != null) {
            currentEditing.confirmEditing();
            volumeBoxes.func_76185_a();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        VolumeBox bestBox = null;
        double bestDist = 10000.0;
        BlockPos editing = null;
        for (VolumeBox box3 : volumeBoxes.boxes.stream().filter(box -> box.getLockTargetsStream().noneMatch(Lock.Target.TargetResize.class::isInstance)).collect(Collectors.toList())) {
            for (BlockPos p : PositionUtil.getCorners(box3.box.min(), box3.box.max())) {
                double dist;
                RayTraceResult ray = new AxisAlignedBB(p).func_72327_a(start, end);
                if (ray == null || !(bestDist > (dist = ray.field_72307_f.func_72438_d(start)))) continue;
                bestDist = dist;
                bestBox = box3;
                editing = p;
            }
        }
        if (bestBox == null) return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        bestBox.setPlayer(player);
        BlockPos min = bestBox.box.min();
        BlockPos max = bestBox.box.max();
        BlockPos held = min;
        if (editing.func_177958_n() == min.func_177958_n()) {
            held = VecUtil.replaceValue((Vec3i)held, EnumFacing.Axis.X, max.func_177958_n());
        }
        if (editing.func_177956_o() == min.func_177956_o()) {
            held = VecUtil.replaceValue((Vec3i)held, EnumFacing.Axis.Y, max.func_177956_o());
        }
        if (editing.func_177952_p() == min.func_177952_p()) {
            held = VecUtil.replaceValue((Vec3i)held, EnumFacing.Axis.Z, max.func_177952_p());
        }
        bestBox.setHeldDistOldMinOldMax(held, Math.max(1.5, bestDist + 0.5), bestBox.box.min(), bestBox.box.max());
        volumeBoxes.func_76185_a();
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static class MarkerLineInteraction {
        public final BlockPos marker1;
        public final BlockPos marker2;
        public final double distToPoint;
        public final double distToLine;

        public MarkerLineInteraction(BlockPos marker1, BlockPos marker2, Vec3d playerPos, Vec3d playerEndPos) {
            this.marker1 = marker1;
            this.marker2 = marker2;
            PositionUtil.Line line = new PositionUtil.Line(VecUtil.convertCenter((Vec3i)marker1), VecUtil.convertCenter((Vec3i)marker2));
            PositionUtil.LineSkewResult interactionPoint = PositionUtil.findLineSkewPoint(line, playerPos, playerEndPos);
            this.distToPoint = interactionPoint.closestPos.func_72438_d(playerPos);
            this.distToLine = interactionPoint.distFromLine;
        }

        public boolean didInteract() {
            return this.distToPoint <= 3.0 && this.distToLine < 0.3;
        }

        public MarkerLineInteraction getBetter(MarkerLineInteraction other) {
            if (other == null) {
                return this;
            }
            if (other.marker1 == this.marker2 && other.marker2 == this.marker1) {
                return other;
            }
            if (other.distToLine < this.distToLine) {
                return other;
            }
            if (other.distToLine > this.distToLine) {
                return this;
            }
            if (other.distToPoint < this.distToPoint) {
                return other;
            }
            return this;
        }
    }
}

