/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.item;

import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.IBox;
import buildcraft.api.core.IPathProvider;
import buildcraft.api.core.IZone;
import buildcraft.api.items.IMapLocation;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.StringUtilBC;
import buildcraft.lib.misc.data.Box;
import buildcraft.robotics.zone.ZonePlan;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMapLocation
extends ItemBC_Neptune
implements IMapLocation {
    private static final String[] STORAGE_TAGS = "x,y,z,side,xMin,xMax,yMin,yMax,zMin,zMax,path,chunkMapping,name".split(",");

    public ItemMapLocation(String id) {
        super(id);
        this.func_77627_a(true);
    }

    public int getItemStackLimit(ItemStack stack) {
        return IMapLocation.MapLocationType.getFromStack(StackUtil.asNonNull(stack)) == IMapLocation.MapLocationType.CLEAN ? 16 : 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        for (IMapLocation.MapLocationType type : IMapLocation.MapLocationType.values()) {
            this.addVariant(variants, type.meta, type.name().toLowerCase(Locale.ROOT));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> strings, boolean advanced) {
        String name;
        NBTTagCompound cpt = NBTUtilBC.getItemData(stack = StackUtil.asNonNull(stack));
        if (cpt.func_74764_b("name") && (name = cpt.func_74779_i("name")).length() > 0) {
            strings.add(name);
        }
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(stack);
        switch (type) {
            case SPOT: {
                if (!cpt.func_74764_b("x") || !cpt.func_74764_b("y") || !cpt.func_74764_b("z") || !cpt.func_74764_b("side")) break;
                int x = cpt.func_74762_e("x");
                int y = cpt.func_74762_e("y");
                int z = cpt.func_74762_e("z");
                EnumFacing side = EnumFacing.field_82609_l[cpt.func_74771_c("side")];
                strings.add(LocaleUtil.localize("{" + x + ", " + y + ", " + z + ", " + side + "}"));
                break;
            }
            case AREA: {
                if (!cpt.func_74764_b("xMin") || !cpt.func_74764_b("yMin") || !cpt.func_74764_b("zMin") || !cpt.func_74764_b("xMax") || !cpt.func_74764_b("yMax") || !cpt.func_74764_b("zMax")) break;
                int x = cpt.func_74762_e("xMin");
                int y = cpt.func_74762_e("yMin");
                int z = cpt.func_74762_e("zMin");
                int xLength = cpt.func_74762_e("xMax") - x + 1;
                int yLength = cpt.func_74762_e("yMax") - y + 1;
                int zLength = cpt.func_74762_e("zMax") - z + 1;
                strings.add(LocaleUtil.localize("{" + x + ", " + y + ", " + z + "} + {" + xLength + " x " + yLength + " x " + zLength + "}"));
                break;
            }
            case PATH: 
            case PATH_REPEATING: {
                BlockPos first;
                NBTTagList pathNBT;
                if (!cpt.func_74764_b("path") || (pathNBT = (NBTTagList)cpt.func_74781_a("path")).func_74745_c() <= 0 || (first = NBTUtilBC.readBlockPos(pathNBT.func_179238_g(0))) == null) break;
                strings.add(StringUtilBC.blockPosToString(first) + (pathNBT.func_74745_c() - 1) + " elements");
                break;
            }
        }
        if (type != IMapLocation.MapLocationType.CLEAN) {
            strings.add(LocaleUtil.localize("buildcraft.item.nonclean.usage"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            return ItemMapLocation.clearMarkerData(StackUtil.asNonNull(stack));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private static ActionResult<ItemStack> clearMarkerData(@Nonnull ItemStack stack) {
        if (IMapLocation.MapLocationType.getFromStack(stack) == IMapLocation.MapLocationType.CLEAN) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        NBTTagCompound nbt = NBTUtilBC.getItemData(stack);
        for (String key : STORAGE_TAGS) {
            nbt.func_82580_o(key);
        }
        if (nbt.func_82582_d()) {
            stack.func_77982_d(null);
        }
        IMapLocation.MapLocationType.CLEAN.setToStack(stack);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = StackUtil.asNonNull(player.func_184586_b(hand));
        if (IMapLocation.MapLocationType.getFromStack(stack) != IMapLocation.MapLocationType.CLEAN) {
            return EnumActionResult.FAIL;
        }
        ItemStack modified = stack;
        if (stack.func_190916_E() > 1) {
            modified = stack.func_77946_l();
            stack.func_190920_e(stack.func_190916_E() - 1);
            modified.func_190920_e(1);
        }
        TileEntity tile = world.func_175625_s(pos);
        NBTTagCompound cpt = NBTUtilBC.getItemData(modified);
        if (tile instanceof IPathProvider) {
            List<BlockPos> path = ((IPathProvider)tile).getPath();
            if (path.size() > 1 && path.get(0).equals((Object)path.get(path.size() - 1))) {
                IMapLocation.MapLocationType.PATH_REPEATING.setToStack(stack);
            } else {
                IMapLocation.MapLocationType.PATH.setToStack(stack);
            }
            NBTTagList pathNBT = new NBTTagList();
            for (BlockPos posInPath : path) {
                pathNBT.func_74742_a((NBTBase)NBTUtilBC.writeBlockPos(posInPath));
            }
            cpt.func_74782_a("path", (NBTBase)pathNBT);
        } else if (tile instanceof IAreaProvider) {
            IMapLocation.MapLocationType.AREA.setToStack(modified);
            IAreaProvider areaTile = (IAreaProvider)tile;
            cpt.func_74768_a("xMin", areaTile.min().func_177958_n());
            cpt.func_74768_a("yMin", areaTile.min().func_177956_o());
            cpt.func_74768_a("zMin", areaTile.min().func_177952_p());
            cpt.func_74768_a("xMax", areaTile.max().func_177958_n());
            cpt.func_74768_a("yMax", areaTile.max().func_177956_o());
            cpt.func_74768_a("zMax", areaTile.max().func_177952_p());
        } else {
            IMapLocation.MapLocationType.SPOT.setToStack(modified);
            cpt.func_74774_a("side", (byte)side.func_176745_a());
            cpt.func_74768_a("x", pos.func_177958_n());
            cpt.func_74768_a("y", pos.func_177956_o());
            cpt.func_74768_a("z", pos.func_177952_p());
        }
        return EnumActionResult.SUCCESS;
    }

    public static IBox getAreaBox(@Nonnull ItemStack item) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(item);
        int xMin = cpt.func_74762_e("xMin");
        int yMin = cpt.func_74762_e("yMin");
        int zMin = cpt.func_74762_e("zMin");
        BlockPos min = new BlockPos(xMin, yMin, zMin);
        int xMax = cpt.func_74762_e("xMax");
        int yMax = cpt.func_74762_e("yMax");
        int zMax = cpt.func_74762_e("zMax");
        BlockPos max = new BlockPos(xMax, yMax, zMax);
        return new Box(min, max);
    }

    public static IBox getPointBox(@Nonnull ItemStack item) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(item);
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(item);
        switch (type) {
            case SPOT: {
                int x = cpt.func_74762_e("x");
                int y = cpt.func_74762_e("y");
                int z = cpt.func_74762_e("z");
                BlockPos pos = new BlockPos(x, y, z);
                return new Box(pos, pos);
            }
        }
        return null;
    }

    public static EnumFacing getPointFace(@Nonnull ItemStack stack) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(stack);
        return EnumFacing.field_82609_l[cpt.func_74771_c("side")];
    }

    @Override
    public IBox getBox(@Nonnull ItemStack item) {
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(item);
        switch (type) {
            case AREA: {
                return ItemMapLocation.getAreaBox(item);
            }
            case SPOT: {
                return ItemMapLocation.getPointBox(item);
            }
        }
        return null;
    }

    @Override
    public EnumFacing getPointSide(@Nonnull ItemStack item) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(item);
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(item);
        if (type == IMapLocation.MapLocationType.SPOT) {
            return EnumFacing.field_82609_l[cpt.func_74771_c("side")];
        }
        return null;
    }

    @Override
    public BlockPos getPoint(@Nonnull ItemStack item) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(item);
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(item);
        if (type == IMapLocation.MapLocationType.SPOT) {
            return new BlockPos(cpt.func_74762_e("x"), cpt.func_74762_e("y"), cpt.func_74762_e("z"));
        }
        return null;
    }

    @Override
    public IZone getZone(@Nonnull ItemStack item) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(item);
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(item);
        switch (type) {
            case ZONE: {
                ZonePlan plan = new ZonePlan();
                plan.readFromNBT(cpt);
                return plan;
            }
            case AREA: {
                return this.getBox(item);
            }
            case PATH: 
            case PATH_REPEATING: {
                return ItemMapLocation.getPointBox(item);
            }
        }
        return null;
    }

    @Override
    public List<BlockPos> getPath(@Nonnull ItemStack item) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(item);
        IMapLocation.MapLocationType type = IMapLocation.MapLocationType.getFromStack(item);
        switch (type) {
            case PATH: 
            case PATH_REPEATING: {
                ArrayList<BlockPos> indexList = new ArrayList<BlockPos>();
                NBTTagList pathNBT = (NBTTagList)cpt.func_74781_a("path");
                for (int i = 0; i < pathNBT.func_74745_c(); ++i) {
                    BlockPos pos = NBTUtilBC.readBlockPos(pathNBT.func_179238_g(i));
                    if (pos == null) continue;
                    indexList.add(pos);
                }
                return indexList;
            }
            case SPOT: {
                ArrayList<BlockPos> indexList = new ArrayList<BlockPos>();
                indexList.add(new BlockPos(cpt.func_74762_e("x"), cpt.func_74762_e("y"), cpt.func_74762_e("z")));
                return indexList;
            }
        }
        return null;
    }

    public static void setZone(@Nonnull ItemStack item, ZonePlan plan) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(item);
        IMapLocation.MapLocationType.ZONE.setToStack(item);
        plan.writeToNBT(cpt);
    }

    @Override
    public String getName(@Nonnull ItemStack item) {
        return NBTUtilBC.getItemData(item).func_74779_i("name");
    }

    @Override
    public boolean setName(@Nonnull ItemStack item, String name) {
        NBTTagCompound cpt = NBTUtilBC.getItemData(item);
        cpt.func_74778_a("name", name);
        return true;
    }
}

