/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.client.render;

import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.marker.volume.Addon;
import buildcraft.core.marker.volume.ClientVolumeBoxes;
import buildcraft.core.marker.volume.Lock;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.Box;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public enum RenderVolumeInWorld implements DetachedRenderer.IDetachedRenderer
{
    INSTANCE;

    private static final double OFFSET_BY = 0.125;
    private static final double RENDER_SCALE = 0.0625;
    private static final double RENDER_SCALE_HIGHLIGHT = 0.06329113924050632;

    @Override
    public void render(EntityPlayer player, float partialTicks) {
        GlStateManager.func_179147_l();
        VertexBuffer vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        ClientVolumeBoxes.INSTANCE.boxes.forEach(box -> {
            RenderVolumeInWorld.makeLaserBox(box.box, box.isEditingBy(player) ? BuildCraftLaserManager.MARKER_VOLUME_SIGNAL : (box.getLockTargetsStream().anyMatch(Lock.Target.TargetUsedByMachine.class::isInstance) ? box.getLockTargetsStream().filter((Predicate<Lock.Target>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lbuildcraft/core/marker/volume/Lock$Target;)Z)(Lock.Target.TargetUsedByMachine.class)).map((Function<Lock.Target, Lock.Target.TargetUsedByMachine>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lbuildcraft/core/marker/volume/Lock$Target;)Lbuildcraft/core/marker/volume/Lock$Target$TargetUsedByMachine;)(Lock.Target.TargetUsedByMachine.class)).map((Function<Lock.Target.TargetUsedByMachine, Lock.Target.TargetUsedByMachine.EnumType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$0(buildcraft.core.marker.volume.Lock$Target$TargetUsedByMachine ), (Lbuildcraft/core/marker/volume/Lock$Target$TargetUsedByMachine;)Lbuildcraft/core/marker/volume/Lock$Target$TargetUsedByMachine$EnumType;)()).filter((Predicate<Lock.Target.TargetUsedByMachine.EnumType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lbuildcraft/core/marker/volume/Lock$Target$TargetUsedByMachine$EnumType;)Z)()).findFirst().orElse((Lock.Target.TargetUsedByMachine.EnumType)Lock.Target.TargetUsedByMachine.EnumType.STRIPES_WRITE).laserType : BuildCraftLaserManager.MARKER_VOLUME_CONNECTED), box.isEditingBy(player) ? 0.06329113924050632 : 0.0625);
            Arrays.stream(box.box.laserData).forEach(data -> LaserRenderer_BC8.renderLaserDynamic(data, vb));
            box.addons.values().forEach(addon -> addon.getRenderer().renderAddonFast((Addon)addon, player, partialTicks, vb));
        });
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179084_k();
    }

    private static void makeLaserBox(Box box, LaserData_BC8.LaserType type, double scale) {
        BlockPos min = box.min();
        BlockPos max = box.max();
        if (min.equals((Object)box.lastMin) && max.equals((Object)box.lastMax) && box.laserData != null) {
            return;
        }
        ArrayList<LaserData_BC8> datas = new ArrayList<LaserData_BC8>();
        Vec3d[][][] vecs = new Vec3d[2][2][2];
        vecs[0][0][0] = new Vec3d((Vec3i)min);
        vecs[1][0][0] = new Vec3d((Vec3i)new BlockPos(max.func_177958_n(), min.func_177956_o(), min.func_177952_p()));
        vecs[0][1][0] = new Vec3d((Vec3i)new BlockPos(min.func_177958_n(), max.func_177956_o(), min.func_177952_p()));
        vecs[1][1][0] = new Vec3d((Vec3i)new BlockPos(max.func_177958_n(), max.func_177956_o(), min.func_177952_p()));
        vecs[0][0][1] = new Vec3d((Vec3i)new BlockPos(min.func_177958_n(), min.func_177956_o(), max.func_177952_p()));
        vecs[1][0][1] = new Vec3d((Vec3i)new BlockPos(max.func_177958_n(), min.func_177956_o(), max.func_177952_p()));
        vecs[0][1][1] = new Vec3d((Vec3i)new BlockPos(min.func_177958_n(), max.func_177956_o(), max.func_177952_p()));
        vecs[1][1][1] = new Vec3d((Vec3i)max);
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    Vec3d offset = new Vec3d((double)(16 * x) / 16.0, (double)(16 * y) / 16.0, (double)(16 * z) / 16.0);
                    vecs[x][y][z] = vecs[x][y][z].func_178787_e(offset);
                }
            }
        }
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[0][0][0], vecs[1][0][0], EnumFacing.Axis.X, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[0][1][0], vecs[1][1][0], EnumFacing.Axis.X, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[0][1][1], vecs[1][1][1], EnumFacing.Axis.X, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[0][0][1], vecs[1][0][1], EnumFacing.Axis.X, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[0][0][0], vecs[0][1][0], EnumFacing.Axis.Y, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[1][0][0], vecs[1][1][0], EnumFacing.Axis.Y, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[1][0][1], vecs[1][1][1], EnumFacing.Axis.Y, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[0][0][1], vecs[0][1][1], EnumFacing.Axis.Y, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[0][0][0], vecs[0][0][1], EnumFacing.Axis.Z, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[1][0][0], vecs[1][0][1], EnumFacing.Axis.Z, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[1][1][0], vecs[1][1][1], EnumFacing.Axis.Z, scale));
        datas.add(RenderVolumeInWorld.makeLaser(type, vecs[0][1][0], vecs[0][1][1], EnumFacing.Axis.Z, scale));
        box.laserData = datas.toArray(new LaserData_BC8[datas.size()]);
        box.lastMin = min;
        box.lastMax = max;
    }

    private static LaserData_BC8 makeLaser(LaserData_BC8.LaserType type, Vec3d min, Vec3d max, EnumFacing.Axis axis, double scale) {
        switch (axis) {
            case X: {
                min = new Vec3d(min.field_72450_a - 0.0625, min.field_72448_b, min.field_72449_c);
                max = new Vec3d(max.field_72450_a + 0.0625, max.field_72448_b, max.field_72449_c);
                break;
            }
            case Y: {
                min = new Vec3d(min.field_72450_a, min.field_72448_b - 0.0625, min.field_72449_c);
                max = new Vec3d(max.field_72450_a, max.field_72448_b + 0.0625, max.field_72449_c);
                break;
            }
            case Z: {
                min = new Vec3d(min.field_72450_a, min.field_72448_b, min.field_72449_c - 0.0625);
                max = new Vec3d(max.field_72450_a, max.field_72448_b, max.field_72449_c + 0.0625);
            }
        }
        EnumFacing faceForMin = VecUtil.getFacing(axis, true);
        EnumFacing faceForMax = VecUtil.getFacing(axis, false);
        Vec3d one = min.func_178787_e(new Vec3d(faceForMin.func_176730_m()).func_186678_a(0.125));
        Vec3d two = max.func_178787_e(new Vec3d(faceForMax.func_176730_m()).func_186678_a(0.125));
        return new LaserData_BC8(type, one, two, scale, true, false, 0);
    }

    private static /* synthetic */ Lock.Target.TargetUsedByMachine.EnumType lambda$null$0(Lock.Target.TargetUsedByMachine target) {
        return target.type;
    }
}

