/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.client.render;

import buildcraft.core.BCCoreConfig;
import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.marker.VolumeConnection;
import buildcraft.core.tile.TileMarkerVolume;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import buildcraft.lib.misc.VecUtil;
import com.google.common.collect.ImmutableSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class RenderMarkerVolume
extends TileEntitySpecialRenderer<TileMarkerVolume> {
    private static final double SCALE = 0.0617283950617284;
    public static final RenderMarkerVolume INSTANCE = new RenderMarkerVolume();
    private static final LaserData_BC8.LaserType LASER_TYPE = BuildCraftLaserManager.MARKER_VOLUME_SIGNAL;
    private static final Vec3d VEC_HALF = new Vec3d(0.5, 0.5, 0.5);

    public boolean isGlobalRenderer(TileMarkerVolume te) {
        return true;
    }

    public void renderTileEntityAt(TileMarkerVolume marker, double tileX, double tileY, double tileZ, float partialTicks, int destroyStage) {
        if (marker == null || !marker.isShowingSignals()) {
            return;
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("marker");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("volume");
        DetachedRenderer.fromWorldOriginPre((EntityPlayer)Minecraft.func_71410_x().field_71439_g, partialTicks);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        VolumeConnection volume = (VolumeConnection)marker.getCurrentConnection();
        Object taken = volume == null ? ImmutableSet.of() : volume.getConnectedAxis();
        Vec3d start = VecUtil.add(VEC_HALF, (Vec3i)marker.func_174877_v());
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (taken.contains(face.func_176740_k())) continue;
            Vec3d end = VecUtil.offset(start, face, BCCoreConfig.markerMaxDistance);
            RenderMarkerVolume.renderLaser(start, end, face.func_176740_k());
        }
        RenderHelper.func_74519_b();
        DetachedRenderer.fromWorldOriginPost();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private static void renderLaser(Vec3d min, Vec3d max, EnumFacing.Axis axis) {
        EnumFacing faceForMin = VecUtil.getFacing(axis, true);
        EnumFacing faceForMax = VecUtil.getFacing(axis, false);
        Vec3d one = RenderMarkerVolume.offset(min, faceForMin);
        Vec3d two = RenderMarkerVolume.offset(max, faceForMax);
        LaserData_BC8 data = new LaserData_BC8(LASER_TYPE, one, two, 0.0617283950617284);
        LaserRenderer_BC8.renderLaserStatic(data);
    }

    private static Vec3d offset(Vec3d vec, EnumFacing face) {
        double by = 0.0625;
        if (face == EnumFacing.DOWN) {
            return vec.func_72441_c(0.0, -by, 0.0);
        }
        if (face == EnumFacing.UP) {
            return vec.func_72441_c(0.0, by, 0.0);
        }
        if (face == EnumFacing.EAST) {
            return vec.func_72441_c(by, 0.0, 0.0);
        }
        if (face == EnumFacing.WEST) {
            return vec.func_72441_c(-by, 0.0, 0.0);
        }
        if (face == EnumFacing.SOUTH) {
            return vec.func_72441_c(0.0, 0.0, by);
        }
        return vec.func_72441_c(0.0, 0.0, -by);
    }
}

