/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.block;

import buildcraft.api.enums.EnumSpring;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.misc.data.XorShift128Random;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockSpring
extends BlockBCBase_Neptune {
    public static final IProperty<EnumSpring> SPRING_TYPE = BuildCraftProperties.SPRING_TYPE;
    public static final XorShift128Random rand = new XorShift128Random();

    public BlockSpring(String id) {
        super(Material.field_151576_e, id);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149649_H();
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a(SPRING_TYPE, (Comparable)((Object)EnumSpring.WATER)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SPRING_TYPE});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumSpring)((Object)state.func_177229_b(SPRING_TYPE))).ordinal();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        if (meta == EnumSpring.OIL.ordinal()) {
            return this.func_176223_P().func_177226_a(SPRING_TYPE, (Comparable)((Object)EnumSpring.OIL));
        }
        return this.func_176223_P().func_177226_a(SPRING_TYPE, (Comparable)((Object)EnumSpring.WATER));
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumSpring type : EnumSpring.VALUES) {
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumSpring)((Object)state.func_177229_b(SPRING_TYPE))).ordinal();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        this.generateSpringBlock(world, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return ((EnumSpring)((Object)state.func_177229_b(BlockSpring.SPRING_TYPE))).tileConstructor != null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        Supplier<TileEntity> constructor = ((EnumSpring)((Object)state.func_177229_b(BlockSpring.SPRING_TYPE))).tileConstructor;
        if (constructor != null) {
            return constructor.get();
        }
        return null;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175684_a(pos, (Block)this, ((EnumSpring)((Object)state.func_177229_b(BlockSpring.SPRING_TYPE))).tickRate);
    }

    private void generateSpringBlock(World world, BlockPos pos, IBlockState state) {
        EnumSpring spring = (EnumSpring)((Object)state.func_177229_b(SPRING_TYPE));
        world.func_175684_a(pos, (Block)this, spring.tickRate);
        if (!spring.canGen || spring.liquidBlock == null) {
            return;
        }
        if (!world.func_175623_d(pos.func_177984_a())) {
            return;
        }
        if (spring.chance != -1 && rand.nextInt(spring.chance) != 0) {
            return;
        }
        world.func_175656_a(pos.func_177984_a(), spring.liquidBlock);
    }
}

