/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.enums.EnumPowerStage;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.client.render.RenderEngineCreative;
import buildcraft.core.client.render.RenderEngineWood;
import buildcraft.core.client.render.RenderMarkerVolume;
import buildcraft.core.tile.TileEngineCreative;
import buildcraft.core.tile.TileEngineRedstone_BC8;
import buildcraft.core.tile.TileMarkerVolume;
import buildcraft.lib.client.model.ModelHolderVariable;
import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableString;
import buildcraft.lib.misc.data.ModelVariableData;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCCoreModels {
    private static final NodeVariableDouble ENGINE_PROGRESS;
    private static final NodeVariableString ENGINE_STAGE;
    private static final NodeVariableString ENGINE_FACING;
    private static final ModelHolderVariable ENGINE_REDSTONE;
    private static final ModelHolderVariable ENGINE_CREATIVE;

    private static ModelHolderVariable getModel(String loc, FunctionContext fnCtx) {
        return new ModelHolderVariable("buildcraftcore:models/" + loc, fnCtx);
    }

    public static void fmlPreInit() {
        MinecraftForge.EVENT_BUS.register(BCCoreModels.class);
        ModelLoader.setCustomStateMapper((Block)BCCoreBlocks.engine, b -> ImmutableMap.of());
    }

    public static void fmlInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileMarkerVolume.class, (TileEntitySpecialRenderer)RenderMarkerVolume.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineRedstone_BC8.class, (TileEntitySpecialRenderer)RenderEngineWood.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineCreative.class, (TileEntitySpecialRenderer)RenderEngineCreative.INSTANCE);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        BCCoreModels.ENGINE_PROGRESS.value = 0.2;
        BCCoreModels.ENGINE_STAGE.value = EnumPowerStage.BLUE.getModelName();
        BCCoreModels.ENGINE_FACING.value = EnumFacing.UP.func_176610_l();
        ModelVariableData varData = new ModelVariableData();
        varData.setNodes(ENGINE_REDSTONE.createTickableNodes());
        varData.tick();
        varData.refresh();
        ArrayList<Object> quads = new ArrayList<BakedQuad>();
        for (MutableQuad quad : ENGINE_REDSTONE.getCutoutQuads()) {
            quads.add(quad.toBakedItem());
        }
        BCCoreModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, EnumEngineType.WOOD.getItemModelLocation() + "#inventory", new ModelItemSimple(quads, ModelItemSimple.TRANSFORM_BLOCK));
        quads = new ArrayList();
        BCCoreModels.ENGINE_STAGE.value = EnumPowerStage.BLACK.getModelName();
        varData.setNodes(ENGINE_CREATIVE.createTickableNodes());
        varData.tick();
        varData.refresh();
        for (MutableQuad quad : ENGINE_CREATIVE.getCutoutQuads()) {
            quads.add(quad.toBakedItem());
        }
        BCCoreModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, EnumEngineType.CREATIVE.getItemModelLocation() + "#inventory", new ModelItemSimple(quads, ModelItemSimple.TRANSFORM_BLOCK));
    }

    private static void registerModel(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, String reg, IBakedModel val) {
        modelRegistry.func_82595_a((Object)new ModelResourceLocation(reg), (Object)val);
    }

    private static MutableQuad[] getEngineQuads(ModelHolderVariable model, TileEngineBase_BC8 tile, float partialTicks) {
        BCCoreModels.ENGINE_PROGRESS.value = tile.getProgressClient(partialTicks);
        BCCoreModels.ENGINE_STAGE.value = tile.getPowerStage().getModelName();
        BCCoreModels.ENGINE_FACING.value = tile.getCurrentFacing().func_176610_l();
        if (tile.clientModelData.hasNoNodes()) {
            tile.clientModelData.setNodes(model.createTickableNodes());
        }
        tile.clientModelData.refresh();
        return model.getCutoutQuads();
    }

    public static MutableQuad[] getRedstoneEngineQuads(TileEngineRedstone_BC8 tile, float partialTicks) {
        return BCCoreModels.getEngineQuads(ENGINE_REDSTONE, tile, partialTicks);
    }

    public static MutableQuad[] getCreativeEngineQuads(TileEngineCreative tile, float partialTicks) {
        return BCCoreModels.getEngineQuads(ENGINE_CREATIVE, tile, partialTicks);
    }

    static {
        FunctionContext fnCtx = DefaultContexts.createWithAll();
        ENGINE_PROGRESS = fnCtx.putVariableDouble("progress");
        ENGINE_STAGE = fnCtx.putVariableString("stage");
        ENGINE_FACING = fnCtx.putVariableString("facing");
        ENGINE_REDSTONE = BCCoreModels.getModel("block/engine_redstone.json", fnCtx);
        ENGINE_CREATIVE = BCCoreModels.getModel("block/engine_creative.json", fnCtx);
    }
}

