/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.BCAchievements;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.BCCoreConfig;
import buildcraft.core.BCCoreEventDist;
import buildcraft.core.BCCoreItems;
import buildcraft.core.BCCoreProxy;
import buildcraft.core.BCCoreRecipes;
import buildcraft.core.BCCoreStatements;
import buildcraft.core.list.ListTooltipHandler;
import buildcraft.core.marker.PathCache;
import buildcraft.core.marker.VolumeCache;
import buildcraft.core.marker.volume.MessageVolumeBoxes;
import buildcraft.lib.BCLibItems;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.registry.CreativeTabManager;
import buildcraft.lib.registry.TagManager;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="buildcraftcore", name="BuildCraft Core", version="7.99.7", dependencies="required-after:buildcraftlib@[7.99.7]", guiFactory="buildcraft.core.client.ConfigGuiFactoryBC", acceptedMinecraftVersions="[1.11.2]")
public class BCCore {
    public static final String MODID = "buildcraftcore";
    @Mod.Instance(value="buildcraftcore")
    public static BCCore INSTANCE = null;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        File cfgFolder = event.getModConfigurationDirectory();
        cfgFolder = new File(cfgFolder, "buildcraft");
        BCCoreConfig.preInit(cfgFolder);
        CreativeTabManager.CreativeTabBC tab = CreativeTabManager.createTab("buildcraft.main");
        BCCoreItems.preInit();
        BCCoreBlocks.preInit();
        BCCoreStatements.preInit();
        BCCoreProxy.getProxy().fmlPreInit();
        tab.setItem(BCCoreItems.wrench);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)BCCoreProxy.getProxy());
        MinecraftForge.EVENT_BUS.register((Object)ListTooltipHandler.INSTANCE);
        OreDictionary.registerOre((String)"craftingTableWood", (Block)Blocks.field_150462_ai);
        MinecraftForge.EVENT_BUS.register((Object)BCCoreEventDist.INSTANCE);
        MessageManager.addMessageType(MessageVolumeBoxes.class, MessageVolumeBoxes.HANDLER, Side.CLIENT);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        BCCoreProxy.getProxy().fmlInit();
        BCCoreRecipes.init();
        BCAchievements.init();
        MarkerCache.registerCache(VolumeCache.INSTANCE);
        MarkerCache.registerCache(PathCache.INSTANCE);
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        BCCoreProxy.getProxy().fmlPostInit();
        BCCoreConfig.postInit();
    }

    private static TagManager.TagEntry registerTag(String id) {
        return TagManager.registerTag(id);
    }

    private static void startBatch() {
        TagManager.startBatch();
    }

    private static void endBatch(Consumer<TagManager.TagEntry> consumer) {
        TagManager.endBatch(consumer);
    }

    static {
        BCLibItems.enableGuide();
        BCLibItems.enableDebugger();
        BCCore.startBatch();
        BCCore.registerTag("item.wrench").reg("wrench").locale("wrenchItem").oldReg("wrenchItem").model("wrench");
        BCCore.registerTag("item.diamond.shard").reg("diamond_shard").locale("diamondShard").model("diamond_shard").tab("vanilla.materials");
        BCCore.registerTag("item.gear.wood").reg("gear_wood").locale("woodenGearItem").oreDict("gearWood").oldReg("woodenGearItem").model("gears/wood");
        BCCore.registerTag("item.gear.stone").reg("gear_stone").locale("stoneGearItem").oreDict("gearStone").oldReg("stoneGearItem").model("gears/stone");
        BCCore.registerTag("item.gear.iron").reg("gear_iron").locale("ironGearItem").oreDict("gearIron").oldReg("ironGearItem").model("gears/iron");
        BCCore.registerTag("item.gear.gold").reg("gear_gold").locale("goldGearItem").oreDict("gearGold").oldReg("goldGearItem").model("gears/gold");
        BCCore.registerTag("item.gear.diamond").reg("gear_diamond").locale("diamondGearItem").oreDict("gearDiamond").oldReg("diamondGearItem").model("gears/diamond");
        BCCore.registerTag("item.list").reg("list").locale("list").oldReg("listItem").model("list_");
        BCCore.registerTag("item.map_location").reg("map_location").locale("mapLocation").oldReg("mapLocation").model("map_location/");
        BCCore.registerTag("item.paintbrush").reg("paintbrush").locale("paintbrush").model("paintbrush/");
        BCCore.registerTag("item.marker_connector").reg("marker_connector").locale("markerConnector").model("marker_connector");
        BCCore.registerTag("item.volume_box").reg("volume_box").locale("volume_box").model("volume_box");
        BCCore.registerTag("item.goggles").reg("goggles").locale("goggles").model("goggles");
        BCCore.registerTag("item.block.marker.volume").reg("marker_volume").locale("markerBlock").oldReg("markerBlock").model("marker_volume");
        BCCore.registerTag("item.block.marker.path").reg("marker_path").locale("pathMarkerBlock").oldReg("pathMarkerBlock").model("marker_path");
        BCCore.registerTag("item.block.spring").reg("spring").locale("spring").model("spring");
        BCCore.registerTag("item.block.decorated").reg("decorated").locale("decorated").model("decorated/");
        TagManager.TagEntry engine = BCCore.registerTag("item.block.engine.bc").reg("engine").locale("engineBlock");
        BCCore.registerTag("block.spring").reg("spring").locale("spring");
        BCCore.registerTag("block.decorated").reg("decorated").locale("decorated");
        BCCore.registerTag("block.engine.bc").reg("engine").locale("engineBlock").oldReg("engineBlock");
        BCCore.registerTag("block.engine.bc.wood").locale("engineWood");
        BCCore.registerTag("block.engine.bc.stone").locale("engineStone");
        BCCore.registerTag("block.engine.bc.iron").locale("engineIron");
        BCCore.registerTag("block.engine.bc.creative").locale("engineCreative");
        BCCore.registerTag("block.marker.volume").reg("marker_volume").locale("markerBlock").oldReg("markerBlock").model("marker_volume");
        BCCore.registerTag("block.marker.path").reg("marker_path").locale("pathMarkerBlock").oldReg("pathMarkerBlock").model("marker_path");
        BCCore.registerTag("tile.marker.volume").reg("marker.volume").oldReg("buildcraft.builders.Marker", "Marker");
        BCCore.registerTag("tile.marker.path").reg("marker.path");
        BCCore.registerTag("tile.engine.wood").reg("engine.wood");
        BCCore.registerTag("tile.engine.creative").reg("engine.creative");
        BCCore.endBatch(TagManager.prependTags("buildcraftcore:", TagManager.EnumTagType.REGISTRY_NAME, TagManager.EnumTagType.MODEL_LOCATION).andThen(TagManager.setTab("buildcraft.main")));
        engine.model("");
    }
}

