/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.tile;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.builders.BCBuildersBlocks;
import buildcraft.builders.BCBuildersEventDist;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.chunkload.ChunkLoaderManager;
import buildcraft.lib.chunkload.IChunkLoadingTile;
import buildcraft.lib.inventory.AutomaticProvidingTransactor;
import buildcraft.lib.inventory.TransactorEntityItem;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.AxisOrder;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.misc.data.BoxIterator;
import buildcraft.lib.misc.data.EnumAxisOrder;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.world.WorldEventListenerAdapter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileQuarry
extends TileBC_Neptune
implements ITickable,
IDebuggable,
IChunkLoadingTile {
    private static final long MAX_MJ_PER_TICK = 64000000L;
    private final MjBattery battery = new MjBattery(16000000000L);
    public final Box frameBox = new Box();
    private final Box miningBox = new Box();
    private BoxIterator boxIterator;
    public final List<BlockPos> framePoses = new ArrayList<BlockPos>();
    private int frameBoxPosesCount = 0;
    private final LinkedList<BlockPos> toCheck = new LinkedList();
    private final Set<BlockPos> firstCheckedPoses = new HashSet<BlockPos>();
    private boolean firstChecked = false;
    private final Set<BlockPos> frameBreakBlockPoses = new TreeSet<BlockPos>(Comparator.comparingDouble(arg_0 -> ((BlockPos)this.field_174879_c).func_177951_i(arg_0)));
    private final Set<BlockPos> framePlaceFramePoses = new HashSet<BlockPos>();
    public Task currentTask = null;
    public Vec3d drillPos;
    public Vec3d clientDrillPos;
    public Vec3d prevClientDrillPos;
    private long debugPowerRate = 0L;
    private final IWorldEventListener worldEventListener = new WorldEventListenerAdapter(){

        @Override
        public void func_184376_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, int flags) {
            if (TileQuarry.this.frameBox.isInitialized() && TileQuarry.this.miningBox.isInitialized()) {
                if (TileQuarry.this.frameBox.contains(pos)) {
                    TileQuarry.this.check(pos);
                } else if (TileQuarry.this.miningBox.contains(pos) && !world.func_175623_d(pos) && !TileQuarry.this.canSkip(pos) && TileQuarry.this.boxIterator != null) {
                    BoxIterator tempBoxIterator = TileQuarry.this.createBoxIterator();
                    while (!Objects.equals(tempBoxIterator.getCurrent(), pos)) {
                        if (tempBoxIterator.advance() == null) {
                            return;
                        }
                        if (!Objects.equals(tempBoxIterator.getCurrent(), TileQuarry.this.boxIterator.getCurrent())) continue;
                        return;
                    }
                    TileQuarry.this.boxIterator = tempBoxIterator;
                }
            }
        }
    };

    public TileQuarry() {
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.battery)));
        this.caps.addCapabilityInstance(CapUtil.CAP_ITEM_TRANSACTOR, AutomaticProvidingTransactor.INSTANCE, EnumPipePart.VALUES);
    }

    @Nonnull
    private BoxIterator createBoxIterator() {
        return new BoxIterator(this.miningBox, AxisOrder.getFor(EnumAxisOrder.XZY, AxisOrder.Inversion.NNN), true);
    }

    private List<BlockPos> getFramePoses(IBlockState state) {
        ArrayList<BlockPos> framePositions = new ArrayList<BlockPos>();
        BlockPos min = this.frameBox.min();
        BlockPos max = this.frameBox.max();
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            framePositions.add(new BlockPos(x, min.func_177956_o(), min.func_177952_p()));
            framePositions.add(new BlockPos(x, max.func_177956_o(), min.func_177952_p()));
            framePositions.add(new BlockPos(x, min.func_177956_o(), max.func_177952_p()));
            framePositions.add(new BlockPos(x, max.func_177956_o(), max.func_177952_p()));
        }
        for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
            framePositions.add(new BlockPos(min.func_177958_n(), min.func_177956_o(), z));
            framePositions.add(new BlockPos(max.func_177958_n(), min.func_177956_o(), z));
            framePositions.add(new BlockPos(min.func_177958_n(), max.func_177956_o(), z));
            framePositions.add(new BlockPos(max.func_177958_n(), max.func_177956_o(), z));
        }
        for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
            framePositions.add(new BlockPos(min.func_177958_n(), y, min.func_177952_p()));
            framePositions.add(new BlockPos(max.func_177958_n(), y, min.func_177952_p()));
            framePositions.add(new BlockPos(min.func_177958_n(), y, max.func_177952_p()));
            framePositions.add(new BlockPos(max.func_177958_n(), y, max.func_177952_p()));
        }
        framePositions = new ArrayList(new HashSet(framePositions));
        framePositions.sort(Comparator.comparing(blockPos -> Math.pow(blockPos.func_177958_n() - this.field_174879_c.func_177958_n(), 2.0) + Math.pow(blockPos.func_177956_o() - this.field_174879_c.func_177956_o(), 2.0) + Math.pow(blockPos.func_177952_p() - this.field_174879_c.func_177952_p(), 2.0)));
        ArrayList<BlockPos> framePositionsSorted = new ArrayList<BlockPos>();
        EnumFacing facing = ((EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176734_d();
        framePositionsSorted.add(this.field_174879_c.func_177972_a(facing));
        block3: while (framePositions.size() != framePositionsSorted.size()) {
            for (BlockPos blockPos2 : framePositions) {
                if (framePositionsSorted.contains(blockPos2) || !framePositionsSorted.stream().flatMap(blockPosLocal -> Arrays.stream(EnumFacing.field_82609_l).map(arg_0 -> ((BlockPos)blockPosLocal).func_177972_a(arg_0))).anyMatch(Predicate.isEqual(blockPos2))) continue;
                framePositionsSorted.add(blockPos2);
                continue block3;
            }
        }
        return framePositionsSorted;
    }

    private boolean shouldBeFrame(BlockPos p) {
        boolean shouldBeFrameXY = !(p.func_177958_n() != this.frameBox.min().func_177958_n() && p.func_177958_n() != this.frameBox.max().func_177958_n() || p.func_177956_o() != this.frameBox.min().func_177956_o() && p.func_177956_o() != this.frameBox.max().func_177956_o());
        boolean shouldBeFrameYZ = !(p.func_177956_o() != this.frameBox.min().func_177956_o() && p.func_177956_o() != this.frameBox.max().func_177956_o() || p.func_177952_p() != this.frameBox.min().func_177952_p() && p.func_177952_p() != this.frameBox.max().func_177952_p());
        boolean shouldBeFrameZX = !(p.func_177952_p() != this.frameBox.min().func_177952_p() && p.func_177952_p() != this.frameBox.max().func_177952_p() || p.func_177958_n() != this.frameBox.min().func_177958_n() && p.func_177958_n() != this.frameBox.max().func_177958_n());
        return shouldBeFrameXY || shouldBeFrameYZ || shouldBeFrameZX;
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        BlockPos max;
        BlockPos min;
        super.onPlacedBy(placer, stack);
        if (placer.field_70170_p.field_72995_K) {
            return;
        }
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        BlockPos areaPos = this.field_174879_c.func_177972_a(facing.func_176734_d());
        TileEntity tile = this.field_145850_b.func_175625_s(areaPos);
        if (tile instanceof IAreaProvider) {
            IAreaProvider provider = (IAreaProvider)tile;
            min = provider.min();
            max = provider.max();
            provider.removeFromWorld();
        } else {
            this.miningBox.reset();
            this.frameBox.reset();
            switch (facing.func_176734_d()) {
                default: {
                    min = this.field_174879_c.func_177982_a(1, 0, -5);
                    max = this.field_174879_c.func_177982_a(11, 4, 5);
                    break;
                }
                case WEST: {
                    min = this.field_174879_c.func_177982_a(-11, 0, -5);
                    max = this.field_174879_c.func_177982_a(-1, 4, 5);
                    break;
                }
                case SOUTH: {
                    min = this.field_174879_c.func_177982_a(-5, 0, 1);
                    max = this.field_174879_c.func_177982_a(5, 4, 11);
                    break;
                }
                case NORTH: {
                    min = this.field_174879_c.func_177982_a(-5, 0, -11);
                    max = this.field_174879_c.func_177982_a(5, 4, -1);
                }
            }
        }
        if (max.func_177956_o() - min.func_177956_o() < 4) {
            max = new BlockPos(max.func_177958_n(), min.func_177956_o() + 4, max.func_177952_p());
        }
        this.frameBox.reset();
        this.frameBox.setMin(min);
        this.frameBox.setMax(max);
        this.miningBox.reset();
        this.miningBox.setMin(new BlockPos(min.func_177958_n() + 1, 0, min.func_177952_p() + 1));
        this.miningBox.setMax(new BlockPos(max.func_177958_n() - 1, max.func_177956_o() - 1, max.func_177952_p() - 1));
        this.updatePoses();
    }

    private boolean canNotMine(BlockPos blockPos) {
        if (this.field_145850_b.func_180495_p(blockPos).func_185887_b(this.field_145850_b, blockPos) < 0.0f) {
            return true;
        }
        Fluid fluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, blockPos);
        return fluid != null && fluid.getViscosity() > 1000;
    }

    private boolean canSkip(BlockPos blockPos) {
        Fluid fluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, blockPos);
        return fluid != null && fluid.getViscosity() <= 1000;
    }

    private void check(BlockPos blockPos) {
        this.frameBreakBlockPoses.remove(blockPos);
        this.framePlaceFramePoses.remove(blockPos);
        if (this.shouldBeFrame(blockPos)) {
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != BCBuildersBlocks.frame) {
                if (!this.field_145850_b.func_175623_d(blockPos)) {
                    this.frameBreakBlockPoses.add(blockPos);
                } else {
                    this.framePlaceFramePoses.add(blockPos);
                }
            }
        } else if (!this.field_145850_b.func_175623_d(blockPos)) {
            this.frameBreakBlockPoses.add(blockPos);
        }
        if (!this.firstChecked) {
            this.firstCheckedPoses.add(blockPos);
            if (this.firstCheckedPoses.size() >= this.frameBoxPosesCount) {
                this.firstChecked = true;
            }
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.updatePoses();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        BCBuildersEventDist.INSTANCE.validateQuarry(this);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72954_a(this.worldEventListener);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        BCBuildersEventDist.INSTANCE.invalidateQuarry(this);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72848_b(this.worldEventListener);
            ChunkLoaderManager.releaseChunksFor(this);
        }
    }

    @Override
    @Nullable
    public IChunkLoadingTile.LoadType getLoadType() {
        return IChunkLoadingTile.LoadType.HARD;
    }

    @Override
    @Nullable
    public Collection<ChunkPos> getChunksToLoad() {
        if (!this.miningBox.isInitialized()) {
            return null;
        }
        ArrayList<ChunkPos> list = new ArrayList<ChunkPos>();
        int minX = this.miningBox.min().func_177958_n() >> 4;
        int minZ = this.miningBox.min().func_177952_p() >> 4;
        int maxX = this.miningBox.max().func_177958_n() >> 4;
        int maxZ = this.miningBox.max().func_177952_p() >> 4;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                list.add(new ChunkPos(x, z));
            }
        }
        return list;
    }

    private void updatePoses() {
        this.framePoses.clear();
        this.frameBoxPosesCount = 0;
        this.toCheck.clear();
        this.firstCheckedPoses.clear();
        this.firstChecked = false;
        this.frameBreakBlockPoses.clear();
        this.framePlaceFramePoses.clear();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BCBuildersBlocks.quarry && this.frameBox.isInitialized()) {
            List<BlockPos> blocksInArea = this.frameBox.getBlocksInArea();
            this.frameBoxPosesCount = blocksInArea.size();
            this.toCheck.addAll(blocksInArea);
            this.framePoses.addAll(this.getFramePoses(state));
            ChunkLoaderManager.loadChunksForTile(this);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.prevClientDrillPos = this.clientDrillPos;
            this.clientDrillPos = this.drillPos;
            if (this.currentTask != null) {
                this.currentTask.clientTick();
            }
            return;
        }
        if (!this.frameBox.isInitialized() || !this.miningBox.isInitialized()) {
            return;
        }
        if (!this.toCheck.isEmpty()) {
            for (int i = 0; i < (this.firstChecked ? 10 : 50); ++i) {
                BlockPos blockPos = this.toCheck.pollFirst();
                this.check(blockPos);
                this.toCheck.addLast(blockPos);
            }
        }
        if (this.currentTask != null) {
            long max = 64000000L;
            max *= this.battery.getStored() + max;
            max /= this.battery.getCapacity() / 2L;
            this.debugPowerRate = max = Math.min(max, 64000000L);
            long power = this.battery.extractPower(0L, max);
            if (this.currentTask.addPower(power)) {
                this.currentTask = null;
            }
            this.sendNetworkUpdate(NET_RENDER_DATA);
            return;
        }
        if (!this.firstChecked) {
            return;
        }
        if (!this.frameBreakBlockPoses.isEmpty()) {
            BlockPos blockPos = this.frameBreakBlockPoses.iterator().next();
            if (!this.canNotMine(blockPos)) {
                this.drillPos = null;
                this.currentTask = new TaskBreakBlock(blockPos);
                this.sendNetworkUpdate(NET_RENDER_DATA);
            }
            this.check(blockPos);
            return;
        }
        if (!this.framePlaceFramePoses.isEmpty()) {
            for (BlockPos blockPos : this.framePoses) {
                if (!this.framePlaceFramePoses.contains(blockPos)) continue;
                this.check(blockPos);
                if (!this.framePlaceFramePoses.contains(blockPos)) continue;
                this.drillPos = null;
                this.currentTask = new TaskAddFrame(blockPos);
                this.sendNetworkUpdate(NET_RENDER_DATA);
                return;
            }
        }
        if (this.boxIterator == null || this.drillPos == null) {
            this.boxIterator = this.createBoxIterator();
            while ((this.field_145850_b.func_175623_d(this.boxIterator.getCurrent()) || this.canSkip(this.boxIterator.getCurrent())) && this.boxIterator.advance() != null) {
            }
            this.drillPos = new Vec3d((Vec3i)this.miningBox.closestInsideTo(this.field_174879_c));
        }
        if (this.boxIterator != null && this.boxIterator.hasNext()) {
            boolean found = false;
            Vec3d vec3d = new Vec3d((Vec3i)this.boxIterator.getCurrent());
            if (this.drillPos.func_72436_e(vec3d) >= 1.0) {
                this.currentTask = new TaskMoveDrill(this.drillPos, new Vec3d((Vec3i)this.boxIterator.getCurrent()));
                found = true;
            } else if (!this.field_145850_b.func_175623_d(this.boxIterator.getCurrent()) && !this.canSkip(this.boxIterator.getCurrent())) {
                if (!this.canNotMine(this.boxIterator.getCurrent())) {
                    this.currentTask = new TaskBreakBlock(this.boxIterator.getCurrent());
                    found = true;
                }
            } else {
                found = true;
                BlockPos next = this.boxIterator.advance();
                this.currentTask = next == null ? null : new TaskMoveDrill(this.drillPos, new Vec3d((Vec3i)next));
            }
            if (found) {
                this.sendNetworkUpdate(NET_RENDER_DATA);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("box", (NBTBase)this.miningBox.writeToNBT());
        nbt.func_74782_a("frame", (NBTBase)this.frameBox.writeToNBT());
        if (this.boxIterator != null) {
            nbt.func_74782_a("boxIterator", (NBTBase)this.boxIterator.writeToNbt());
        }
        nbt.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
        if (this.currentTask != null) {
            nbt.func_74774_a("currentTaskId", (byte)((EnumTaskType)Arrays.stream(EnumTaskType.values()).filter(type -> type.clazz == this.currentTask.getClass()).findFirst().orElse(null)).ordinal());
            nbt.func_74782_a("currentTaskData", (NBTBase)this.currentTask.serializeNBT());
        }
        if (this.drillPos != null) {
            nbt.func_74782_a("drillPos", (NBTBase)NBTUtilBC.writeVec3d(this.drillPos));
        }
        nbt.func_74757_a("firstChecked", this.firstChecked);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.miningBox.initialize(nbt.func_74775_l("box"));
        this.frameBox.initialize(nbt.func_74775_l("frame"));
        this.boxIterator = BoxIterator.readFromNbt(nbt.func_74775_l("boxIterator"));
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        if (nbt.func_74764_b("currentTask")) {
            this.currentTask = EnumTaskType.values()[nbt.func_74771_c((String)"currentTaskId")].supplier.apply(this);
            this.currentTask.readFromNBT(nbt.func_74775_l("currentTaskData"));
        } else {
            this.currentTask = null;
        }
        this.drillPos = NBTUtilBC.readVec3d(nbt.func_74781_a("drillPos"));
        this.firstChecked = nbt.func_74767_n("firstChecked");
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            this.frameBox.writeData(buffer);
            this.miningBox.writeData(buffer);
            buffer.writeBoolean(this.drillPos != null);
            if (this.drillPos != null) {
                MessageUtil.writeVec3d(buffer, this.drillPos);
            }
            buffer.writeBoolean(this.currentTask != null);
            if (this.currentTask != null) {
                buffer.writeByte((byte)((EnumTaskType)Arrays.stream(EnumTaskType.values()).filter(type -> type.clazz == this.currentTask.getClass()).findFirst().orElse(null)).ordinal());
                for (int i = 0; i < 2; ++i) {
                    this.currentTask.toBytes(buffer);
                }
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_RENDER_DATA) {
            this.frameBox.readData(buffer);
            this.miningBox.readData(buffer);
            this.drillPos = buffer.readBoolean() ? MessageUtil.readVec3d(buffer) : null;
            if (buffer.readBoolean()) {
                byte taskId = buffer.readByte();
                Task task = EnumTaskType.values()[taskId].supplier.apply(this);
                task.fromBytes(buffer);
                if (this.currentTask == null || !this.currentTask.equals(task)) {
                    this.currentTask = task;
                    Task tempTask = EnumTaskType.values()[taskId].supplier.apply(this);
                    tempTask.fromBytes(buffer);
                } else {
                    this.currentTask.fromBytes(buffer);
                }
            } else {
                this.currentTask = null;
            }
        }
    }

    public Iterable<AxisAlignedBB> getCollisionBoxes() {
        Vec3d realDrillPos;
        if (!this.frameBox.isInitialized() || this.drillPos == null) {
            return ImmutableList.of();
        }
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(3);
        Vec3d min = VecUtil.convertCenter((Vec3i)this.frameBox.min());
        Vec3d max = VecUtil.convertCenter((Vec3i)this.frameBox.max());
        min = VecUtil.replaceValue(min, EnumFacing.Axis.Y, max.field_72448_b);
        Vec3d minXAdj = VecUtil.replaceValue(min, EnumFacing.Axis.X, this.drillPos.field_72450_a + 0.5);
        Vec3d maxXAdj = VecUtil.replaceValue(max, EnumFacing.Axis.X, this.drillPos.field_72450_a + 0.5);
        list.add(BoundingBoxUtil.makeFrom(minXAdj, maxXAdj, 0.25));
        Vec3d minZAdj = VecUtil.replaceValue(min, EnumFacing.Axis.Z, this.drillPos.field_72449_c + 0.5);
        Vec3d maxZAdj = VecUtil.replaceValue(max, EnumFacing.Axis.Z, this.drillPos.field_72449_c + 0.5);
        list.add(BoundingBoxUtil.makeFrom(minZAdj, maxZAdj, 0.25));
        Vec3d minYAdj = realDrillPos = this.drillPos.func_72441_c(0.5, 0.0, 0.5);
        Vec3d maxYAdj = VecUtil.replaceValue(realDrillPos, EnumFacing.Axis.Y, max.field_72448_b);
        list.add(BoundingBoxUtil.makeFrom(minYAdj, maxYAdj, 0.25));
        return list;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("rate = " + LocaleUtil.localizeMjFlow(this.debugPowerRate));
        left.add("frameBox");
        left.add(" - min = " + this.frameBox.min());
        left.add(" - max = " + this.frameBox.max());
        left.add("miningBox:");
        left.add(" - min = " + this.miningBox.min());
        left.add(" - max = " + this.miningBox.max());
        BoxIterator iter = this.boxIterator;
        left.add("current = " + (iter == null ? "null" : iter.getCurrent()));
        Task task = this.currentTask;
        if (task != null) {
            left.add("task:");
            left.add(" - class = " + task.getClass().getName());
            left.add(" - power = " + LocaleUtil.localizeMj(task.getPower()));
            left.add(" - target = " + LocaleUtil.localizeMj(task.getTarget()));
        } else {
            left.add("task = null");
        }
        left.add("drill = " + this.drillPos);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return BoundingBoxUtil.makeFrom(this.field_174879_c, this.miningBox);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    private class TaskMoveDrill
    extends Task {
        public Vec3d from;
        public Vec3d to;

        public TaskMoveDrill() {
            this.from = Vec3d.field_186680_a;
            this.to = Vec3d.field_186680_a;
        }

        public TaskMoveDrill(Vec3d from, Vec3d to) {
            this.from = Vec3d.field_186680_a;
            this.to = Vec3d.field_186680_a;
            this.from = from;
            this.to = to;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            nbt.func_74782_a("from", (NBTBase)NBTUtilBC.writeVec3d(this.from));
            nbt.func_74782_a("to", (NBTBase)NBTUtilBC.writeVec3d(this.to));
            return nbt;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.from = NBTUtilBC.readVec3d(nbt.func_74781_a("from"));
            this.to = NBTUtilBC.readVec3d(nbt.func_74781_a("to"));
            if (this.from == null || this.to == null) {
                TileQuarry.this.currentTask = null;
            }
        }

        @Override
        public void toBytes(PacketBufferBC buffer) {
            super.toBytes(buffer);
            MessageUtil.writeVec3d(buffer, this.from);
            MessageUtil.writeVec3d(buffer, this.to);
        }

        @Override
        public void fromBytes(PacketBufferBC buffer) {
            super.fromBytes(buffer);
            this.from = MessageUtil.readVec3d(buffer);
            this.to = MessageUtil.readVec3d(buffer);
        }

        @Override
        public long getTarget() {
            return (long)(this.from.func_72438_d(this.to) * 20.0 * 1000000.0);
        }

        @Override
        protected boolean onReceivePower() {
            TileQuarry.this.drillPos = this.from.func_186678_a(1.0 - (double)this.power / (double)this.getTarget()).func_178787_e(this.to.func_186678_a((double)this.power / (double)this.getTarget()));
            return false;
        }

        @Override
        protected boolean finish() {
            TileQuarry.this.drillPos = this.to;
            return true;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.from.equals((Object)((TaskMoveDrill)o).from) && this.to.equals((Object)((TaskMoveDrill)o).to);
        }
    }

    public class TaskAddFrame
    extends Task {
        public BlockPos framePos;

        public TaskAddFrame() {
            this.framePos = BlockPos.field_177992_a;
        }

        public TaskAddFrame(BlockPos framePos) {
            this.framePos = BlockPos.field_177992_a;
            this.framePos = framePos;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            nbt.func_74782_a("framePos", (NBTBase)NBTUtilBC.writeBlockPos(this.framePos));
            return nbt;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.framePos = NBTUtilBC.readBlockPos(nbt.func_74781_a("framePos"));
            if (this.framePos == null) {
                TileQuarry.this.currentTask = null;
            }
        }

        @Override
        public void toBytes(PacketBufferBC buffer) {
            super.toBytes(buffer);
            buffer.func_179255_a(this.framePos);
        }

        @Override
        public void fromBytes(PacketBufferBC buffer) {
            super.fromBytes(buffer);
            this.framePos = buffer.func_179259_c();
        }

        @Override
        public long getTarget() {
            return 24000000L;
        }

        @Override
        protected boolean onReceivePower() {
            return !TileQuarry.this.field_145850_b.func_175623_d(this.framePos);
        }

        @Override
        protected boolean finish() {
            if (TileQuarry.this.field_145850_b.func_175623_d(this.framePos)) {
                TileQuarry.this.field_145850_b.func_175656_a(this.framePos, BCBuildersBlocks.frame.func_176223_P());
            }
            return true;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.framePos.equals((Object)((TaskAddFrame)o).framePos);
        }
    }

    public class TaskBreakBlock
    extends Task {
        public BlockPos breakPos;

        public TaskBreakBlock() {
            this.breakPos = BlockPos.field_177992_a;
        }

        public TaskBreakBlock(BlockPos pos) {
            this.breakPos = BlockPos.field_177992_a;
            this.breakPos = pos;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            nbt.func_74782_a("breakPos", (NBTBase)NBTUtilBC.writeBlockPos(this.breakPos));
            return nbt;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.breakPos = NBTUtilBC.readBlockPos(nbt.func_74781_a("breakPos"));
            if (this.breakPos == null) {
                TileQuarry.this.currentTask = null;
            }
        }

        @Override
        public void toBytes(PacketBufferBC buffer) {
            super.toBytes(buffer);
            buffer.func_179255_a(this.breakPos);
        }

        @Override
        public void fromBytes(PacketBufferBC buffer) {
            super.fromBytes(buffer);
            this.breakPos = buffer.func_179259_c();
        }

        @Override
        public long getTarget() {
            return BlockUtil.computeBlockBreakPower(TileQuarry.this.field_145850_b, this.breakPos);
        }

        @Override
        protected boolean onReceivePower() {
            if (!TileQuarry.this.field_145850_b.func_175623_d(this.breakPos)) {
                TileQuarry.this.field_145850_b.func_175715_c(this.breakPos.hashCode(), this.breakPos, (int)(this.power * 9L / this.getTarget()));
                return false;
            }
            return true;
        }

        @Override
        protected boolean finish() {
            FakePlayer fake = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)TileQuarry.this.field_145850_b, TileQuarry.this.getOwner(), TileQuarry.this.field_174879_c);
            IBlockState state = TileQuarry.this.field_145850_b.func_180495_p(this.breakPos);
            if (TileQuarry.this.canNotMine(this.breakPos)) {
                return true;
            }
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(TileQuarry.this.field_145850_b, this.breakPos, state, (EntityPlayer)fake);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                TileQuarry.this.field_145850_b.func_175715_c(this.breakPos.hashCode(), this.breakPos, -1);
                if (TileQuarry.this.drillPos != null) {
                    TileQuarry.this.field_145850_b.func_175655_b(this.breakPos, true);
                    for (EntityItem entity : TileQuarry.this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.breakPos).func_186662_g(1.0))) {
                        ItemStack stack;
                        TransactorEntityItem transactor = new TransactorEntityItem(entity);
                        while (!(stack = transactor.extract(StackFilter.ALL, 0, Integer.MAX_VALUE, false)).func_190926_b()) {
                            InventoryUtil.addToBestAcceptor(TileQuarry.this.field_145850_b, TileQuarry.this.field_174879_c, null, stack);
                        }
                    }
                } else {
                    TileQuarry.this.field_145850_b.func_175655_b(this.breakPos, false);
                }
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.breakPos.equals((Object)((TaskBreakBlock)o).breakPos);
        }
    }

    private abstract class Task {
        protected long power;
        public long clientPower;
        public long prevClientPower;

        private Task() {
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("power", this.power);
            return nbt;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.power = nbt.func_74763_f("power");
        }

        public void toBytes(PacketBufferBC buffer) {
            buffer.writeLong(this.power);
        }

        public void fromBytes(PacketBufferBC buffer) {
            this.power = buffer.readLong();
        }

        public void clientTick() {
            this.prevClientPower = this.clientPower;
            this.clientPower = this.power;
        }

        public abstract long getTarget();

        protected abstract boolean onReceivePower();

        protected abstract boolean finish();

        public final long getPower() {
            return this.power;
        }

        public final boolean addPower(long microJoules) {
            this.power += microJoules;
            if (this.power >= this.getTarget()) {
                if (!this.finish()) {
                    TileQuarry.this.battery.addPower(Math.min(this.power, TileQuarry.this.battery.getCapacity() - TileQuarry.this.battery.getStored()), false);
                }
                return true;
            }
            return this.onReceivePower();
        }
    }

    private static enum EnumTaskType {
        BREAK_BLOCK(TaskBreakBlock.class, quarry -> (TileQuarry)quarry.new TaskBreakBlock()),
        ADD_FRAME(TaskAddFrame.class, quarry -> (TileQuarry)quarry.new TaskAddFrame()),
        MOVE_DRILL(TaskMoveDrill.class, quarry -> (TileQuarry)quarry.new TaskMoveDrill());

        public final Class<? extends Task> clazz;
        public final Function<TileQuarry, Task> supplier;

        private EnumTaskType(Class<? extends Task> clazz, Function<TileQuarry, Task> supplier) {
            this.clazz = clazz;
            this.supplier = supplier;
        }
    }
}

