/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.builders.addon.AddonFillingPlanner;
import buildcraft.builders.filling.Filling;
import buildcraft.builders.filling.IParameter;
import buildcraft.builders.snapshot.ITileForTemplateBuilder;
import buildcraft.builders.snapshot.SnapshotBuilder;
import buildcraft.builders.snapshot.Template;
import buildcraft.builders.snapshot.TemplateBuilder;
import buildcraft.core.marker.volume.ClientVolumeBoxes;
import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.core.marker.volume.Lock;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.core.marker.volume.WorldSavedDataVolumeBoxes;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileFiller
extends TileBC_Neptune
implements ITickable,
IDebuggable,
ITileForTemplateBuilder {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("filler");
    public static final int NET_INVERTED = IDS.allocId("INVERTED");
    public static final int NET_PARAMETERS = IDS.allocId("PARAMETERS");
    public static final int NET_CAN_EXCAVATE = IDS.allocId("CAN_EXCAVATE");
    public final ItemHandlerSimple invResources;
    private final MjBattery battery;
    private boolean canExcavate;
    private AddonFillingPlanner addon;
    private final List<IParameter> parameters;
    private boolean inverted;
    public final Box box;
    public boolean markerBox;
    private Template.BuildingInfo buildingInfo;
    private List<IParameter> prevParameters;
    private boolean prevInverted;
    public final TemplateBuilder builder;

    public TileFiller() {
        this.invResources = this.itemManager.addInvHandler("resources", 27, (slot, stack) -> Filling.getItemBlocks().contains(stack.func_77973_b()), ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.battery = new MjBattery(1000000000L);
        this.canExcavate = true;
        this.parameters = new ArrayList<IParameter>();
        this.box = new Box();
        this.markerBox = false;
        this.builder = new TemplateBuilder(this);
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.battery)));
    }

    @Override
    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        if (!this.field_145850_b.field_72995_K && handler == this.invResources) {
            this.builder.resourcesChanged();
        }
        super.onSlotChange(handler, slot, before, after);
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        super.onPlacedBy(placer, stack);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        WorldSavedDataVolumeBoxes volumeBoxes = WorldSavedDataVolumeBoxes.get(this.field_145850_b);
        BlockPos offsetPos = this.field_174879_c.func_177972_a(((EnumFacing)blockState.func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176734_d());
        VolumeBox volumeBox = volumeBoxes.getBoxAt(offsetPos);
        TileEntity tile = this.field_145850_b.func_175625_s(offsetPos);
        if (volumeBox != null) {
            this.addon = volumeBox.addons.values().stream().filter(AddonFillingPlanner.class::isInstance).findFirst().orElse(null);
            if (this.addon != null) {
                volumeBox.locks.add(new Lock(new Lock.Cause.CauseBlock(this.field_174879_c, blockState.func_177230_c()), new Lock.Target.TargetAddon(this.addon.getSlot()), new Lock.Target.TargetResize(), new Lock.Target.TargetUsedByMachine(Lock.Target.TargetUsedByMachine.EnumType.STRIPES_WRITE)));
                volumeBoxes.func_76185_a();
                this.builder.updateSnapshot();
            } else {
                this.box.reset();
                this.box.setMin(volumeBox.box.min());
                this.box.setMax(volumeBox.box.max());
                volumeBox.locks.add(new Lock(new Lock.Cause.CauseBlock(this.field_174879_c, blockState.func_177230_c()), new Lock.Target.TargetResize(), new Lock.Target.TargetUsedByMachine(Lock.Target.TargetUsedByMachine.EnumType.STRIPES_WRITE)));
                volumeBoxes.func_76185_a();
                this.parameters.addAll(Filling.initParameters());
                this.updateBuildingInfo();
            }
        } else if (tile instanceof IAreaProvider) {
            IAreaProvider provider = (IAreaProvider)tile;
            this.box.reset();
            this.box.setMin(provider.min());
            this.box.setMax(provider.max());
            this.markerBox = true;
            provider.removeFromWorld();
            this.parameters.addAll(Filling.initParameters());
            this.updateBuildingInfo();
        }
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.builder.validate();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.builder.invalidate();
    }

    public void func_73660_a() {
        if (!this.isValid()) {
            return;
        }
        this.battery.tick(this.func_145831_w(), this.func_174877_v());
        this.battery.addPowerChecking(64000000L, false);
        if (!(this.field_145850_b.field_72995_K || this.prevParameters != null && Arrays.equals(this.prevParameters.toArray(), this.getParameters().toArray()) && this.prevInverted == this.isInverted())) {
            if (this.prevParameters != null) {
                this.builder.cancel();
            }
            this.builder.updateSnapshot();
        }
        this.builder.tick();
        this.prevParameters = this.getParameters();
        this.prevInverted = this.isInverted();
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    public boolean isValid() {
        return this.addon != null || this.box.isInitialized();
    }

    private void updateBuildingInfo() {
        this.buildingInfo = Filling.createBuildingInfo(this.box.min(), this.box.size(), this.parameters, this.inverted);
    }

    public void sendInverted(boolean value) {
        MessageManager.sendToServer(this.createMessage(NET_INVERTED, buffer -> buffer.writeBoolean(value)));
    }

    public void sendParameters(List<IParameter> value) {
        MessageManager.sendToServer(this.createMessage(NET_PARAMETERS, buffer -> {
            buffer.writeInt(value.size());
            value.forEach(parameter -> IParameter.toBytes((ByteBuf)buffer, parameter));
        }));
    }

    public void sendCanExcavate(boolean value) {
        MessageManager.sendToServer(this.createMessage(NET_CAN_EXCAVATE, buffer -> buffer.writeBoolean(value)));
    }

    public boolean isInverted() {
        return this.addon == null ? this.inverted : this.addon.inverted;
    }

    public List<IParameter> getParameters() {
        return this.addon == null ? this.parameters : this.addon.parameters;
    }

    public boolean isCanExcavate() {
        return this.canExcavate;
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.box.writeData(buffer);
                buffer.writeBoolean(this.markerBox);
                buffer.writeBoolean(this.addon != null);
                if (this.addon != null) {
                    buffer.func_179252_a(this.addon.box.id);
                    buffer.writeEnumValue(this.addon.getSlot());
                }
                this.builder.writeToByteBuf(buffer);
                this.writePayload(NET_INVERTED, buffer, side);
                this.writePayload(NET_PARAMETERS, buffer, side);
                this.writePayload(NET_CAN_EXCAVATE, buffer, side);
            }
            if (id == NET_PARAMETERS) {
                buffer.writeInt(this.parameters.size());
                this.parameters.forEach(parameter -> IParameter.toBytes((ByteBuf)buffer, parameter));
            }
            if (id == NET_INVERTED) {
                buffer.writeBoolean(this.addon == null ? this.inverted : this.addon.inverted);
            }
            if (id == NET_CAN_EXCAVATE) {
                buffer.writeBoolean(this.canExcavate);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.box.readData(buffer);
                this.markerBox = buffer.readBoolean();
                if (buffer.readBoolean()) {
                    UUID boxId = buffer.func_179253_g();
                    VolumeBox volumeBox = this.field_145850_b.field_72995_K ? ClientVolumeBoxes.INSTANCE.boxes.stream().filter(localVolumeBox -> localVolumeBox.id.equals(boxId)).findFirst().orElseThrow(NullPointerException::new) : WorldSavedDataVolumeBoxes.get(this.field_145850_b).getBoxFromId(boxId);
                    this.addon = (AddonFillingPlanner)volumeBox.addons.get((Object)buffer.func_179257_a(EnumAddonSlot.class));
                }
                this.builder.readFromByteBuf(buffer);
                this.readPayload(NET_INVERTED, buffer, side, ctx);
                this.readPayload(NET_PARAMETERS, buffer, side, ctx);
                this.readPayload(NET_CAN_EXCAVATE, buffer, side, ctx);
            }
            if (id == NET_INVERTED) {
                if (this.addon == null) {
                    this.inverted = buffer.readBoolean();
                } else {
                    buffer.readBoolean();
                }
            }
            if (id == NET_PARAMETERS) {
                if (this.addon == null) {
                    this.parameters.clear();
                    IntStream.range(0, buffer.readInt()).mapToObj(i -> IParameter.fromBytes((ByteBuf)buffer)).forEach(this.parameters::add);
                } else {
                    IntStream.range(0, buffer.readInt()).forEach(i -> IParameter.fromBytes((ByteBuf)buffer));
                }
            }
            if (id == NET_CAN_EXCAVATE) {
                this.canExcavate = buffer.readBoolean();
            }
        }
        if (side == Side.SERVER) {
            if (id == NET_INVERTED) {
                if (this.addon == null) {
                    this.inverted = buffer.readBoolean();
                    this.updateBuildingInfo();
                } else {
                    this.addon.inverted = buffer.readBoolean();
                    this.addon.updateBuildingInfo();
                    WorldSavedDataVolumeBoxes.get(this.field_145850_b).func_76185_a();
                }
            }
            if (id == NET_PARAMETERS) {
                if (this.addon == null) {
                    this.parameters.clear();
                    IntStream.range(0, buffer.readInt()).mapToObj(i -> IParameter.fromBytes((ByteBuf)buffer)).forEach(this.parameters::add);
                    this.updateBuildingInfo();
                } else {
                    this.addon.parameters.clear();
                    IntStream.range(0, buffer.readInt()).mapToObj(i -> IParameter.fromBytes((ByteBuf)buffer)).forEach(this.addon.parameters::add);
                    this.addon.updateBuildingInfo();
                    WorldSavedDataVolumeBoxes.get(this.field_145850_b).func_76185_a();
                }
            }
            if (id == NET_CAN_EXCAVATE) {
                this.canExcavate = buffer.readBoolean();
                this.sendNetworkUpdate(NET_CAN_EXCAVATE);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
        if (this.addon != null) {
            nbt.func_186854_a("addonBoxId", this.addon.box.id);
            nbt.func_74782_a("addonSlot", NBTUtilBC.writeEnum(this.addon.getSlot()));
        }
        nbt.func_74757_a("canExcavate", this.canExcavate);
        nbt.func_74782_a("parameters", (NBTBase)NBTUtilBC.writeCompoundList(this.parameters.stream().map(parameter -> IParameter.writeToNBT(new NBTTagCompound(), parameter))));
        nbt.func_74757_a("inverted", this.inverted);
        nbt.func_74782_a("box", (NBTBase)this.box.writeToNBT());
        nbt.func_74757_a("markerBox", this.markerBox);
        if (this.prevParameters != null) {
            nbt.func_74782_a("prevParameters", (NBTBase)NBTUtilBC.writeCompoundList(this.prevParameters.stream().map(parameter -> IParameter.writeToNBT(new NBTTagCompound(), parameter))));
        }
        nbt.func_74757_a("prevInverted", this.prevInverted);
        nbt.func_74782_a("builder", (NBTBase)this.builder.serializeNBT());
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        if (nbt.func_74764_b("addonSlot")) {
            this.addon = (AddonFillingPlanner)WorldSavedDataVolumeBoxes.get((World)this.field_145850_b).getBoxFromId((UUID)nbt.func_186857_a((String)"addonBoxId")).addons.get((Object)NBTUtilBC.readEnum(nbt.func_74781_a("addonSlot"), EnumAddonSlot.class));
        }
        this.canExcavate = nbt.func_74767_n("canExcavate");
        NBTUtilBC.readCompoundList(nbt.func_74781_a("parameters")).map(IParameter::readFromNBT).forEach(this.parameters::add);
        this.inverted = nbt.func_74767_n("inverted");
        this.box.initialize(nbt.func_74775_l("box"));
        this.markerBox = nbt.func_74767_n("markerBox");
        if (nbt.func_74764_b("prevParameters")) {
            this.prevParameters = new ArrayList<IParameter>();
            NBTUtilBC.readCompoundList(nbt.func_74781_a("prevParameters")).map(IParameter::readFromNBT).forEach(this.prevParameters::add);
        }
        this.prevInverted = nbt.func_74767_n("prevInverted");
        if (this.addon == null) {
            this.updateBuildingInfo();
        }
        if (nbt.func_74764_b("builder")) {
            this.builder.updateSnapshot();
            this.builder.deserializeNBT(nbt.func_74775_l("builder"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return true;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("addon = " + this.addon);
    }

    @Override
    public World getWorldBC() {
        return this.field_145850_b;
    }

    @Override
    public MjBattery getBattery() {
        return this.battery;
    }

    @Override
    public BlockPos getBuilderPos() {
        return this.field_174879_c;
    }

    @Override
    public boolean canExcavate() {
        return this.canExcavate;
    }

    public SnapshotBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public Template.BuildingInfo getTemplateBuildingInfo() {
        return this.addon == null ? this.buildingInfo : this.addon.buildingInfo;
    }

    @Override
    public IItemTransactor getInvResources() {
        return this.invResources;
    }
}

