/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IBox;
import buildcraft.api.core.IPathProvider;
import buildcraft.api.enums.EnumOptionalSnapshotType;
import buildcraft.api.enums.EnumSnapshotType;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.builders.BCBuildersItems;
import buildcraft.builders.item.ItemSnapshot;
import buildcraft.builders.snapshot.Blueprint;
import buildcraft.builders.snapshot.BlueprintBuilder;
import buildcraft.builders.snapshot.GlobalSavedDataSnapshots;
import buildcraft.builders.snapshot.ITileForBlueprintBuilder;
import buildcraft.builders.snapshot.ITileForTemplateBuilder;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.builders.snapshot.SnapshotBuilder;
import buildcraft.builders.snapshot.Template;
import buildcraft.builders.snapshot.TemplateBuilder;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.fluid.TankManager;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.PositionUtil;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileBuilder
extends TileBC_Neptune
implements ITickable,
IDebuggable,
ITileForTemplateBuilder,
ITileForBlueprintBuilder {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("builder");
    public static final int NET_CAN_EXCAVATE = IDS.allocId("CAN_EXCAVATE");
    public static final int NET_SNAPSHOT_TYPE = IDS.allocId("SNAPSHOT_TYPE");
    public final ItemHandlerSimple invSnapshot;
    public final ItemHandlerSimple invResources;
    private final MjBattery battery;
    private boolean canExcavate;
    public List<BlockPos> path;
    private List<BlockPos> basePoses;
    private int currentBasePosIndex;
    private Snapshot snapshot;
    public EnumSnapshotType snapshotType;
    private Template.BuildingInfo templateBuildingInfo;
    private Blueprint.BuildingInfo blueprintBuildingInfo;
    public TemplateBuilder templateBuilder;
    public BlueprintBuilder blueprintBuilder;
    private Box currentBox;
    private Rotation rotation;
    private boolean isDone;

    public TileBuilder() {
        this.invSnapshot = this.itemManager.addInvHandler("snapshot", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemSnapshot && ItemSnapshot.EnumItemSnapshotType.getFromStack((ItemStack)stack).used, ItemHandlerManager.EnumAccess.BOTH, EnumPipePart.VALUES);
        this.invResources = this.itemManager.addInvHandler("resources", 27, ItemHandlerManager.EnumAccess.BOTH, EnumPipePart.VALUES);
        this.battery = new MjBattery(1000000000L);
        this.canExcavate = true;
        this.path = null;
        this.basePoses = new ArrayList<BlockPos>();
        this.currentBasePosIndex = 0;
        this.snapshot = null;
        this.snapshotType = null;
        this.templateBuildingInfo = null;
        this.blueprintBuildingInfo = null;
        this.templateBuilder = new TemplateBuilder(this);
        this.blueprintBuilder = new BlueprintBuilder(this);
        this.currentBox = new Box();
        this.rotation = null;
        this.isDone = false;
        for (int i = 1; i <= 4; ++i) {
            this.tankManager.add(new Tank("tank" + i, 8000, this){

                protected void onContentsChanged() {
                    super.onContentsChanged();
                    Optional.ofNullable(TileBuilder.this.getBuilder()).ifPresent(SnapshotBuilder::resourcesChanged);
                }
            });
        }
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.battery)));
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankManager, EnumPipePart.VALUES);
    }

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    @Override
    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        if (!this.field_145850_b.field_72995_K) {
            if (handler == this.invSnapshot) {
                Snapshot newSnapshot;
                Snapshot.Header header;
                this.currentBasePosIndex = 0;
                this.snapshot = null;
                if (after.func_77973_b() instanceof ItemSnapshot && (header = BCBuildersItems.snapshot.getHeader(after)) != null && (newSnapshot = GlobalSavedDataSnapshots.get(this.field_145850_b).getSnapshot(header.key)) != null) {
                    this.snapshot = newSnapshot;
                }
                this.updateSnapshot(true);
                this.sendNetworkUpdate(NET_SNAPSHOT_TYPE);
            }
            if (handler == this.invResources) {
                Optional.ofNullable(this.getBuilder()).ifPresent(SnapshotBuilder::resourcesChanged);
            }
        }
        super.onSlotChange(handler, slot, before, after);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.templateBuilder.validate();
        this.blueprintBuilder.validate();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.templateBuilder.invalidate();
        this.blueprintBuilder.invalidate();
    }

    private void updateSnapshot(boolean canGetFacing) {
        Optional.ofNullable(this.getBuilder()).ifPresent(SnapshotBuilder::cancel);
        if (this.snapshot != null && this.getCurrentBasePos() != null) {
            this.snapshotType = this.snapshot.getType();
            if (canGetFacing) {
                this.rotation = Arrays.stream(Rotation.values()).filter(r -> r.func_185831_a(this.snapshot.facing) == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockBCBase_Neptune.PROP_FACING)).findFirst().orElse(null);
            }
            if (this.snapshot.getType() == EnumSnapshotType.TEMPLATE) {
                Template template = (Template)this.snapshot;
                template.getClass();
                this.templateBuildingInfo = template.new Template.BuildingInfo(this.getCurrentBasePos(), this.rotation);
            }
            if (this.snapshot.getType() == EnumSnapshotType.BLUEPRINT) {
                Blueprint blueprint = (Blueprint)this.snapshot;
                blueprint.getClass();
                this.blueprintBuildingInfo = blueprint.new Blueprint.BuildingInfo(this.getCurrentBasePos(), this.rotation);
            }
            this.currentBox = Optional.ofNullable(this.getBuildingInfo()).map(buildingInfo -> buildingInfo.box).orElse(null);
            Optional.ofNullable(this.getBuilder()).ifPresent(SnapshotBuilder::updateSnapshot);
        } else {
            this.snapshotType = null;
            this.rotation = null;
            this.templateBuildingInfo = null;
            this.blueprintBuildingInfo = null;
            this.currentBox = null;
        }
        if (this.currentBox == null) {
            this.currentBox = new Box();
        }
    }

    private void updateBasePoses() {
        this.basePoses.clear();
        if (this.path != null) {
            int max = this.path.size() - 1;
            this.basePoses.add(this.path.get(0));
            for (int i = 1; i <= max; ++i) {
                this.basePoses.addAll((Collection<BlockPos>)PositionUtil.getAllOnPath(this.path.get(i - 1), this.path.get(i)));
            }
        } else {
            this.basePoses.add(this.field_174879_c.func_177972_a(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176734_d()));
        }
    }

    private BlockPos getCurrentBasePos() {
        return this.currentBasePosIndex < this.basePoses.size() ? this.basePoses.get(this.currentBasePosIndex) : null;
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        IPathProvider provider;
        ImmutableList copiedPath;
        super.onPlacedBy(placer, stack);
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        TileEntity inFront = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176734_d()));
        if (inFront instanceof IPathProvider && (copiedPath = ImmutableList.copyOf((provider = (IPathProvider)inFront).getPath())).size() >= 2) {
            this.path = copiedPath;
            provider.removeFromWorld();
        }
        this.updateBasePoses();
    }

    public void func_73660_a() {
        this.battery.tick(this.func_145831_w(), this.func_174877_v());
        this.battery.addPowerChecking(64000000L, false);
        SnapshotBuilder<?> builder = this.getBuilder();
        if (builder != null) {
            this.isDone = builder.tick();
            if (this.isDone && this.currentBasePosIndex < this.basePoses.size() - 1) {
                ++this.currentBasePosIndex;
                if (this.currentBasePosIndex >= this.basePoses.size()) {
                    this.currentBasePosIndex = this.basePoses.size() - 1;
                }
                this.updateSnapshot(true);
            }
        }
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                buffer.writeInt(this.path == null ? 0 : this.path.size());
                if (this.path != null) {
                    this.path.forEach(p -> MessageUtil.writeBlockPos(buffer, p));
                }
                buffer.writeBoolean(this.snapshotType != null);
                if (this.snapshotType != null) {
                    buffer.writeEnumValue(this.snapshotType);
                    this.getBuilder().writeToByteBuf(buffer);
                }
                this.currentBox.writeData(buffer);
                this.writePayload(NET_CAN_EXCAVATE, buffer, side);
                this.writePayload(NET_SNAPSHOT_TYPE, buffer, side);
            }
            if (id == NET_GUI_DATA || id == NET_GUI_TICK) {
                this.tankManager.writeData(buffer);
            }
            if (id == NET_CAN_EXCAVATE) {
                buffer.writeBoolean(this.canExcavate);
            }
            if (id == NET_SNAPSHOT_TYPE) {
                buffer.writeEnumValue(EnumOptionalSnapshotType.fromNullable(this.snapshotType));
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.path = new ArrayList<BlockPos>();
                int pathSize = buffer.readInt();
                if (pathSize != 0) {
                    for (int i = 0; i < pathSize; ++i) {
                        this.path.add(MessageUtil.readBlockPos(buffer));
                    }
                } else {
                    this.path = null;
                }
                this.updateBasePoses();
                if (buffer.readBoolean()) {
                    this.snapshotType = buffer.func_179257_a(EnumSnapshotType.class);
                    this.getBuilder().readFromByteBuf(buffer);
                } else {
                    this.snapshotType = null;
                }
                this.currentBox.readData(buffer);
                this.readPayload(NET_CAN_EXCAVATE, buffer, side, ctx);
                this.readPayload(NET_SNAPSHOT_TYPE, buffer, side, ctx);
            }
            if (id == NET_GUI_DATA || id == NET_GUI_TICK) {
                this.tankManager.readData(buffer);
            }
            if (id == NET_CAN_EXCAVATE) {
                this.canExcavate = buffer.readBoolean();
            }
            if (id == NET_SNAPSHOT_TYPE) {
                EnumSnapshotType old = this.snapshotType;
                this.snapshotType = buffer.func_179257_a(EnumOptionalSnapshotType.class).type;
                if (old != this.snapshotType) {
                    this.redrawBlock();
                }
            }
        }
        if (side == Side.SERVER && id == NET_CAN_EXCAVATE) {
            this.canExcavate = buffer.readBoolean();
            this.sendNetworkUpdate(NET_CAN_EXCAVATE);
        }
    }

    public void sendCanExcavate(boolean newValue) {
        MessageManager.sendToServer(this.createMessage(NET_CAN_EXCAVATE, buffer -> buffer.writeBoolean(newValue)));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.path != null) {
            nbt.func_74782_a("path", (NBTBase)NBTUtilBC.writeCompoundList(this.path.stream().map(NBTUtil::func_186859_a)));
        }
        nbt.func_74782_a("basePoses", (NBTBase)NBTUtilBC.writeCompoundList(this.basePoses.stream().map(NBTUtil::func_186859_a)));
        nbt.func_74757_a("canExcavate", this.canExcavate);
        nbt.func_74782_a("rotation", NBTUtilBC.writeEnum(this.rotation));
        Optional.ofNullable(this.getBuilder()).ifPresent(builder -> nbt.func_74782_a("builder", (NBTBase)builder.serializeNBT()));
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("path")) {
            this.path = NBTUtilBC.readCompoundList(nbt.func_74781_a("path")).map(NBTUtil::func_186861_c).collect(Collectors.toList());
        }
        this.basePoses = NBTUtilBC.readCompoundList(nbt.func_74781_a("basePoses")).map(NBTUtil::func_186861_c).collect(Collectors.toList());
        this.canExcavate = nbt.func_74767_n("canExcavate");
        this.rotation = NBTUtilBC.readEnum(nbt.func_74781_a("rotation"), Rotation.class);
        if (nbt.func_74764_b("builder")) {
            this.updateSnapshot(false);
            Optional.ofNullable(this.getBuilder()).ifPresent(builder -> builder.deserializeNBT(nbt.func_74775_l("builder")));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Box getBox() {
        return this.currentBox;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return BoundingBoxUtil.makeFrom(this.func_174877_v(), (IBox)this.getBox(), this.path);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("basePoses = " + (this.basePoses == null ? "null" : Integer.valueOf(this.basePoses.size())));
        left.add("currentBasePosIndex = " + this.currentBasePosIndex);
        left.add("isDone = " + this.isDone);
    }

    @Override
    public World getWorldBC() {
        return this.field_145850_b;
    }

    @Override
    public MjBattery getBattery() {
        return this.battery;
    }

    @Override
    public BlockPos getBuilderPos() {
        return this.field_174879_c;
    }

    @Override
    public boolean canExcavate() {
        return this.canExcavate;
    }

    @Override
    public SnapshotBuilder<?> getBuilder() {
        if (this.snapshotType == EnumSnapshotType.TEMPLATE) {
            return this.templateBuilder;
        }
        if (this.snapshotType == EnumSnapshotType.BLUEPRINT) {
            return this.blueprintBuilder;
        }
        return null;
    }

    private Snapshot.BuildingInfo getBuildingInfo() {
        if (this.snapshotType == EnumSnapshotType.TEMPLATE) {
            return this.templateBuildingInfo;
        }
        if (this.snapshotType == EnumSnapshotType.BLUEPRINT) {
            return this.blueprintBuildingInfo;
        }
        return null;
    }

    @Override
    public Template.BuildingInfo getTemplateBuildingInfo() {
        return this.templateBuildingInfo;
    }

    @Override
    public Blueprint.BuildingInfo getBlueprintBuildingInfo() {
        return this.blueprintBuildingInfo;
    }

    @Override
    public IItemTransactor getInvResources() {
        return this.invResources;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }
}

