/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.enums.EnumSnapshotType;
import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.ISchematicEntity;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.builders.BCBuildersBlocks;
import buildcraft.builders.BCBuildersItems;
import buildcraft.builders.block.BlockArchitectTable;
import buildcraft.builders.client.ClientArchitectTables;
import buildcraft.builders.item.ItemSnapshot;
import buildcraft.builders.snapshot.Blueprint;
import buildcraft.builders.snapshot.GlobalSavedDataSnapshots;
import buildcraft.builders.snapshot.SchematicBlockManager;
import buildcraft.builders.snapshot.SchematicEntityManager;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.builders.snapshot.Template;
import buildcraft.core.marker.volume.Lock;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.core.marker.volume.WorldSavedDataVolumeBoxes;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.delta.DeltaInt;
import buildcraft.lib.delta.DeltaManager;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.misc.data.BoxIterator;
import buildcraft.lib.misc.data.EnumAxisOrder;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileArchitectTable
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("architect");
    public static final int NET_BOX = IDS.allocId("BOX");
    public static final int NET_SCAN = IDS.allocId("SCAN");
    public final ItemHandlerSimple invSnapshotIn;
    public final ItemHandlerSimple invSnapshotOut;
    private EnumSnapshotType snapshotType;
    public final Box box;
    public boolean markerBox;
    private BitSet templateScannedBlocks;
    private final List<ISchematicBlock> blueprintScannedPalette;
    private int[] blueprintScannedData;
    private final List<ISchematicEntity> blueprintScannedEntities;
    private BoxIterator boxIterator;
    private boolean isValid;
    private boolean scanning;
    public String name;
    public final DeltaInt deltaProgress;

    public TileArchitectTable() {
        this.invSnapshotIn = this.itemManager.addInvHandler("in", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemSnapshot, ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.invSnapshotOut = this.itemManager.addInvHandler("out", 1, ItemHandlerManager.EnumAccess.EXTRACT, EnumPipePart.VALUES);
        this.snapshotType = EnumSnapshotType.BLUEPRINT;
        this.box = new Box();
        this.markerBox = false;
        this.blueprintScannedPalette = new ArrayList<ISchematicBlock>();
        this.blueprintScannedEntities = new ArrayList<ISchematicEntity>();
        this.isValid = false;
        this.scanning = false;
        this.name = "<unnamed>";
        this.deltaProgress = this.deltaManager.addDelta("progress", DeltaManager.EnumNetworkVisibility.GUI_ONLY);
    }

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    @Override
    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        super.onSlotChange(handler, slot, before, after);
        if (handler == this.invSnapshotIn && this.invSnapshotOut.getStackInSlot(0).func_190926_b() && after.func_77973_b() instanceof ItemSnapshot) {
            this.snapshotType = ItemSnapshot.EnumItemSnapshotType.getFromStack((ItemStack)after).snapshotType;
        }
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        super.onPlacedBy(placer, stack);
        if (placer.field_70170_p.field_72995_K) {
            return;
        }
        WorldSavedDataVolumeBoxes volumeBoxes = WorldSavedDataVolumeBoxes.get(this.field_145850_b);
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        BlockPos offsetPos = this.field_174879_c.func_177972_a(((EnumFacing)blockState.func_177229_b(BlockArchitectTable.PROP_FACING)).func_176734_d());
        VolumeBox volumeBox = volumeBoxes.getBoxAt(offsetPos);
        TileEntity tile = this.field_145850_b.func_175625_s(offsetPos);
        if (volumeBox != null) {
            this.box.reset();
            this.box.setMin(volumeBox.box.min());
            this.box.setMax(volumeBox.box.max());
            this.isValid = true;
            volumeBox.locks.add(new Lock(new Lock.Cause.CauseBlock(this.field_174879_c, blockState.func_177230_c()), new Lock.Target.TargetResize(), new Lock.Target.TargetUsedByMachine(Lock.Target.TargetUsedByMachine.EnumType.STRIPES_READ)));
            volumeBoxes.func_76185_a();
            this.sendNetworkUpdate(NET_BOX);
        } else if (tile instanceof IAreaProvider) {
            IAreaProvider provider = (IAreaProvider)tile;
            this.box.reset();
            this.box.setMin(provider.min());
            this.box.setMax(provider.max());
            this.markerBox = true;
            this.isValid = true;
            provider.removeFromWorld();
        } else {
            this.isValid = false;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            state = state.func_177226_a(BlockArchitectTable.PROP_VALID, (Comparable)Boolean.FALSE);
            this.field_145850_b.func_175656_a(this.field_174879_c, state);
        }
    }

    public void func_73660_a() {
        this.deltaManager.tick();
        if (this.field_145850_b.field_72995_K) {
            if (this.box.isInitialized()) {
                ClientArchitectTables.BOXES.put(this.box.getBoundingBox(), 3);
            }
            return;
        }
        if (!this.invSnapshotIn.getStackInSlot(0).func_190926_b() && this.invSnapshotOut.getStackInSlot(0).func_190926_b() && this.isValid) {
            if (!this.scanning) {
                int size = this.box.size().func_177958_n() * this.box.size().func_177956_o() * this.box.size().func_177952_p();
                this.deltaProgress.addDelta(0L, size /= this.snapshotType.maxPerTick, 1);
                this.deltaProgress.addDelta(size, size + 10, -1);
                this.scanning = true;
            }
        } else {
            this.scanning = false;
        }
        if (this.scanning) {
            this.scanMultipleBlocks();
            if (!this.scanning) {
                if (this.snapshotType == EnumSnapshotType.BLUEPRINT) {
                    this.scanEntities();
                }
                this.finishScanning();
            }
        }
    }

    private void scanMultipleBlocks() {
        for (int i = this.snapshotType.maxPerTick; i > 0; --i) {
            this.scanSingleBlock();
            if (!this.scanning) break;
        }
    }

    private void scanSingleBlock() {
        BlockPos size = this.box.size();
        if (this.templateScannedBlocks == null || this.blueprintScannedData == null) {
            this.boxIterator = new BoxIterator(this.box, EnumAxisOrder.XZY.getMinToMaxOrder(), true);
            this.templateScannedBlocks = new BitSet(size.func_177958_n() * size.func_177956_o() * size.func_177952_p());
            this.blueprintScannedData = new int[size.func_177958_n() * size.func_177956_o() * size.func_177952_p()];
        }
        BlockPos worldScanPos = this.boxIterator.getCurrent();
        BlockPos schematicPos = worldScanPos.func_177973_b((Vec3i)this.box.min());
        if (this.snapshotType == EnumSnapshotType.TEMPLATE) {
            this.templateScannedBlocks.set(Snapshot.posToIndex(this.box.size(), schematicPos), !this.field_145850_b.func_175623_d(worldScanPos));
        }
        if (this.snapshotType == EnumSnapshotType.BLUEPRINT) {
            ISchematicBlock schematicBlock = this.readSchematicBlock(worldScanPos);
            int index = this.blueprintScannedPalette.indexOf(schematicBlock);
            if (index == -1) {
                index = this.blueprintScannedPalette.size();
                this.blueprintScannedPalette.add(schematicBlock);
            }
            this.blueprintScannedData[Snapshot.posToIndex((BlockPos)this.box.size(), (BlockPos)schematicPos)] = index;
        }
        this.createAndSendMessage(NET_SCAN, buffer -> MessageUtil.writeBlockPos(buffer, worldScanPos));
        this.sendNetworkUpdate(NET_RENDER_DATA);
        this.boxIterator.advance();
        if (this.boxIterator.hasFinished()) {
            this.scanning = false;
            this.boxIterator = null;
        }
    }

    private ISchematicBlock readSchematicBlock(BlockPos worldScanPos) {
        return SchematicBlockManager.getSchematicBlock(this.field_145850_b, this.field_174879_c.func_177972_a(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176734_d()), worldScanPos, this.field_145850_b.func_180495_p(worldScanPos), this.field_145850_b.func_180495_p(worldScanPos).func_177230_c());
    }

    private void scanEntities() {
        BlockPos basePos = this.field_174879_c.func_177972_a(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockArchitectTable.PROP_FACING)).func_176734_d());
        this.field_145850_b.func_72872_a(Entity.class, this.box.getBoundingBox()).stream().map(entity -> SchematicEntityManager.getSchematicEntity(this.field_145850_b, basePos, entity)).filter(Objects::nonNull).forEach(this.blueprintScannedEntities::add);
    }

    private void finishScanning() {
        IBlockState thisState = this.getCurrentStateForBlock(BCBuildersBlocks.architect);
        if (thisState == null) {
            return;
        }
        EnumFacing facing = (EnumFacing)thisState.func_177229_b(BlockArchitectTable.PROP_FACING);
        Snapshot snapshot = Snapshot.create(this.snapshotType);
        snapshot.size = this.box.size();
        snapshot.facing = facing;
        snapshot.offset = this.box.min().func_177973_b((Vec3i)this.field_174879_c.func_177972_a(facing.func_176734_d()));
        if (snapshot instanceof Template) {
            ((Template)snapshot).data = this.templateScannedBlocks;
        }
        if (snapshot instanceof Blueprint) {
            ((Blueprint)snapshot).palette.addAll(this.blueprintScannedPalette);
            ((Blueprint)snapshot).data = this.blueprintScannedData;
            ((Blueprint)snapshot).entities.addAll(this.blueprintScannedEntities);
        }
        snapshot.computeKey();
        GlobalSavedDataSnapshots.get(this.field_145850_b).addSnapshot(snapshot);
        ItemStack stackIn = this.invSnapshotIn.getStackInSlot(0);
        stackIn.func_190920_e(stackIn.func_190916_E() - 1);
        if (stackIn.func_190916_E() == 0) {
            stackIn = ItemStack.field_190927_a;
        }
        this.invSnapshotIn.setStackInSlot(0, stackIn);
        this.invSnapshotOut.setStackInSlot(0, BCBuildersItems.snapshot.getUsed(this.snapshotType, new Snapshot.Header(snapshot.key, this.getOwner().getId(), new Date(), this.name)));
        this.templateScannedBlocks = null;
        this.blueprintScannedData = null;
        this.blueprintScannedEntities.clear();
        this.boxIterator = null;
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_BOX, buffer, side);
                buffer.func_180714_a(this.name);
            }
            if (id == NET_BOX) {
                this.box.writeData(buffer);
                buffer.writeBoolean(this.markerBox);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_BOX, buffer, side, ctx);
                this.name = buffer.readString();
            }
            if (id == NET_BOX) {
                this.box.readData(buffer);
                this.markerBox = buffer.readBoolean();
            }
            if (id == NET_SCAN) {
                ClientArchitectTables.SCANNED_BLOCKS.put(MessageUtil.readBlockPos(buffer), 50);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("box", (NBTBase)this.box.writeToNBT());
        nbt.func_74757_a("markerBox", this.markerBox);
        if (this.boxIterator != null) {
            nbt.func_74782_a("iter", (NBTBase)this.boxIterator.writeToNbt());
        }
        nbt.func_74757_a("scanning", this.scanning);
        nbt.func_74782_a("snapshotType", NBTUtilBC.writeEnum(this.snapshotType));
        nbt.func_74757_a("isValid", this.isValid);
        nbt.func_74778_a("name", this.name);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.box.initialize(nbt.func_74775_l("box"));
        this.markerBox = nbt.func_74767_n("markerBox");
        if (nbt.func_74764_b("iter")) {
            this.boxIterator = BoxIterator.readFromNbt(nbt.func_74775_l("iter"));
        }
        this.scanning = nbt.func_74767_n("scanning");
        this.snapshotType = NBTUtilBC.readEnum(nbt.func_74781_a("snapshotType"), EnumSnapshotType.class);
        this.isValid = nbt.func_74767_n("isValid");
        this.name = nbt.func_74779_i("name");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("box:");
        left.add(" - min = " + this.box.min());
        left.add(" - max = " + this.box.max());
        left.add("scanning = " + this.scanning);
        left.add("current = " + (this.boxIterator == null ? null : this.boxIterator.getCurrent()));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return BoundingBoxUtil.makeFrom(this.field_174879_c, this.box);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }
}

