/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.enums.EnumSnapshotType;
import buildcraft.builders.snapshot.Snapshot;
import java.util.BitSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class Template
extends Snapshot {
    public BitSet data;

    @Override
    public Template copy() {
        Template template = new Template();
        template.size = this.size;
        template.facing = this.facing;
        template.offset = this.offset;
        template.data = (BitSet)this.data.clone();
        template.computeKey();
        return template;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74773_a("data", this.data.toByteArray());
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        super.deserializeNBT(nbt);
        this.data = BitSet.valueOf(nbt.func_74770_j("data"));
        if (this.data.length() > this.size.func_177958_n() * this.size.func_177956_o() * this.size.func_177952_p()) {
            throw new InvalidInputDataException("Serialized data has length of " + this.data.length() + ", but we expected at most " + this.size.func_177958_n() * this.size.func_177956_o() * this.size.func_177952_p() + " (" + this.size.toString() + ")");
        }
    }

    @Override
    public EnumSnapshotType getType() {
        return EnumSnapshotType.TEMPLATE;
    }

    public class BuildingInfo
    extends Snapshot.BuildingInfo {
        public BuildingInfo(BlockPos basePos, Rotation rotation) {
            super(basePos, rotation);
        }

        @Override
        public Template getSnapshot() {
            return Template.this;
        }
    }
}

