/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.builders.snapshot.ITileForSnapshotBuilder;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.world.WorldEventListenerAdapter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class SnapshotBuilder<T extends ITileForSnapshotBuilder>
implements INBTSerializable<NBTTagCompound> {
    private static final int MAX_QUEUE_SIZE = 64;
    protected static final byte CHECK_RESULT_UNKNOWN = 0;
    protected static final byte CHECK_RESULT_CORRECT = 1;
    protected static final byte CHECK_RESULT_TO_BREAK = 2;
    protected static final byte CHECK_RESULT_TO_PLACE = 3;
    private static final byte REQUIRED_UNKNOWN = 0;
    private static final byte REQUIRED_TRUE = 1;
    private static final byte REQUIRED_FALSE = 2;
    protected final T tile;
    private final IWorldEventListener worldEventListener = new WorldEventListenerAdapter(){

        @Override
        public void func_184376_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, int flags) {
            if (SnapshotBuilder.this.tile.getBuilder() == SnapshotBuilder.this && SnapshotBuilder.this.getBuildingInfo().box.contains(pos) && SnapshotBuilder.this.check(pos)) {
                SnapshotBuilder.this.afterChecks();
            }
        }
    };
    private final Queue<BreakTask> breakTasks = new ArrayDeque<BreakTask>();
    public final Queue<BreakTask> clientBreakTasks = new ArrayDeque<BreakTask>();
    public final Queue<BreakTask> prevClientBreakTasks = new ArrayDeque<BreakTask>();
    private final Queue<PlaceTask> placeTasks = new ArrayDeque<PlaceTask>();
    public final Queue<PlaceTask> clientPlaceTasks = new ArrayDeque<PlaceTask>();
    public final Queue<PlaceTask> prevClientPlaceTasks = new ArrayDeque<PlaceTask>();
    private final LinkedList<BlockPos> toCheck = new LinkedList();
    protected byte[] checkResults;
    private byte[] requiredCache;
    private int[] breakOrder;
    private int[] placeOrder;
    public Vec3d robotPos = null;
    public Vec3d prevRobotPos = null;
    public int leftToBreak = 0;
    public int leftToPlace = 0;

    protected SnapshotBuilder(T tile) {
        this.tile = tile;
    }

    protected abstract Snapshot.BuildingInfo getBuildingInfo();

    public void validate() {
        if (!this.tile.getWorldBC().field_72995_K) {
            this.tile.getWorldBC().func_72954_a(this.worldEventListener);
        }
    }

    public void invalidate() {
        if (!this.tile.getWorldBC().field_72995_K) {
            this.tile.getWorldBC().func_72848_b(this.worldEventListener);
        }
    }

    protected abstract boolean isAir(BlockPos var1);

    protected abstract boolean canPlace(BlockPos var1);

    protected abstract boolean isReadyToPlace(BlockPos var1);

    protected abstract boolean hasEnoughToPlaceItems(BlockPos var1);

    protected abstract List<ItemStack> getToPlaceItems(BlockPos var1);

    protected abstract boolean doPlaceTask(PlaceTask var1);

    private void cancelBreakTask(BreakTask breakTask) {
        this.tile.getBattery().addPower(Math.min(breakTask.power, this.tile.getBattery().getCapacity() - this.tile.getBattery().getStored()), false);
    }

    protected void cancelPlaceTask(PlaceTask placeTask) {
        this.tile.getBattery().addPower(Math.min(placeTask.power, this.tile.getBattery().getCapacity() - this.tile.getBattery().getStored()), false);
    }

    protected abstract boolean isBlockCorrect(BlockPos var1);

    public Vec3d getPlaceTaskItemPos(PlaceTask placeTask) {
        Vec3d height = new Vec3d((Vec3i)placeTask.pos.func_177973_b((Vec3i)this.tile.getBuilderPos()));
        double progress = (double)placeTask.power * 1.0 / (double)placeTask.getTarget();
        return new Vec3d((Vec3i)this.tile.getBuilderPos()).func_178787_e(height.func_186678_a(progress)).func_178787_e(new Vec3d(0.0, Math.sin(progress * Math.PI) * (Math.abs(height.field_72448_b) + 1.0), 0.0)).func_178787_e(new Vec3d(0.5, 1.0, 0.5));
    }

    public void updateSnapshot() {
        this.tile.getWorldBC().field_72984_F.func_76320_a("init");
        this.toCheck.addAll(this.getBuildingInfo().box.getBlocksInArea());
        this.toCheck.sort(BlockUtil.uniqueBlockPosComparator(Comparator.comparingDouble(blockPos -> Math.pow(blockPos.func_177958_n() - this.getBuildingInfo().box.center().func_177958_n(), 2.0) + Math.pow(blockPos.func_177956_o() - this.getBuildingInfo().box.center().func_177956_o(), 2.0) + Math.pow(blockPos.func_177952_p() - this.getBuildingInfo().box.center().func_177952_p(), 2.0))));
        this.checkResults = new byte[this.getBuildingInfo().box.size().func_177958_n() * this.getBuildingInfo().box.size().func_177956_o() * this.getBuildingInfo().box.size().func_177952_p()];
        Arrays.fill(this.checkResults, (byte)0);
        this.requiredCache = new byte[this.getBuildingInfo().box.size().func_177958_n() * this.getBuildingInfo().box.size().func_177956_o() * this.getBuildingInfo().box.size().func_177952_p()];
        Arrays.fill(this.requiredCache, (byte)0);
        this.breakOrder = this.getBuildingInfo().box.getBlocksInArea().stream().sorted(BlockUtil.uniqueBlockPosComparator(Comparator.comparingDouble(blockPos -> Math.pow(blockPos.func_177958_n() - this.getBuildingInfo().box.center().func_177958_n(), 2.0) + Math.pow(blockPos.func_177952_p() - this.getBuildingInfo().box.center().func_177952_p(), 2.0) + 100000.0 - (double)(Math.abs(blockPos.func_177956_o() - this.tile.getBuilderPos().func_177956_o()) * 100000)))).mapToInt(this::posToIndex).toArray();
        this.placeOrder = this.getBuildingInfo().box.getBlocksInArea().stream().sorted(BlockUtil.uniqueBlockPosComparator(Comparator.comparingDouble(blockPos -> 100000.0 - (Math.pow(blockPos.func_177958_n() - this.tile.getBuilderPos().func_177958_n(), 2.0) + Math.pow(blockPos.func_177952_p() - this.tile.getBuilderPos().func_177952_p(), 2.0)) + (double)(Math.abs(blockPos.func_177956_o() - this.tile.getBuilderPos().func_177956_o()) * 100000)))).mapToInt(this::posToIndex).toArray();
        this.tile.getWorldBC().field_72984_F.func_76319_b();
    }

    public void resourcesChanged() {
        Arrays.fill(this.requiredCache, (byte)0);
    }

    public void cancel() {
        this.breakTasks.forEach(this::cancelBreakTask);
        this.placeTasks.forEach(this::cancelPlaceTask);
        this.breakTasks.clear();
        this.clientBreakTasks.clear();
        this.prevClientBreakTasks.clear();
        this.placeTasks.clear();
        this.clientPlaceTasks.clear();
        this.prevClientPlaceTasks.clear();
        this.toCheck.clear();
        this.checkResults = null;
        this.requiredCache = null;
        this.breakOrder = null;
        this.placeOrder = null;
        this.robotPos = null;
        this.prevRobotPos = null;
        this.leftToBreak = 0;
        this.leftToPlace = 0;
    }

    public boolean tick() {
        long target;
        Iterator iterator;
        int[] blocks;
        if (this.tile.getWorldBC().field_72995_K) {
            this.prevClientBreakTasks.clear();
            this.prevClientBreakTasks.addAll(this.clientBreakTasks);
            this.clientBreakTasks.clear();
            this.clientBreakTasks.addAll(this.breakTasks);
            this.prevClientPlaceTasks.clear();
            this.prevClientPlaceTasks.addAll(this.clientPlaceTasks);
            this.clientPlaceTasks.clear();
            this.clientPlaceTasks.addAll(this.placeTasks);
            this.prevRobotPos = this.robotPos;
            if (!this.breakTasks.isEmpty()) {
                Vec3d newRobotPos = this.breakTasks.stream().map(breakTask -> breakTask.pos).map(Vec3d::new).reduce(Vec3d.field_186680_a, Vec3d::func_178787_e).func_186678_a(1.0 / (double)this.breakTasks.size());
                newRobotPos = new Vec3d(newRobotPos.field_72450_a, this.breakTasks.stream().map(breakTask -> breakTask.pos).mapToDouble(Vec3i::func_177956_o).max().orElse(newRobotPos.field_72448_b), newRobotPos.field_72449_c);
                newRobotPos = newRobotPos.func_178787_e(new Vec3d(0.0, 3.0, 0.0));
                Vec3d oldRobotPos = this.robotPos;
                this.robotPos = newRobotPos;
                if (oldRobotPos != null) {
                    this.robotPos = oldRobotPos.func_178787_e(newRobotPos.func_178788_d(oldRobotPos).func_186678_a(0.25));
                }
            } else {
                this.robotPos = null;
            }
            return false;
        }
        boolean checkResultsChanged = false;
        this.tile.getWorldBC().field_72984_F.func_76320_a("scan");
        if (!this.toCheck.isEmpty()) {
            for (int i2 = 0; i2 < 10; ++i2) {
                BlockPos blockPos2 = this.toCheck.pollFirst();
                if (this.check(blockPos2)) {
                    checkResultsChanged = true;
                }
                this.toCheck.addLast(blockPos2);
            }
        }
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        this.tile.getWorldBC().field_72984_F.func_76320_a("remove tasks");
        this.tile.getWorldBC().field_72984_F.func_76320_a("break");
        Iterator iterator2 = this.breakTasks.iterator();
        while (iterator2.hasNext()) {
            BreakTask breakTask2 = (BreakTask)iterator2.next();
            if (this.checkResults[this.posToIndex(breakTask2.pos)] != 1) continue;
            iterator2.remove();
            this.cancelBreakTask(breakTask2);
        }
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        this.tile.getWorldBC().field_72984_F.func_76320_a("place");
        iterator2 = this.placeTasks.iterator();
        while (iterator2.hasNext()) {
            PlaceTask placeTask2 = (PlaceTask)iterator2.next();
            if (this.checkResults[this.posToIndex(placeTask2.pos)] != 1) continue;
            iterator2.remove();
            this.cancelPlaceTask(placeTask2);
        }
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        boolean isDone = true;
        this.tile.getWorldBC().field_72984_F.func_76320_a("add tasks");
        this.tile.getWorldBC().field_72984_F.func_76320_a("break");
        if (this.tile.canExcavate()) {
            Set breakTasksIndexes = this.breakTasks.stream().map(breakTask -> this.posToIndex(breakTask.pos)).collect(Collectors.toSet());
            blocks = Arrays.stream(this.breakOrder).filter(i -> this.checkResults[i] == 2 && !breakTasksIndexes.contains(i)).toArray();
            this.leftToBreak = blocks.length;
            if (blocks.length != 0) {
                isDone = false;
            }
            Arrays.stream(blocks).mapToObj(this::indexToPos).filter(blockPos -> BlockUtil.getFluidWithFlowing(this.tile.getWorldBC(), blockPos) == null).map(blockPos -> new BreakTask((BlockPos)blockPos, 0L)).limit(64 - this.breakTasks.size()).forEach(this.breakTasks::add);
        }
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        this.tile.getWorldBC().field_72984_F.func_76320_a("place");
        Set placeTasksIndexes = this.placeTasks.stream().map(placeTask -> this.posToIndex(placeTask.pos)).collect(Collectors.toSet());
        blocks = Arrays.stream(this.placeOrder).filter(i -> this.checkResults[i] == 3 && !placeTasksIndexes.contains(i)).toArray();
        this.leftToPlace = blocks.length;
        if (!this.tile.canExcavate() || this.breakTasks.isEmpty()) {
            if (blocks.length != 0) {
                isDone = false;
            }
            Arrays.stream(blocks).filter(i -> {
                if (this.requiredCache[i] != 0) {
                    return this.requiredCache[i] == 1;
                }
                boolean has = this.hasEnoughToPlaceItems(this.indexToPos(i));
                this.requiredCache[i] = has ? 1 : 2;
                return has;
            }).mapToObj(this::indexToPos).filter(this::isReadyToPlace).limit(64 - this.placeTasks.size()).filter(this::canPlace).map(blockPos -> new PlaceTask((BlockPos)blockPos, this.getToPlaceItems((BlockPos)blockPos), 0L)).filter(placeTask -> placeTask.items != null).forEach(this.placeTasks::add);
        }
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        this.tile.getWorldBC().field_72984_F.func_76320_a("do tasks");
        this.tile.getWorldBC().field_72984_F.func_76320_a("break");
        if (!this.breakTasks.isEmpty()) {
            iterator = this.breakTasks.iterator();
            while (iterator.hasNext()) {
                BreakTask breakTask3 = (BreakTask)iterator.next();
                target = breakTask3.getTarget();
                breakTask3.power += this.tile.getBattery().extractPower(0L, Math.min(Math.min(target - breakTask3.power, this.tile.getBattery().getStored() / (long)this.breakTasks.size()), 10000000L));
                if (breakTask3.power >= target) {
                    BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.tile.getWorldBC(), breakTask3.pos, this.tile.getWorldBC().func_180495_p(breakTask3.pos), (EntityPlayer)BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)this.tile.getWorldBC(), this.tile.getOwner(), this.tile.getBuilderPos()));
                    MinecraftForge.EVENT_BUS.post((Event)breakEvent);
                    if (!breakEvent.isCanceled()) {
                        this.tile.getWorldBC().field_72984_F.func_76320_a("work");
                        this.tile.getWorldBC().func_175715_c(breakTask3.pos.hashCode(), breakTask3.pos, -1);
                        this.tile.getWorldBC().func_175655_b(breakTask3.pos, false);
                        this.tile.getWorldBC().field_72984_F.func_76319_b();
                    } else {
                        this.cancelBreakTask(breakTask3);
                    }
                    if (this.check(breakTask3.pos)) {
                        checkResultsChanged = true;
                    }
                    iterator.remove();
                    continue;
                }
                this.tile.getWorldBC().field_72984_F.func_76320_a("work");
                this.tile.getWorldBC().func_175715_c(breakTask3.pos.hashCode(), breakTask3.pos, (int)(breakTask3.power * 9L / target));
                this.tile.getWorldBC().field_72984_F.func_76319_b();
            }
        }
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        this.tile.getWorldBC().field_72984_F.func_76320_a("place");
        if (!this.placeTasks.isEmpty()) {
            iterator = this.placeTasks.iterator();
            while (iterator.hasNext()) {
                PlaceTask placeTask3 = (PlaceTask)iterator.next();
                target = placeTask3.getTarget();
                placeTask3.power += this.tile.getBattery().extractPower(0L, Math.min(Math.min(target - placeTask3.power, this.tile.getBattery().getStored() / (long)this.placeTasks.size()), 10000000L));
                if (placeTask3.power < target) continue;
                this.tile.getWorldBC().field_72984_F.func_76320_a("work");
                if (!this.doPlaceTask(placeTask3)) {
                    this.cancelPlaceTask(placeTask3);
                }
                this.tile.getWorldBC().field_72984_F.func_76319_b();
                if (this.check(placeTask3.pos)) {
                    checkResultsChanged = true;
                }
                iterator.remove();
            }
        }
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        this.tile.getWorldBC().field_72984_F.func_76319_b();
        if (checkResultsChanged) {
            this.afterChecks();
        }
        return isDone;
    }

    protected int posToIndex(BlockPos blockPos) {
        return this.getBuildingInfo().getSnapshot().posToIndex(this.getBuildingInfo().fromWorld(blockPos));
    }

    protected BlockPos indexToPos(int i) {
        return this.getBuildingInfo().toWorld(this.getBuildingInfo().getSnapshot().indexToPos(i));
    }

    protected boolean check(BlockPos blockPos) {
        int i = this.posToIndex(blockPos);
        byte prev = this.checkResults[i];
        this.checkResults[i] = this.isAir(blockPos) ? (this.tile.getWorldBC().func_175623_d(blockPos) ? 1 : 2) : (this.isBlockCorrect(blockPos) ? 1 : (this.canPlace(blockPos) ? 3 : 2));
        return prev != this.checkResults[i];
    }

    protected void afterChecks() {
    }

    public void writeToByteBuf(PacketBufferBC buffer) {
        buffer.writeInt(this.breakTasks.size());
        this.breakTasks.forEach(breakTask -> breakTask.writePayload(buffer));
        buffer.writeInt(this.placeTasks.size());
        this.placeTasks.forEach(placeTask -> placeTask.writePayload(buffer));
        buffer.writeInt(this.leftToBreak);
        buffer.writeInt(this.leftToPlace);
    }

    public void readFromByteBuf(PacketBufferBC buffer) {
        this.breakTasks.clear();
        IntStream.range(0, buffer.readInt()).mapToObj(i -> new BreakTask(buffer)).forEach(this.breakTasks::add);
        this.placeTasks.clear();
        IntStream.range(0, buffer.readInt()).mapToObj(i -> new PlaceTask(buffer)).forEach(this.placeTasks::add);
        this.leftToBreak = buffer.readInt();
        this.leftToPlace = buffer.readInt();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("toCheck", (NBTBase)NBTUtilBC.writeCompoundList(this.toCheck.stream().map(NBTUtil::func_186859_a)));
        nbt.func_74773_a("checkResults", this.checkResults);
        nbt.func_74782_a("breakTasks", (NBTBase)NBTUtilBC.writeCompoundList(this.breakTasks.stream().map(BreakTask::writeToNBT)));
        nbt.func_74782_a("placeTasks", (NBTBase)NBTUtilBC.writeCompoundList(this.placeTasks.stream().map(PlaceTask::writeToNBT)));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.updateSnapshot();
        this.toCheck.clear();
        NBTUtilBC.readCompoundList(nbt.func_74781_a("toCheck")).map(NBTUtil::func_186861_c).forEach(this.toCheck::add);
        this.checkResults = nbt.func_74770_j("checkResults");
        this.breakTasks.clear();
        NBTUtilBC.readCompoundList(nbt.func_74781_a("breakTasks")).map(x$0 -> new BreakTask((NBTTagCompound)x$0)).forEach(this.breakTasks::add);
        this.placeTasks.clear();
        NBTUtilBC.readCompoundList(nbt.func_74781_a("placeTasks")).map(x$0 -> new PlaceTask((NBTTagCompound)x$0)).forEach(this.placeTasks::add);
    }

    public class PlaceTask {
        public final BlockPos pos;
        public final List<ItemStack> items;
        public long power;

        public PlaceTask(BlockPos pos, List<ItemStack> items, long power) {
            this.pos = pos;
            this.items = Optional.ofNullable(items).map(ImmutableList::copyOf).orElse(null);
            this.power = power;
        }

        public PlaceTask(PacketBufferBC buffer) {
            this.pos = MessageUtil.readBlockPos(buffer);
            this.items = IntStream.range(0, buffer.readInt()).mapToObj(j -> {
                try {
                    return buffer.func_150791_c();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            this.power = buffer.readLong();
        }

        public PlaceTask(NBTTagCompound nbt) {
            this.pos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("pos"));
            this.items = ImmutableList.copyOf((Collection)NBTUtilBC.readCompoundList(nbt.func_74781_a("items")).map(ItemStack::new).collect(Collectors.toList()));
            this.power = nbt.func_74763_f("power");
        }

        public long getTarget() {
            return (long)(Math.sqrt(this.pos.func_177951_i((Vec3i)SnapshotBuilder.this.tile.getBuilderPos())) * 10.0 * 1000000.0);
        }

        public void writePayload(PacketBufferBC buffer) {
            MessageUtil.writeBlockPos(buffer, this.pos);
            buffer.writeInt(this.items.size());
            this.items.forEach(arg_0 -> ((PacketBufferBC)buffer).func_150788_a(arg_0));
            buffer.writeLong(this.power);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
            nbt.func_74782_a("items", (NBTBase)NBTUtilBC.writeCompoundList(this.items.stream().map(ItemStack::serializeNBT)));
            nbt.func_74772_a("power", this.power);
            return nbt;
        }
    }

    public class BreakTask {
        public final BlockPos pos;
        public long power;

        public BreakTask(BlockPos pos, long power) {
            this.pos = pos;
            this.power = power;
        }

        public BreakTask(PacketBufferBC buffer) {
            this.pos = MessageUtil.readBlockPos(buffer);
            this.power = buffer.readLong();
        }

        public BreakTask(NBTTagCompound nbt) {
            this.pos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("pos"));
            this.power = nbt.func_74763_f("power");
        }

        public long getTarget() {
            return BlockUtil.computeBlockBreakPower(SnapshotBuilder.this.tile.getWorldBC(), this.pos);
        }

        public void writePayload(PacketBufferBC buffer) {
            MessageUtil.writeBlockPos(buffer, this.pos);
            buffer.writeLong(this.power);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
            nbt.func_74772_a("power", this.power);
            return nbt;
        }
    }
}

