/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.schematics.ISchematicEntity;
import buildcraft.api.schematics.SchematicEntityContext;
import buildcraft.api.schematics.SchematicEntityFactory;
import buildcraft.api.schematics.SchematicEntityFactoryRegistry;
import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SchematicEntityManager {
    public static ISchematicEntity getSchematicEntity(SchematicEntityContext context) {
        for (SchematicEntityFactory schematicEntityFactory : Lists.reverse(SchematicEntityFactoryRegistry.getFactories())) {
            if (!schematicEntityFactory.predicate.test(context)) continue;
            ISchematicEntity schematicEntity = (ISchematicEntity)schematicEntityFactory.supplier.get();
            schematicEntity.init(context);
            return schematicEntity;
        }
        return null;
    }

    public static ISchematicEntity getSchematicEntity(World world, BlockPos basePos, Entity entity) {
        return SchematicEntityManager.getSchematicEntity(new SchematicEntityContext(world, basePos, entity));
    }

    public static <S extends ISchematicEntity> S createCleanCopy(S schematicBlock) {
        return (S)((ISchematicEntity)SchematicEntityFactoryRegistry.getFactoryByInstance(schematicBlock).supplier.get());
    }

    @Nonnull
    public static <S extends ISchematicEntity> NBTTagCompound writeToNBT(S schematicEntity) {
        NBTTagCompound schematicEntityTag = new NBTTagCompound();
        schematicEntityTag.func_74778_a("name", SchematicEntityFactoryRegistry.getFactoryByInstance(schematicEntity).name.toString());
        schematicEntityTag.func_74782_a("data", (NBTBase)schematicEntity.serializeNBT());
        return schematicEntityTag;
    }

    @Nonnull
    public static ISchematicEntity readFromNBT(NBTTagCompound schematicEntityTag) throws InvalidInputDataException {
        ResourceLocation name = new ResourceLocation(schematicEntityTag.func_74779_i("name"));
        SchematicEntityFactory<?> factory = SchematicEntityFactoryRegistry.getFactoryByName(name);
        if (factory == null) {
            throw new InvalidInputDataException("Unknown schematic type " + name);
        }
        ISchematicEntity schematicEntity = (ISchematicEntity)factory.supplier.get();
        NBTTagCompound data = schematicEntityTag.func_74775_l("data");
        try {
            schematicEntity.deserializeNBT(data);
            return schematicEntity;
        }
        catch (InvalidInputDataException e) {
            throw new InvalidInputDataException("Failed to load the schematic from " + data, e);
        }
    }
}

