/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.builders.snapshot.NbtPath;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class NbtRef<N extends NBTBase> {
    private final NbtPath path;
    private final N value;
    public static final TypeAdapterFactory TYPE_ADAPTER_FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (type.getRawType() != NbtRef.class) {
                return null;
            }
            final Class nClass = (Class)((ParameterizedType)type.getType()).getActualTypeArguments()[0];
            if (nClass == NBTTagByteArray.class || nClass == NBTTagIntArray.class || nClass == NBTTagList.class) {
                return new TypeAdapter<T>(){

                    public void write(JsonWriter out, T value) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public T read(JsonReader in) throws IOException {
                        if (in.peek() != JsonToken.BEGIN_ARRAY) {
                            return new NbtRef((NbtPath)((Map)gson.fromJson(in, new TypeToken<Map<String, NbtPath>>(){}.getType())).get("ref"), null, null);
                        }
                        return new NbtRef(null, (NBTBase)gson.fromJson(in, (Type)nClass), null);
                    }
                };
            }
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public T read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.BEGIN_ARRAY) {
                        return new NbtRef((NbtPath)gson.fromJson(in, NbtPath.class), null, null);
                    }
                    return new NbtRef(null, (NBTBase)gson.fromJson(in, (Type)nClass), null);
                }
            };
        }
    };

    private NbtRef(NbtPath path, N value) {
        this.path = path;
        this.value = value;
    }

    public N get(NBTBase nbt) {
        if (this.path != null) {
            return (N)this.path.get(nbt);
        }
        if (this.value != null) {
            return this.value;
        }
        return null;
    }

    public String toString() {
        return "NbtRef{path=" + this.path + ", value=" + this.value + "}";
    }

    /* synthetic */ NbtRef(NbtPath x0, NBTBase x1, 1 x2) {
        this(x0, x1);
    }
}

