/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import com.google.gson.JsonDeserializer;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NbtPath {
    private final List<String> elements;
    public static final JsonDeserializer<NbtPath> DESERIALIZER = (json, typeOfT, context) -> new NbtPath((List)context.deserialize(json, new TypeToken<List<String>>(){}.getType()));

    private NbtPath(List<String> elements) {
        this.elements = elements;
    }

    public NBTBase get(NBTTagByte tag) {
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagShort tag) {
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagInt tag) {
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagLong tag) {
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagFloat tag) {
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagDouble tag) {
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagByteArray tag) {
        if (this.elements.size() == 1) {
            int key;
            try {
                key = Integer.parseInt(this.elements.get(0));
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (key >= 0 && key < tag.func_150292_c().length) {
                return new NBTTagByte(tag.func_150292_c()[key]);
            }
            return null;
        }
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagString tag) {
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagList tag) {
        if (this.elements.size() == 1) {
            int key;
            try {
                key = Integer.parseInt(this.elements.get(0));
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (key >= 0 && key < tag.func_74745_c()) {
                return new NbtPath(this.elements.subList(1, this.elements.size())).get(tag.func_179238_g(key));
            }
            return null;
        }
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTTagCompound tag) {
        if (!this.elements.isEmpty()) {
            String key = this.elements.get(0);
            if (tag.func_74764_b(key)) {
                return new NbtPath(this.elements.subList(1, this.elements.size())).get(tag.func_74781_a(key));
            }
            return null;
        }
        return tag;
    }

    public NBTBase get(NBTTagIntArray tag) {
        if (this.elements.size() == 1) {
            int key;
            try {
                key = Integer.parseInt(this.elements.get(0));
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (key >= 0 && key < tag.func_150302_c().length) {
                return new NBTTagInt(tag.func_150302_c()[key]);
            }
            return null;
        }
        if (this.elements.isEmpty()) {
            return tag;
        }
        return null;
    }

    public NBTBase get(NBTBase tag) {
        switch (tag.func_74732_a()) {
            case 1: {
                return this.get((NBTTagByte)tag);
            }
            case 2: {
                return this.get((NBTTagShort)tag);
            }
            case 3: {
                return this.get((NBTTagInt)tag);
            }
            case 4: {
                return this.get((NBTTagLong)tag);
            }
            case 5: {
                return this.get((NBTTagFloat)tag);
            }
            case 6: {
                return this.get((NBTTagDouble)tag);
            }
            case 7: {
                return this.get((NBTTagByteArray)tag);
            }
            case 8: {
                return this.get((NBTTagString)tag);
            }
            case 9: {
                return this.get((NBTTagList)tag);
            }
            case 10: {
                return this.get((NBTTagCompound)tag);
            }
            case 11: {
                return this.get((NBTTagIntArray)tag);
            }
        }
        return null;
    }

    public String toString() {
        return "NbtPath{" + this.elements + "}";
    }
}

