/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.builders.snapshot.FakeWorld;
import buildcraft.builders.snapshot.MessageSnapshotRequest;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.lib.net.MessageManager;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public enum ClientSnapshots {
    INSTANCE;

    private final List<Snapshot> snapshots = new ArrayList<Snapshot>();
    private final List<Snapshot.Key> pending = new ArrayList<Snapshot.Key>();
    private final Map<Snapshot.Key, FakeWorld> worlds = new HashMap<Snapshot.Key, FakeWorld>();
    private final Map<Snapshot.Key, VertexBuffer> buffers = new HashMap<Snapshot.Key, VertexBuffer>();

    public Snapshot getSnapshot(Snapshot.Key key) {
        Snapshot found = this.snapshots.stream().filter(snapshot -> snapshot.key.equals(key)).findFirst().orElse(null);
        if (found == null && !this.pending.contains(key)) {
            this.pending.add(key);
            MessageManager.sendToServer(new MessageSnapshotRequest(key));
        }
        return found;
    }

    public void onSnapshotReceived(Snapshot snapshot) {
        this.pending.remove(snapshot.key);
        this.snapshots.add(snapshot);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSnapshot(Snapshot.Header header, int offsetX, int offsetY, int sizeX, int sizeY) {
        if (header == null) {
            return;
        }
        Snapshot snapshot = this.getSnapshot(header.key);
        if (snapshot == null) {
            return;
        }
        this.renderSnapshot(snapshot, offsetX, offsetY, sizeX, sizeY);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSnapshot(Snapshot snapshot, int offsetX, int offsetY, int sizeX, int sizeY) {
        FakeWorld world = this.worlds.computeIfAbsent(snapshot.key, key -> {
            FakeWorld localWorld = new FakeWorld();
            localWorld.uploadSnapshot(snapshot);
            return localWorld;
        });
        VertexBuffer vertexBuffer = this.buffers.computeIfAbsent(snapshot.key, key -> {
            VertexBuffer localBuffer = new VertexBuffer(1024){

                public void func_178965_a() {
                }
            };
            localBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (int z = 0; z < snapshot.size.func_177952_p(); ++z) {
                for (int y = 0; y < snapshot.size.func_177956_o(); ++y) {
                    for (int x = 0; x < snapshot.size.func_177958_n(); ++x) {
                        BlockPos pos = new BlockPos(x, y, z).func_177971_a((Vec3i)FakeWorld.BLUEPRINT_OFFSET);
                        localBuffer.func_178969_c((double)(-FakeWorld.BLUEPRINT_OFFSET.func_177958_n()), (double)(-FakeWorld.BLUEPRINT_OFFSET.func_177956_o()), (double)(-FakeWorld.BLUEPRINT_OFFSET.func_177952_p()));
                        Minecraft.func_71410_x().func_175602_ab().func_175018_a(world.func_180495_p(pos), pos, (IBlockAccess)world, localBuffer);
                        localBuffer.func_178969_c(0.0, 0.0, 0.0);
                    }
                }
            }
            localBuffer.func_178977_d();
            return localBuffer;
        });
        GlStateManager.func_179123_a();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int viewportX = offsetX * scaledResolution.func_78325_e();
        int viewportY = Minecraft.func_71410_x().field_71440_d - (sizeY + offsetY) * scaledResolution.func_78325_e();
        int viewportWidth = sizeX * scaledResolution.func_78325_e();
        int viewportHeight = sizeY * scaledResolution.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GlStateManager.func_179086_m((int)256);
        GL11.glDisable((int)3089);
        GlStateManager.func_179083_b((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GlStateManager.func_179152_a((float)scaledResolution.func_78325_e(), (float)scaledResolution.func_78325_e(), (float)1.0f);
        GLU.gluPerspective((float)70.0f, (float)((float)sizeX / (float)sizeY), (float)0.1f, (float)1000.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        int snapshotSize = Math.max(Math.max(snapshot.size.func_177958_n(), snapshot.size.func_177956_o()), snapshot.size.func_177956_o());
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-snapshotSize) * 2.0f - 3.0f));
        GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(System.currentTimeMillis() % 3600L) / 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)((float)(-snapshot.size.func_177958_n()) / 2.0f), (float)((float)(-snapshot.size.func_177956_o()) / 2.0f), (float)((float)(-snapshot.size.func_177952_p()) / 2.0f));
        GlStateManager.func_179109_b((float)0.0f, (float)((float)snapshotSize * 0.1f), (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(TextureMap.field_110575_b);
        new WorldVertexBufferUploader().func_181679_a(vertexBuffer);
        if (snapshotSize < 32) {
            TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
            for (int z = 0; z < snapshot.size.func_177952_p(); ++z) {
                for (int y = 0; y < snapshot.size.func_177956_o(); ++y) {
                    for (int x = 0; x < snapshot.size.func_177958_n(); ++x) {
                        BlockPos pos = new BlockPos(x, y, z).func_177971_a((Vec3i)FakeWorld.BLUEPRINT_OFFSET);
                        GlStateManager.func_179123_a();
                        TileEntityRendererDispatcher.field_147556_a.func_147549_a(world.func_175625_s(pos), (double)(pos.func_177958_n() - FakeWorld.BLUEPRINT_OFFSET.func_177958_n()), (double)(pos.func_177956_o() - FakeWorld.BLUEPRINT_OFFSET.func_177956_o()), (double)(pos.func_177952_p() - FakeWorld.BLUEPRINT_OFFSET.func_177952_p()), 0.0f);
                        GlStateManager.func_179099_b();
                    }
                }
            }
            TileEntityRendererDispatcher.field_147556_a.drawBatch(1);
        }
        for (Entity entity : world.func_175644_a(Entity.class, Predicates.alwaysTrue())) {
            Vec3d pos = entity.func_174791_d();
            switch (snapshot.facing) {
                case NORTH: {
                    pos = new Vec3d(pos.field_72450_a + (double)snapshot.size.func_177958_n() - 1.0, pos.field_72448_b, pos.field_72449_c);
                    break;
                }
                case SOUTH: {
                    pos = new Vec3d(pos.field_72450_a + (double)snapshot.size.func_177958_n() - 1.0, pos.field_72448_b, pos.field_72449_c + (double)snapshot.size.func_177952_p() - 1.0);
                    break;
                }
                case WEST: {
                    pos = new Vec3d(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c + (double)snapshot.size.func_177952_p() - 1.0);
                    break;
                }
                case EAST: {
                    pos = new Vec3d(pos.field_72450_a + (double)snapshot.size.func_177958_n() - 1.0, pos.field_72448_b, pos.field_72449_c + (double)snapshot.size.func_177952_p() - 1.0);
                }
            }
            GlStateManager.func_179123_a();
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, pos.field_72450_a - (double)FakeWorld.BLUEPRINT_OFFSET.func_177958_n(), pos.field_72448_b - (double)FakeWorld.BLUEPRINT_OFFSET.func_177956_o(), pos.field_72449_c - (double)FakeWorld.BLUEPRINT_OFFSET.func_177952_p(), 0.0f, 0.0f, true);
            GlStateManager.func_179099_b();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        GlStateManager.func_179099_b();
    }
}

