/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.ISchematicEntity;
import buildcraft.builders.snapshot.Blueprint;
import buildcraft.builders.snapshot.ITileForBlueprintBuilder;
import buildcraft.builders.snapshot.SchematicEntityManager;
import buildcraft.builders.snapshot.SnapshotBuilder;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class BlueprintBuilder
extends SnapshotBuilder<ITileForBlueprintBuilder> {
    private static final double MAX_ENTITY_DISTANCE = 0.1;
    private List<ItemStack>[] remainingDisplayRequiredBlocks;
    private List<ItemStack> remainingDisplayRequiredBlocksConcat = Collections.emptyList();
    public List<ItemStack> remainingDisplayRequired = new ArrayList<ItemStack>();
    private final Map<Pair<List<ItemStack>, List<FluidStack>>, Optional<List<ItemStack>>> extractRequiredCache = new HashMap<Pair<List<ItemStack>, List<FluidStack>>, Optional<List<ItemStack>>>();

    public BlueprintBuilder(ITileForBlueprintBuilder tile) {
        super(tile);
    }

    private ISchematicBlock getSchematicBlock(BlockPos blockPos) {
        BlockPos snapshotPos = this.getBuildingInfo().fromWorld(blockPos);
        return this.getBuildingInfo().box.contains(blockPos) ? this.getBuildingInfo().rotatedPalette.get(this.getBuildingInfo().getSnapshot().data[this.getBuildingInfo().getSnapshot().posToIndex(snapshotPos)]) : null;
    }

    @Override
    protected boolean isAir(BlockPos blockPos) {
        return this.getSchematicBlock(blockPos) == null || this.getSchematicBlock(blockPos).isAir();
    }

    @Override
    protected Blueprint.BuildingInfo getBuildingInfo() {
        return ((ITileForBlueprintBuilder)this.tile).getBlueprintBuildingInfo();
    }

    @Override
    public void updateSnapshot() {
        super.updateSnapshot();
        this.remainingDisplayRequiredBlocks = new List[this.getBuildingInfo().box.size().func_177958_n() * this.getBuildingInfo().box.size().func_177956_o() * this.getBuildingInfo().box.size().func_177952_p()];
        Arrays.fill(this.remainingDisplayRequiredBlocks, Collections.emptyList());
    }

    @Override
    public void resourcesChanged() {
        super.resourcesChanged();
        this.extractRequiredCache.clear();
    }

    @Override
    public void cancel() {
        super.cancel();
        this.remainingDisplayRequiredBlocks = null;
    }

    private Stream<ItemStack> getDisplayRequired(List<ItemStack> requiredItems, List<FluidStack> requiredFluids) {
        return Stream.concat(requiredItems == null ? Stream.empty() : requiredItems.stream(), requiredFluids == null ? Stream.empty() : requiredFluids.stream().map(FluidStack::getFluid).map(BlockUtil::getBucketFromFluid));
    }

    private Optional<List<ItemStack>> tryExtractRequired(List<ItemStack> requiredItems, List<FluidStack> requiredFluids, boolean simulate) {
        Supplier<Optional> function = () -> StackUtil.mergeSameItems(requiredItems).stream().noneMatch(stack -> ((ITileForBlueprintBuilder)this.tile).getInvResources().extract(extracted -> StackUtil.canMerge(stack, extracted), stack.func_190916_E(), stack.func_190916_E(), true).func_190926_b()) && FluidUtilBC.mergeSameFluids(requiredFluids).stream().allMatch(stack -> FluidUtilBC.areFluidStackEqual(stack, ((ITileForBlueprintBuilder)this.tile).getTankManager().drain((FluidStack)stack, false))) ? Optional.of(StackUtil.mergeSameItems(Stream.concat(requiredItems.stream().map(stack -> ((ITileForBlueprintBuilder)this.tile).getInvResources().extract(extracted -> StackUtil.canMerge(stack, extracted), stack.func_190916_E(), stack.func_190916_E(), simulate)), FluidUtilBC.mergeSameFluids(requiredFluids).stream().map(fluidStack -> ((ITileForBlueprintBuilder)this.tile).getTankManager().drain((FluidStack)fluidStack, !simulate)).map(fluidStack -> {
            ItemStack stack = BlockUtil.getBucketFromFluid(fluidStack.getFluid());
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74782_a("BuilderFluidStack", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            return stack;
        })).collect(Collectors.toList()))) : Optional.empty();
        if (!simulate) {
            return function.get();
        }
        return this.extractRequiredCache.computeIfAbsent((Pair<List<ItemStack>, List<FluidStack>>)Pair.of(requiredItems, requiredFluids), pair -> (Optional)function.get());
    }

    @Override
    protected boolean canPlace(BlockPos blockPos) {
        return !this.isAir(blockPos) && this.getSchematicBlock(blockPos).canBuild(((ITileForBlueprintBuilder)this.tile).getWorldBC(), blockPos);
    }

    @Override
    protected boolean isReadyToPlace(BlockPos blockPos) {
        return this.getSchematicBlock(blockPos).getRequiredBlockOffsets().stream().map(arg_0 -> ((BlockPos)blockPos).func_177971_a(arg_0)).allMatch(pos -> this.getSchematicBlock((BlockPos)pos) == null || this.checkResults[this.posToIndex((BlockPos)pos)] == 1) && this.getSchematicBlock(blockPos).isReadyToBuild(((ITileForBlueprintBuilder)this.tile).getWorldBC(), blockPos);
    }

    @Override
    protected boolean hasEnoughToPlaceItems(BlockPos blockPos) {
        return Optional.ofNullable(this.getBuildingInfo()).flatMap(buildingInfo -> this.tryExtractRequired(buildingInfo.toPlaceRequiredItems[this.posToIndex(blockPos)], buildingInfo.toPlaceRequiredFluids[this.posToIndex(blockPos)], true)).isPresent();
    }

    @Override
    protected List<ItemStack> getToPlaceItems(BlockPos blockPos) {
        return Optional.ofNullable(this.getBuildingInfo()).flatMap(buildingInfo -> this.tryExtractRequired(buildingInfo.toPlaceRequiredItems[this.posToIndex(blockPos)], buildingInfo.toPlaceRequiredFluids[this.posToIndex(blockPos)], false)).orElse(null);
    }

    @Override
    protected void cancelPlaceTask(SnapshotBuilder.PlaceTask placeTask) {
        super.cancelPlaceTask(placeTask);
        placeTask.items.stream().filter(stack -> !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("BuilderFluidStack")).forEach(stack -> ((ITileForBlueprintBuilder)this.tile).getInvResources().insert((ItemStack)stack, false, false));
        placeTask.items.stream().filter(stack -> stack.func_77942_o() && stack.func_77978_p().func_74764_b("BuilderFluidStack")).map(stack -> Pair.of((Object)stack.func_190916_E(), (Object)stack.func_77978_p().func_74775_l("BuilderFluidStack"))).map(countNbt -> {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)countNbt.getRight()));
            if (fluidStack != null) {
                fluidStack.amount *= ((Integer)countNbt.getLeft()).intValue();
            }
            return fluidStack;
        }).forEach(fluidStack -> ((ITileForBlueprintBuilder)this.tile).getTankManager().fill((FluidStack)fluidStack, true));
    }

    @Override
    protected boolean isBlockCorrect(BlockPos blockPos) {
        return this.getBuildingInfo() != null && this.getSchematicBlock(blockPos) != null && this.getSchematicBlock(blockPos).isBuilt(((ITileForBlueprintBuilder)this.tile).getWorldBC(), blockPos);
    }

    @Override
    protected boolean doPlaceTask(SnapshotBuilder.PlaceTask placeTask) {
        return this.getBuildingInfo() != null && this.getSchematicBlock(placeTask.pos) != null && this.getSchematicBlock(placeTask.pos).build(((ITileForBlueprintBuilder)this.tile).getWorldBC(), placeTask.pos);
    }

    @Override
    public boolean tick() {
        if (((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72995_K) {
            return super.tick();
        }
        return Optional.ofNullable(this.getBuildingInfo()).map(buildingInfo -> {
            ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76320_a("entitiesWithinBox");
            List entitiesWithinBox = ((ITileForBlueprintBuilder)this.tile).getWorldBC().func_175647_a(Entity.class, buildingInfo.box.getBoundingBox(), Objects::nonNull);
            ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76319_b();
            ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76320_a("toSpawn");
            List toSpawn = buildingInfo.entities.stream().filter(schematicEntity -> entitiesWithinBox.stream().map(Entity::func_174791_d).map(arg_0 -> ((Vec3d)schematicEntity.getPos().func_178787_e(new Vec3d((Vec3i)buildingInfo.basePos))).func_72438_d(arg_0)).noneMatch(distance -> distance < 0.1)).collect(Collectors.toList());
            ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76319_b();
            ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76320_a("remainingDisplayRequired");
            this.remainingDisplayRequired.clear();
            this.remainingDisplayRequired.addAll(StackUtil.mergeSameItems(Stream.concat(this.remainingDisplayRequiredBlocksConcat.stream(), toSpawn.stream().flatMap(schematicEntity -> this.getDisplayRequired(buildingInfo.entitiesRequiredItems.get(schematicEntity), buildingInfo.entitiesRequiredFluids.get(schematicEntity)))).collect(Collectors.toList())));
            ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76319_b();
            ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76320_a("toKill");
            List<Entity> toKill = entitiesWithinBox.stream().filter(entity -> {
                if (entity == null) return false;
                if (!buildingInfo.entities.stream().map(ISchematicEntity::getPos).map(arg_0 -> ((Vec3d)new Vec3d((Vec3i)buildingInfo.basePos)).func_178787_e(arg_0)).map(arg_0 -> ((Vec3d)entity.func_174791_d()).func_72438_d(arg_0)).noneMatch(distance -> distance < 0.1)) return false;
                if (SchematicEntityManager.getSchematicEntity(((ITileForBlueprintBuilder)this.tile).getWorldBC(), BlockPos.field_177992_a, entity) == null) return false;
                return true;
            }).collect(Collectors.toList());
            if (!toKill.isEmpty()) {
                if (!((ITileForBlueprintBuilder)this.tile).getBattery().isFull()) {
                    return false;
                }
                ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76320_a("kill");
                toKill.forEach(Entity::func_70106_y);
                ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76319_b();
            }
            ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76319_b();
            if (super.tick()) {
                if (!toSpawn.isEmpty()) {
                    if (!((ITileForBlueprintBuilder)this.tile).getBattery().isFull()) {
                        return false;
                    }
                    ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76320_a("spawn");
                    toSpawn.stream().filter(schematicEntity -> this.tryExtractRequired(buildingInfo.entitiesRequiredItems.get(schematicEntity), buildingInfo.entitiesRequiredFluids.get(schematicEntity), true).isPresent()).filter(schematicEntity -> schematicEntity.build(((ITileForBlueprintBuilder)this.tile).getWorldBC(), buildingInfo.basePos) != null).forEach(schematicEntity -> this.tryExtractRequired(buildingInfo.entitiesRequiredItems.get(schematicEntity), buildingInfo.entitiesRequiredFluids.get(schematicEntity), false));
                    ((ITileForBlueprintBuilder)this.tile).getWorldBC().field_72984_F.func_76319_b();
                }
                return true;
            }
            return false;
        }).orElseGet(() -> super.tick());
    }

    @Override
    protected boolean check(BlockPos blockPos) {
        if (super.check(blockPos)) {
            this.remainingDisplayRequiredBlocks[this.posToIndex((BlockPos)blockPos)] = this.checkResults[this.posToIndex(blockPos)] != 1 ? this.getDisplayRequired(this.getBuildingInfo().toPlaceRequiredItems[this.posToIndex(blockPos)], this.getBuildingInfo().toPlaceRequiredFluids[this.posToIndex(blockPos)]).collect(Collectors.toList()) : Collections.emptyList();
            return true;
        }
        return false;
    }

    @Override
    protected void afterChecks() {
        this.remainingDisplayRequiredBlocksConcat = StackUtil.mergeSameItems(Arrays.stream(this.remainingDisplayRequiredBlocks).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    public void writeToByteBuf(PacketBufferBC buffer) {
        super.writeToByteBuf(buffer);
        buffer.writeInt(this.remainingDisplayRequired.size());
        this.remainingDisplayRequired.forEach(stack -> {
            buffer.func_150788_a((ItemStack)stack);
            buffer.writeInt(stack.func_190916_E());
        });
    }

    @Override
    public void readFromByteBuf(PacketBufferBC buffer) {
        super.readFromByteBuf(buffer);
        this.remainingDisplayRequired.clear();
        IntStream.range(0, buffer.readInt()).mapToObj(i -> {
            ItemStack stack;
            try {
                stack = buffer.func_150791_c();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            stack.func_190920_e(buffer.readInt());
            return stack;
        }).forEach(this.remainingDisplayRequired::add);
    }
}

