/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.container.ContainerFiller;
import buildcraft.builders.container.ContainerFillingPlanner;
import buildcraft.builders.container.IContainerFilling;
import buildcraft.builders.filling.Filling;
import buildcraft.builders.filling.IParameter;
import buildcraft.lib.client.sprite.RawSprite;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.button.GuiSpriteButton;
import buildcraft.lib.gui.elem.ToolTip;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiFilling
extends GuiBC8<ContainerBC_Neptune> {
    private static final ResourceLocation FILLING_PLANNER_TEXTURE_BASE = new ResourceLocation("buildcraftbuilders:textures/gui/filling_planner.png");
    private static final int FILLING_PLANNER_SIZE_X = 176;
    private static final int FILLING_PLANNER_SIZE_Y = 42;
    private static final GuiIcon FILLING_PLANNER_ICON_GUI = new GuiIcon(FILLING_PLANNER_TEXTURE_BASE, 0, 0, 176, 42);
    private static final ResourceLocation FILLER_TEXTURE_BASE = new ResourceLocation("buildcraftbuilders:textures/gui/filler.png");
    private static final int FILLER_SIZE_X = 176;
    private static final int FILLER_SIZE_Y = 241;
    private static final GuiIcon FILLER_ICON_GUI = new GuiIcon(FILLER_TEXTURE_BASE, 0, 0, 176, 241);
    private final ResourceLocation textureBase;
    private final GuiIcon iconGui;

    public GuiFilling(ContainerBC_Neptune container) {
        super(container);
        if (container instanceof ContainerFillingPlanner) {
            this.field_146999_f = 176;
            this.field_147000_g = 42;
            this.textureBase = FILLING_PLANNER_TEXTURE_BASE;
            this.iconGui = FILLING_PLANNER_ICON_GUI;
        } else if (container instanceof ContainerFiller) {
            this.field_146999_f = 176;
            this.field_147000_g = 241;
            this.textureBase = FILLER_TEXTURE_BASE;
            this.iconGui = FILLER_ICON_GUI;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.container instanceof ContainerFiller) {
            this.field_146292_n.add(new GuiSpriteButton(this, 0, this.rootElement.getX() + 130, this.rootElement.getY() + 18, 16, 16, new GuiIcon(this.textureBase, 192, 0, 16, 16), new GuiIcon(this.textureBase, 208, 0, 16, 16), new GuiIcon(this.textureBase, 192, 16, 16, 16), new GuiIcon(this.textureBase, 208, 16, 16, 16)).setToolTip(ToolTip.createLocalized("gui.filler.excavate")).setActive(((IContainerFilling)((Object)this.container)).isCanExcavate()).registerListener((button, buttonId, buttonKey) -> {
                boolean value = !((IContainerFilling)((Object)this.container)).isCanExcavate();
                ((IContainerFilling)((Object)this.container)).setCanExcavate(value);
                ((GuiSpriteButton)button).setActive(value);
            }));
        }
        this.field_146292_n.add(new GuiSpriteButton(this, 1, this.rootElement.getX() + 152, this.rootElement.getY() + 18, 16, 16, new GuiIcon(this.textureBase, 224, 0, 16, 16), new GuiIcon(this.textureBase, 240, 0, 16, 16), new GuiIcon(this.textureBase, 224, 16, 16, 16), new GuiIcon(this.textureBase, 240, 16, 16, 16)).setToolTip(ToolTip.createLocalized("gui.filler.inverted")).setActive(((IContainerFilling)((Object)this.container)).isInverted()).registerListener((button, buttonId, buttonKey) -> {
            boolean value = !((IContainerFilling)((Object)this.container)).isInverted();
            ((IContainerFilling)((Object)this.container)).setInverted(value);
            ((GuiSpriteButton)button).setActive(value);
        }));
    }

    private void iterateParameters(List<IParameter> parameters, IParameterIterator iterator) {
        for (int i = 0; i < parameters.size(); ++i) {
            IParameter parameter = parameters.get(i);
            iterator.call(i, this.rootElement.getX() + 8 + i * 18, this.rootElement.getY() + 18, 16, 16, parameter);
        }
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        this.iconGui.drawAt(this.rootElement);
    }

    @Override
    protected void drawForegroundLayer() {
        GlStateManager.func_179141_d();
        List<IParameter> parameters = ((IContainerFilling)((Object)this.container)).getParameters();
        this.iterateParameters(parameters, (i, x, y, width, height, parameter) -> new GuiIcon(new RawSprite(new ResourceLocation("buildcraftbuilders:textures/filling/" + parameter.getParameterName() + "/" + parameter.getName() + ".png"), 0, 0, width, height, (width + height) / 2), (width + height) / 2).drawAt(x, y));
        this.iterateParameters(parameters, (i, x, y, width, height, parameter) -> {
            if (this.mouse.getX() >= x && this.mouse.getX() < x + width && this.mouse.getY() >= y && this.mouse.getY() < y + height) {
                this.func_146283_a(Collections.singletonList(parameter.getParameterName() + ": " + parameter.getName()), this.mouse.getX(), this.mouse.getY());
            }
        });
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        AtomicBoolean found = new AtomicBoolean(false);
        ArrayList<IParameter> parameters = new ArrayList<IParameter>(((IContainerFilling)((Object)this.container)).getParameters());
        this.iterateParameters(parameters, (i, x, y, width, height, parameter) -> {
            if (mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height) {
                IParameter[] values = (IParameter[])parameter.getClass().getEnumConstants();
                parameters.set(i, values[(parameter.getOrdinal() + values.length + (mouseButton == 1 ? -1 : 1)) % values.length]);
                int j = i + 1;
                while (true) {
                    Class<? extends IParameter> nextParameterClass = Filling.getNextParameterClass(parameters.subList(0, Math.min(j, parameters.size())));
                    if (j < parameters.size()) {
                        if (((IParameter)parameters.get(j)).getClass().equals(nextParameterClass)) {
                            ++j;
                            continue;
                        }
                        IntStream.range(j, parameters.size()).forEach(k -> {
                            IParameter cfr_ignored_0 = (IParameter)parameters.remove(parameters.size() - 1);
                        });
                    }
                    if (nextParameterClass == null) break;
                    parameters.add(nextParameterClass.getEnumConstants()[0]);
                    ++j;
                }
                ((IContainerFilling)((Object)this.container)).setParameters(parameters);
                found.set(true);
            }
        });
        if (!found.get()) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    @FunctionalInterface
    private static interface IParameterIterator {
        public void call(int var1, int var2, int var3, int var4, int var5, IParameter var6);
    }
}

