/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.filling;

import buildcraft.builders.filling.EnumParameterAxis;
import buildcraft.builders.filling.EnumParameterFacing;
import buildcraft.builders.filling.EnumParameterPattern;
import buildcraft.builders.filling.EnumParameterType;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;

public interface IParameter {
    public String name();

    public int ordinal();

    default public String getParameterName() {
        return EnumParameter.getForClass(this.getClass()).name().toLowerCase(Locale.ROOT);
    }

    default public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    default public int getOrdinal() {
        return this.ordinal();
    }

    public static void toBytes(ByteBuf buf, IParameter parameter) {
        new PacketBufferBC(buf).writeInt(EnumParameter.getForClass(parameter.getClass()).ordinal());
        new PacketBufferBC(buf).writeInt(parameter.getOrdinal());
    }

    public static IParameter fromBytes(ByteBuf buf) {
        return EnumParameter.values()[buf.readInt()].clazz.getEnumConstants()[buf.readInt()];
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound nbt, IParameter parameter) {
        nbt.func_74768_a("type", EnumParameter.getForClass(parameter.getClass()).ordinal());
        nbt.func_74768_a("ordinal", parameter.getOrdinal());
        return nbt;
    }

    public static IParameter readFromNBT(NBTTagCompound nbt) {
        return EnumParameter.values()[nbt.func_74762_e((String)"type")].clazz.getEnumConstants()[nbt.func_74762_e("ordinal")];
    }

    public static enum EnumParameter {
        PATTERN(EnumParameterPattern.class),
        TYPE(EnumParameterType.class),
        AXIS(EnumParameterAxis.class),
        FACING(EnumParameterFacing.class);

        public final Class<? extends IParameter> clazz;

        private EnumParameter(Class<? extends IParameter> clazz) {
            this.clazz = clazz;
        }

        public static EnumParameter getForClass(Class<? extends IParameter> clazz) {
            return Arrays.stream(EnumParameter.values()).filter(enumTarget -> enumTarget.clazz == clazz).findFirst().orElse(null);
        }
    }
}

