/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.filling;

import buildcraft.builders.filling.EnumParameterAxis;
import buildcraft.builders.filling.EnumParameterFacing;
import buildcraft.builders.filling.EnumParameterPattern;
import buildcraft.builders.filling.EnumParameterType;
import buildcraft.builders.filling.FillingCircle;
import buildcraft.builders.filling.FillingFrame;
import buildcraft.builders.filling.FillingPolygon;
import buildcraft.builders.filling.FillingSphere;
import buildcraft.builders.filling.FillingSquare;
import buildcraft.builders.filling.FillingStairs;
import buildcraft.builders.filling.FillingTriangle;
import buildcraft.builders.filling.IParameter;
import buildcraft.builders.snapshot.Template;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javax.vecmath.Point2d;
import javax.vecmath.Point2i;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class Filling {
    private static List<Item> itemBlocks = new ArrayList<Item>();
    private static final List<Point2d> PENTAGON_POINTS = Arrays.asList(new Point2d(1.0, 0.5), new Point2d(0.6545084971874737, 0.9755282581475768), new Point2d(0.09549150281252633, 0.7938926261462367), new Point2d(0.09549150281252627, 0.2061073738537635), new Point2d(0.6545084971874736, 0.02447174185242318));
    private static final List<Point2d> HEXAGON_POINTS = Arrays.asList(new Point2d(1.0, 0.5), new Point2d(0.75, 0.9330127018922193), new Point2d(0.25, 0.9330127018922194), new Point2d(0.0, 0.5), new Point2d(0.25, 0.06698729810778076), new Point2d(0.75, 0.06698729810778048));
    private static final List<Point2d> OCTAGON_POINTS = Arrays.asList(new Point2d(0.9619397662556434, 0.6913417161825449), new Point2d(0.6913417161825449, 0.9619397662556434), new Point2d(0.30865828381745514, 0.9619397662556434), new Point2d(0.03806023374435663, 0.6913417161825449), new Point2d(0.038060233744356575, 0.3086582838174552), new Point2d(0.30865828381745486, 0.03806023374435674), new Point2d(0.691341716182545, 0.038060233744356686), new Point2d(0.9619397662556433, 0.3086582838174548));

    public static void addItemBlock(Item ... items) {
        itemBlocks.addAll(Arrays.asList(items));
    }

    public static List<Item> getItemBlocks() {
        return new ArrayList<Item>(itemBlocks);
    }

    public static Class<? extends IParameter> getNextParameterClass(List<IParameter> parameters) {
        if (parameters.size() == 0) {
            return EnumParameterPattern.class;
        }
        EnumParameterPattern parameterPattern = (EnumParameterPattern)parameters.get(0);
        if (parameterPattern == EnumParameterPattern.STAIRS) {
            if (parameters.size() == 1) {
                return EnumParameterType.class;
            }
            if (parameters.size() == 2) {
                return EnumParameterFacing.class;
            }
        }
        if (parameterPattern == EnumParameterPattern.TRIANGLE) {
            if (parameters.size() == 1) {
                return EnumParameterType.class;
            }
            if (parameters.size() == 2) {
                return EnumParameterFacing.class;
            }
        }
        if (parameterPattern == EnumParameterPattern.SQUARE) {
            EnumParameterType parameterType;
            if (parameters.size() == 1) {
                return EnumParameterType.class;
            }
            if (parameters.size() == 2 && (parameterType = (EnumParameterType)parameters.get(1)) == EnumParameterType.HOLLOW) {
                return EnumParameterAxis.class;
            }
        }
        if (parameterPattern == EnumParameterPattern.PENTAGON) {
            if (parameters.size() == 1) {
                return EnumParameterType.class;
            }
            if (parameters.size() == 2) {
                return EnumParameterAxis.class;
            }
        }
        if (parameterPattern == EnumParameterPattern.HEXAGON) {
            if (parameters.size() == 1) {
                return EnumParameterType.class;
            }
            if (parameters.size() == 2) {
                return EnumParameterAxis.class;
            }
        }
        if (parameterPattern == EnumParameterPattern.OCTAGON) {
            if (parameters.size() == 1) {
                return EnumParameterType.class;
            }
            if (parameters.size() == 2) {
                return EnumParameterAxis.class;
            }
        }
        if (parameterPattern == EnumParameterPattern.CIRCLE) {
            if (parameters.size() == 1) {
                return EnumParameterType.class;
            }
            if (parameters.size() == 2) {
                return EnumParameterAxis.class;
            }
        }
        if (parameterPattern == EnumParameterPattern.FRAME && parameters.size() == 1) {
            return EnumParameterType.class;
        }
        if (parameterPattern == EnumParameterPattern.SPHERE && parameters.size() == 1) {
            return EnumParameterType.class;
        }
        return null;
    }

    public static List<IParameter> initParameters() {
        Class<? extends IParameter> nextParameterClass;
        ArrayList<IParameter> parameters = new ArrayList<IParameter>();
        while ((nextParameterClass = Filling.getNextParameterClass(parameters)) != null) {
            parameters.add(nextParameterClass.getEnumConstants()[0]);
        }
        return ImmutableList.copyOf(parameters);
    }

    public static Template.BuildingInfo createBuildingInfo(BlockPos basePos, BlockPos size, List<IParameter> parameters, boolean inverted) {
        Template template = new Template();
        template.size = size;
        template.offset = BlockPos.field_177992_a;
        boolean[][][] fillingPlan = Filling.getFillingPlan(size, parameters);
        if (inverted) {
            fillingPlan = Filling.invertFillingPlan(size, fillingPlan);
        }
        template.data = new BitSet(size.func_177958_n() * size.func_177956_o() * size.func_177952_p());
        for (int z = 0; z < size.func_177952_p(); ++z) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int x = 0; x < size.func_177958_n(); ++x) {
                    template.data.set(template.posToIndex(x, y, z), fillingPlan[x][y][z]);
                }
            }
        }
        Template template2 = template;
        template2.getClass();
        return new Template.BuildingInfo(template2, basePos, Rotation.NONE);
    }

    public static boolean[][][] generateFillingPlanByFunction(BlockPos size, Function<BlockPos, Boolean> function) {
        boolean[][][] fillingPlan = new boolean[size.func_177958_n()][size.func_177956_o()][size.func_177952_p()];
        for (int z = 0; z < size.func_177952_p(); ++z) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int x = 0; x < size.func_177958_n(); ++x) {
                    fillingPlan[x][y][z] = function.apply(new BlockPos(x, y, z));
                }
            }
        }
        return fillingPlan;
    }

    public static boolean[][][] generateFillingPlanByFunctionInAxis(BlockPos size, EnumFacing.Axis axis, BiFunction<Point2i, Point2i, Boolean> function) {
        switch (axis) {
            case X: {
                return Filling.generateFillingPlanByFunction(size, pos -> (Boolean)function.apply(new Point2i(pos.func_177956_o(), pos.func_177952_p()), new Point2i(size.func_177956_o(), size.func_177952_p())));
            }
            case Y: {
                return Filling.generateFillingPlanByFunction(size, pos -> (Boolean)function.apply(new Point2i(pos.func_177958_n(), pos.func_177952_p()), new Point2i(size.func_177958_n(), size.func_177952_p())));
            }
            case Z: {
                return Filling.generateFillingPlanByFunction(size, pos -> (Boolean)function.apply(new Point2i(pos.func_177958_n(), pos.func_177956_o()), new Point2i(size.func_177958_n(), size.func_177956_o())));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean[][][] generateFillingPlanByFunctionInAxis(BlockPos size, EnumFacing.Axis axis, BiConsumer<Point2i, boolean[][]> function) {
        Point2i flatSize;
        switch (axis) {
            case X: {
                flatSize = new Point2i(size.func_177956_o(), size.func_177952_p());
                break;
            }
            case Y: {
                flatSize = new Point2i(size.func_177958_n(), size.func_177952_p());
                break;
            }
            case Z: {
                flatSize = new Point2i(size.func_177958_n(), size.func_177956_o());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean[][] flatFillingPlan = new boolean[flatSize.x][flatSize.y];
        function.accept(flatSize, flatFillingPlan);
        switch (axis) {
            case X: {
                return Filling.generateFillingPlanByFunction(size, pos -> flatFillingPlan[pos.func_177956_o()][pos.func_177952_p()]);
            }
            case Y: {
                return Filling.generateFillingPlanByFunction(size, pos -> flatFillingPlan[pos.func_177958_n()][pos.func_177952_p()]);
            }
            case Z: {
                return Filling.generateFillingPlanByFunction(size, pos -> flatFillingPlan[pos.func_177958_n()][pos.func_177956_o()]);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean[][][] generateFillingPlanByFunctionInFacing(BlockPos size, EnumFacing facing, BiConsumer<Point2i, boolean[][]> function) {
        Point2i flatSize;
        switch (facing.func_176740_k()) {
            case X: {
                flatSize = new Point2i(size.func_177952_p(), size.func_177956_o());
                break;
            }
            case Z: {
                flatSize = new Point2i(size.func_177958_n(), size.func_177956_o());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean[][] flatFillingPlan = new boolean[flatSize.x][flatSize.y];
        function.accept(flatSize, flatFillingPlan);
        switch (facing) {
            case WEST: {
                return Filling.generateFillingPlanByFunction(size, pos -> flatFillingPlan[pos.func_177952_p()][pos.func_177956_o()]);
            }
            case EAST: {
                return Filling.generateFillingPlanByFunction(size, pos -> flatFillingPlan[size.func_177952_p() - 1 - pos.func_177952_p()][pos.func_177956_o()]);
            }
            case NORTH: {
                return Filling.generateFillingPlanByFunction(size, pos -> flatFillingPlan[pos.func_177958_n()][pos.func_177956_o()]);
            }
            case SOUTH: {
                return Filling.generateFillingPlanByFunction(size, pos -> flatFillingPlan[size.func_177958_n() - 1 - pos.func_177958_n()][pos.func_177956_o()]);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean[][][] getFillingPlan(BlockPos size, List<IParameter> parameters) {
        EnumParameterPattern parameterPattern = (EnumParameterPattern)parameters.get(0);
        if (parameterPattern == EnumParameterPattern.STAIRS) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            EnumParameterFacing parameterFacing = (EnumParameterFacing)parameters.get(2);
            return FillingStairs.get(size, parameterType, parameterFacing);
        }
        if (parameterPattern == EnumParameterPattern.TRIANGLE) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            EnumParameterFacing parameterFacing = (EnumParameterFacing)parameters.get(2);
            return FillingTriangle.get(size, parameterType, parameterFacing);
        }
        if (parameterPattern == EnumParameterPattern.SQUARE) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            EnumParameterAxis parameterAxis = parameterType == EnumParameterType.HOLLOW ? (EnumParameterAxis)parameters.get(2) : null;
            return FillingSquare.get(size, parameterType, parameterAxis);
        }
        if (parameterPattern == EnumParameterPattern.PENTAGON) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            EnumParameterAxis parameterAxis = (EnumParameterAxis)parameters.get(2);
            return FillingPolygon.get(size, parameterType, parameterAxis, PENTAGON_POINTS);
        }
        if (parameterPattern == EnumParameterPattern.HEXAGON) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            EnumParameterAxis parameterAxis = (EnumParameterAxis)parameters.get(2);
            return FillingPolygon.get(size, parameterType, parameterAxis, HEXAGON_POINTS);
        }
        if (parameterPattern == EnumParameterPattern.OCTAGON) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            EnumParameterAxis parameterAxis = (EnumParameterAxis)parameters.get(2);
            return FillingPolygon.get(size, parameterType, parameterAxis, OCTAGON_POINTS);
        }
        if (parameterPattern == EnumParameterPattern.CIRCLE) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            EnumParameterAxis parameterAxis = (EnumParameterAxis)parameters.get(2);
            return FillingCircle.get(size, parameterType, parameterAxis);
        }
        if (parameterPattern == EnumParameterPattern.FRAME) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            return FillingFrame.get(size, parameterType);
        }
        if (parameterPattern == EnumParameterPattern.SPHERE) {
            EnumParameterType parameterType = (EnumParameterType)parameters.get(1);
            return FillingSphere.getSphere(size, parameterType);
        }
        return Filling.generateFillingPlanByFunction(size, pos -> false);
    }

    public static boolean[][][] invertFillingPlan(BlockPos size, boolean[][][] fillingPlan) {
        return Filling.generateFillingPlanByFunction(size, pos -> !fillingPlan[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()]);
    }

    static {
        StreamSupport.stream(Item.field_150901_e.spliterator(), false).filter(item -> item instanceof ItemBlock || item instanceof ItemBlockSpecial).forEach(xva$0 -> Filling.addItemBlock(xva$0));
        Filling.addItemBlock(Items.field_151104_aV, Items.field_179570_aq, Items.field_179569_ar, Items.field_179568_as, Items.field_179567_at, Items.field_179572_au, Items.field_179571_av, Items.field_151139_aw, Items.field_151144_bL, Items.field_151155_ap);
    }
}

