/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.container;

import buildcraft.builders.addon.AddonFillingPlanner;
import buildcraft.builders.container.IContainerFilling;
import buildcraft.builders.filling.IParameter;
import buildcraft.core.marker.volume.ClientVolumeBoxes;
import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.core.marker.volume.WorldSavedDataVolumeBoxes;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class ContainerFillingPlanner
extends ContainerBC_Neptune
implements IContainerFilling {
    private static final IdAllocator IDS = ContainerBC_Neptune.IDS.makeChild("filling_planner");
    private static final int ID_DATA = IDS.allocId("DATA");
    public AddonFillingPlanner addon;
    private List<IParameter> parameters = new ArrayList<IParameter>();
    private boolean inverted;

    public ContainerFillingPlanner(EntityPlayer player) {
        super(player);
        Pair<VolumeBox, EnumAddonSlot> selectingBoxAndSlot = player.field_70170_p.field_72995_K ? EnumAddonSlot.getSelectingBoxAndSlot(player, ClientVolumeBoxes.INSTANCE) : EnumAddonSlot.getSelectingBoxAndSlot(player, WorldSavedDataVolumeBoxes.get(player.field_70170_p));
        this.addon = (AddonFillingPlanner)((VolumeBox)selectingBoxAndSlot.getLeft()).addons.get(selectingBoxAndSlot.getRight());
        this.parameters.addAll(this.addon.parameters);
        this.inverted = this.addon.inverted;
    }

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    private void sendDataToServer() {
        this.sendMessage(ID_DATA, buffer -> {
            buffer.writeInt(this.parameters.size());
            this.parameters.forEach(parameter -> IParameter.toBytes((ByteBuf)buffer, parameter));
            buffer.writeBoolean(this.inverted);
        });
    }

    @Override
    public void readMessage(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readMessage(id, buffer, side, ctx);
        if (side == Side.SERVER && id == ID_DATA) {
            this.parameters.clear();
            IntStream.range(0, buffer.readInt()).mapToObj(i -> IParameter.fromBytes((ByteBuf)buffer)).forEach(this.parameters::add);
            this.inverted = buffer.readBoolean();
            this.addon.parameters.clear();
            this.addon.parameters.addAll(this.parameters);
            this.addon.inverted = this.inverted;
            this.addon.updateBuildingInfo();
            WorldSavedDataVolumeBoxes.get(this.player.field_70170_p).func_76185_a();
        }
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void setInverted(boolean value) {
        this.inverted = value;
        this.sendDataToServer();
    }

    @Override
    public List<IParameter> getParameters() {
        return ImmutableList.copyOf(this.parameters);
    }

    @Override
    public void setParameters(List<IParameter> value) {
        this.parameters.clear();
        this.parameters.addAll(value);
        this.sendDataToServer();
    }

    @Override
    public boolean isCanExcavate() {
        return true;
    }

    @Override
    public void setCanExcavate(boolean value) {
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }
}

