/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.addon;

import buildcraft.builders.BCBuildersGuis;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.builders.addon.AddonRendererFillingPlanner;
import buildcraft.builders.filling.Filling;
import buildcraft.builders.filling.IParameter;
import buildcraft.builders.snapshot.Template;
import buildcraft.core.marker.volume.Addon;
import buildcraft.core.marker.volume.AddonDefaultRenderer;
import buildcraft.core.marker.volume.IFastAddonRenderer;
import buildcraft.core.marker.volume.ISingleAddon;
import buildcraft.lib.misc.NBTUtilBC;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AddonFillingPlanner
extends Addon
implements ISingleAddon {
    public final List<IParameter> parameters = new ArrayList<IParameter>();
    public boolean inverted;
    public Template.BuildingInfo buildingInfo;

    public void updateBuildingInfo() {
        this.buildingInfo = Filling.createBuildingInfo(this.box.box.min(), this.box.box.size(), this.parameters, this.inverted);
    }

    @Override
    public void onBoxSizeChange() {
        this.updateBuildingInfo();
    }

    public IFastAddonRenderer<AddonFillingPlanner> getRenderer() {
        return new AddonDefaultRenderer<AddonFillingPlanner>(BCBuildersSprites.FILLING_PLANNER.getSprite()).then(new AddonRendererFillingPlanner());
    }

    @Override
    public void onAdded() {
        this.parameters.addAll(Filling.initParameters());
        this.updateBuildingInfo();
    }

    @Override
    public void onPlayerRightClick(EntityPlayer player) {
        BCBuildersGuis.FILLING_PLANNER.openGUI(player);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("parameters", (NBTBase)NBTUtilBC.writeCompoundList(this.parameters.stream().map(parameter -> IParameter.writeToNBT(new NBTTagCompound(), parameter))));
        nbt.func_74757_a("inverted", this.inverted);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTUtilBC.readCompoundList(nbt.func_74781_a("parameters")).map(IParameter::readFromNBT).forEach(this.parameters::add);
        this.inverted = nbt.func_74767_n("inverted");
        this.updateBuildingInfo();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.parameters.size());
        this.parameters.forEach(parameter -> IParameter.toBytes(buf, parameter));
        buf.writeBoolean(this.inverted);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.parameters.clear();
        IntStream.range(0, buf.readInt()).mapToObj(i -> IParameter.fromBytes(buf)).forEach(this.parameters::add);
        this.inverted = buf.readBoolean();
        this.updateBuildingInfo();
    }
}

