/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.schematics.SchematicBlockFactoryRegistry;
import buildcraft.api.schematics.SchematicEntityFactoryRegistry;
import buildcraft.builders.BCBuildersBlocks;
import buildcraft.builders.BCBuildersEventDist;
import buildcraft.builders.BCBuildersItems;
import buildcraft.builders.BCBuildersProxy;
import buildcraft.builders.BCBuildersRecipes;
import buildcraft.builders.BCBuildersRegistries;
import buildcraft.builders.addon.AddonFillingPlanner;
import buildcraft.builders.snapshot.GlobalSavedDataSnapshots;
import buildcraft.builders.snapshot.MessageSnapshotRequest;
import buildcraft.builders.snapshot.MessageSnapshotResponse;
import buildcraft.builders.snapshot.RulesLoader;
import buildcraft.builders.snapshot.SchematicBlockAir;
import buildcraft.builders.snapshot.SchematicBlockDefault;
import buildcraft.builders.snapshot.SchematicBlockFluid;
import buildcraft.builders.snapshot.SchematicEntityDefault;
import buildcraft.core.marker.volume.AddonsRegistry;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.registry.RegistryHelper;
import buildcraft.lib.registry.TagManager;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockVine;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="buildcraftbuilders", name="BuildCraft Builders", version="7.99.7", dependencies="required-after:buildcraftcore@[7.99.7]", acceptedMinecraftVersions="[1.11.2]")
public class BCBuilders {
    public static final String MODID = "buildcraftbuilders";
    @Mod.Instance(value="buildcraftbuilders")
    public static BCBuilders INSTANCE = null;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) {
        RegistryHelper.useOtherModConfigFor(MODID, "buildcraftcore");
        BCBuildersRegistries.preInit();
        BCBuildersItems.preInit();
        BCBuildersBlocks.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)BCBuildersProxy.getProxy());
        AddonsRegistry.INSTANCE.register(new ResourceLocation(MODID, "filling_planner"), AddonFillingPlanner.class);
        SchematicBlockFactoryRegistry.registerFactory("air", 0, SchematicBlockAir::predicate, SchematicBlockAir::new);
        SchematicBlockFactoryRegistry.registerFactory("default", 100, SchematicBlockDefault::predicate, SchematicBlockDefault::new);
        SchematicBlockFactoryRegistry.registerFactory("fluid", 200, SchematicBlockFluid::predicate, SchematicBlockFluid::new);
        SchematicBlockFactoryRegistry.registerFactory("banner", 300, context -> context.block instanceof BlockBanner, new Supplier<SchematicBlockDefault>(){

            @Override
            public SchematicBlockDefault get() {
                return new SchematicBlockDefault(){

                    @Override
                    @Nonnull
                    public List<ItemStack> computeRequiredItems() {
                        return Collections.singletonList(ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.func_176766_a((int)this.tileNbt.func_74762_e("Base")), (NBTTagList)this.tileNbt.func_150295_c("Patterns", 10)));
                    }
                };
            }
        });
        SchematicBlockFactoryRegistry.registerFactory("vine", 300, context -> context.block instanceof BlockVine, new Supplier<SchematicBlockDefault>(){

            @Override
            public SchematicBlockDefault get() {
                return new SchematicBlockDefault(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public boolean isReadyToBuild(World world, BlockPos blockPos) {
                        if (!super.isReadyToBuild(world, blockPos)) return false;
                        if (world.func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof BlockVine) return true;
                        if (!StreamSupport.stream(EnumFacing.Plane.HORIZONTAL.spliterator(), false).map(arg_0 -> ((BlockPos)blockPos).func_177972_a(arg_0)).map(arg_0 -> ((World)world).func_180495_p(arg_0)).anyMatch(state -> state.func_185917_h() && state.func_185904_a().func_76230_c())) return false;
                        return true;
                    }
                };
            }
        });
        SchematicEntityFactoryRegistry.registerFactory("default", 100, SchematicEntityDefault::predicate, SchematicEntityDefault::new);
        BCBuildersProxy.getProxy().fmlPreInit();
        MinecraftForge.EVENT_BUS.register((Object)BCBuildersEventDist.INSTANCE);
        MessageManager.addMessageType(MessageSnapshotRequest.class, MessageSnapshotRequest.HANDLER, Side.SERVER);
        MessageManager.addMessageType(MessageSnapshotResponse.class, MessageSnapshotResponse.HANDLER, Side.CLIENT);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        BCBuildersProxy.getProxy().fmlInit();
        BCBuildersRegistries.init();
        BCBuildersRecipes.init();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        RulesLoader.loadAll();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        GlobalSavedDataSnapshots.reInit(Side.SERVER);
    }

    private static TagManager.TagEntry registerTag(String id) {
        return TagManager.registerTag(id);
    }

    private static void startBatch() {
        TagManager.startBatch();
    }

    private static void endBatch(Consumer<TagManager.TagEntry> consumer) {
        TagManager.endBatch(consumer);
    }

    static {
        BCBuilders.startBatch();
        BCBuilders.registerTag("item.schematic.single").reg("schematic_single").locale("schematicSingle").model("schematic_single/");
        BCBuilders.registerTag("item.snapshot").reg("snapshot").locale("snapshot").model("snapshot/");
        BCBuilders.registerTag("item.filling_planner").reg("filling_planner").locale("fillingPlannerItem").model("filling_planner");
        BCBuilders.registerTag("item.block.architect").reg("architect").locale("architectBlock").model("architect");
        BCBuilders.registerTag("item.block.builder").reg("builder").locale("builderBlock").model("builder");
        BCBuilders.registerTag("item.block.filler").reg("filler").locale("fillerBlock").model("filler");
        BCBuilders.registerTag("item.block.library").reg("library").locale("libraryBlock").model("library");
        BCBuilders.registerTag("item.block.replacer").reg("replacer").locale("replacerBlock").model("replacer");
        BCBuilders.registerTag("item.block.frame").reg("frame").locale("frameBlock").model("frame");
        BCBuilders.registerTag("item.block.quarry").reg("quarry").locale("quarryBlock").model("quarry");
        BCBuilders.registerTag("block.architect").reg("architect").locale("architectBlock").model("architect");
        BCBuilders.registerTag("block.builder").reg("builder").locale("builderBlock").model("builder");
        BCBuilders.registerTag("block.filler").reg("filler").locale("fillerBlock").model("filler");
        BCBuilders.registerTag("block.library").reg("library").locale("libraryBlock").model("library");
        BCBuilders.registerTag("block.replacer").reg("replacer").locale("replacerBlock").model("replacer");
        BCBuilders.registerTag("block.frame").reg("frame").locale("frameBlock").model("frame");
        BCBuilders.registerTag("block.quarry").reg("quarry").locale("quarryBlock").model("quarry");
        BCBuilders.registerTag("tile.architect").reg("architect");
        BCBuilders.registerTag("tile.builder").reg("builder");
        BCBuilders.registerTag("tile.library").reg("library");
        BCBuilders.registerTag("tile.replacer").reg("replacer");
        BCBuilders.registerTag("tile.filler").reg("filler");
        BCBuilders.registerTag("tile.quarry").reg("quarry");
        BCBuilders.endBatch(TagManager.prependTags("buildcraftbuilders:", TagManager.EnumTagType.REGISTRY_NAME, TagManager.EnumTagType.MODEL_LOCATION).andThen(TagManager.setTab("buildcraft.main")));
    }
}

