/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pluggable;

import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public final class PluggableDefinition {
    public final ResourceLocation identifier;
    public final IPluggableNetLoader loader;
    public final IPluggableNbtReader reader;
    @Nullable
    public final IPluggableCreator creator;

    public PluggableDefinition(ResourceLocation identifier, IPluggableNbtReader reader, IPluggableNetLoader loader) {
        this.identifier = identifier;
        this.reader = reader;
        this.loader = loader;
        this.creator = null;
    }

    public PluggableDefinition(ResourceLocation identifier, @Nullable IPluggableCreator creator) {
        this.identifier = identifier;
        this.reader = creator;
        this.loader = creator;
        this.creator = creator;
    }

    public PipePluggable readFromNbt(IPipeHolder holder, EnumFacing side, NBTTagCompound nbt) {
        return this.reader.readFromNbt(this, holder, side, nbt);
    }

    public PipePluggable loadFromBuffer(IPipeHolder holder, EnumFacing side, PacketBuffer buffer) {
        return this.loader.loadFromBuffer(this, holder, side, buffer);
    }

    @FunctionalInterface
    public static interface IPluggableCreator
    extends IPluggableNbtReader,
    IPluggableNetLoader {
        @Override
        default public PipePluggable loadFromBuffer(PluggableDefinition definition, IPipeHolder holder, EnumFacing side, PacketBuffer buffer) {
            return this.createSimplePluggable(definition, holder, side);
        }

        @Override
        default public PipePluggable readFromNbt(PluggableDefinition definition, IPipeHolder holder, EnumFacing side, NBTTagCompound nbt) {
            return this.createSimplePluggable(definition, holder, side);
        }

        public PipePluggable createSimplePluggable(PluggableDefinition var1, IPipeHolder var2, EnumFacing var3);
    }

    @FunctionalInterface
    public static interface IPluggableNetLoader {
        public PipePluggable loadFromBuffer(PluggableDefinition var1, IPipeHolder var2, EnumFacing var3, PacketBuffer var4);
    }

    @FunctionalInterface
    public static interface IPluggableNbtReader {
        public PipePluggable readFromNbt(PluggableDefinition var1, IPipeHolder var2, EnumFacing var3, NBTTagCompound var4);
    }
}

