/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeFlowType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public final class PipeDefinition {
    public final ResourceLocation identifier;
    public final IPipeCreator logicConstructor;
    public final IPipeLoader logicLoader;
    public final PipeFlowType flowType;
    public final String[] textures;
    public final int itemTextureTop;
    public final int itemTextureCenter;
    public final int itemTextureBottom;

    public PipeDefinition(PipeDefinitionBuilder builder) {
        this.identifier = builder.identifier;
        this.textures = new String[builder.textureSuffixes.length];
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = builder.texturePrefix + builder.textureSuffixes[i];
        }
        this.logicConstructor = builder.logicConstructor;
        this.logicLoader = builder.logicLoader;
        this.flowType = builder.flowType;
        this.itemTextureTop = builder.itemTextureTop;
        this.itemTextureCenter = builder.itemTextureCenter;
        this.itemTextureBottom = builder.itemTextureBottom;
    }

    public static class PipeDefinitionBuilder {
        public ResourceLocation identifier;
        public String texturePrefix;
        public String[] textureSuffixes = new String[]{""};
        public IPipeCreator logicConstructor;
        public IPipeLoader logicLoader;
        public PipeFlowType flowType;
        public int itemTextureTop = 0;
        public int itemTextureCenter = 0;
        public int itemTextureBottom = 0;

        public PipeDefinitionBuilder() {
        }

        public PipeDefinitionBuilder(ResourceLocation identifier, IPipeCreator logicConstructor, IPipeLoader logicLoader, PipeFlowType flowType) {
            this.identifier = identifier;
            this.logicConstructor = logicConstructor;
            this.logicLoader = logicLoader;
            this.flowType = flowType;
        }

        public PipeDefinitionBuilder idTexPrefix(String both) {
            return this.id(both).texPrefix(both);
        }

        public PipeDefinitionBuilder idTex(String both) {
            return this.id(both).tex(both, new String[0]);
        }

        private static String getActiveModId() {
            ModContainer mod = Loader.instance().activeModContainer();
            if (mod == null) {
                throw new IllegalStateException("Cannot interact with PipeDefinition outside of an actively scoped mod!");
            }
            return mod.getModId();
        }

        public PipeDefinitionBuilder id(String post) {
            this.identifier = new ResourceLocation(PipeDefinitionBuilder.getActiveModId(), post);
            return this;
        }

        public PipeDefinitionBuilder tex(String prefix, String ... suffixes) {
            return this.texPrefix(prefix).texSuffixes(suffixes);
        }

        public PipeDefinitionBuilder texPrefix(String prefix) {
            return this.texPrefixDirect(PipeDefinitionBuilder.getActiveModId() + ":pipes/" + prefix);
        }

        public PipeDefinitionBuilder texPrefixDirect(String prefix) {
            this.texturePrefix = prefix;
            return this;
        }

        public PipeDefinitionBuilder texSuffixes(String ... suffixes) {
            this.textureSuffixes = suffixes == null || suffixes.length == 0 ? new String[]{""} : suffixes;
            return this;
        }

        public PipeDefinitionBuilder itemTex(int all) {
            this.itemTextureTop = all;
            this.itemTextureCenter = all;
            this.itemTextureBottom = all;
            return this;
        }

        public PipeDefinitionBuilder itemTex(int top, int center, int bottom) {
            this.itemTextureTop = top;
            this.itemTextureCenter = center;
            this.itemTextureBottom = bottom;
            return this;
        }

        public PipeDefinitionBuilder logic(IPipeCreator creator, IPipeLoader loader) {
            this.logicConstructor = creator;
            this.logicLoader = loader;
            return this;
        }

        public PipeDefinitionBuilder flowItem() {
            return this.flow(PipeApi.flowItems);
        }

        public PipeDefinitionBuilder flowFluid() {
            return this.flow(PipeApi.flowFluids);
        }

        public PipeDefinitionBuilder flowPower() {
            return this.flow(PipeApi.flowPower);
        }

        public PipeDefinitionBuilder flow(PipeFlowType flow) {
            this.flowType = flow;
            return this;
        }

        public PipeDefinition define() {
            PipeDefinition def = new PipeDefinition(this);
            PipeApi.pipeRegistry.registerPipe(def);
            return def;
        }
    }

    @FunctionalInterface
    public static interface IPipeLoader {
        public PipeBehaviour loadBehaviour(IPipe var1, NBTTagCompound var2);
    }

    @FunctionalInterface
    public static interface IPipeCreator {
        public PipeBehaviour createBehaviour(IPipe var1);
    }
}

