/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.core.CapabilitiesHelper;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IStripesRegistry;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.IPipeRegistry;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeFlowType;
import buildcraft.api.transport.pluggable.IPluggableRegistry;
import buildcraft.api.transport.pluggable.PipePluggable;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public final class PipeApi {
    public static IPipeRegistry pipeRegistry;
    public static IPluggableRegistry pluggableRegistry;
    public static IStripesRegistry stripeRegistry;
    public static PipeFlowType flowStructure;
    public static PipeFlowType flowItems;
    public static PipeFlowType flowFluids;
    public static PipeFlowType flowPower;
    public static FluidTransferInfo fluidInfoDefault;
    public static PowerTransferInfo powerInfoDefault;
    public static final Map<PipeDefinition, FluidTransferInfo> fluidTransferData;
    public static final Map<PipeDefinition, PowerTransferInfo> powerTransferData;
    @Nonnull
    public static final Capability<IPipeHolder> CAP_PIPE_HOLDER;
    @Nonnull
    public static final Capability<IPipe> CAP_PIPE;
    @Nonnull
    public static final Capability<PipePluggable> CAP_PLUG;
    @Nonnull
    public static final Capability<IInjectable> CAP_INJECTABLE;
    @CapabilityInject(value=IPipeHolder.class)
    private static Capability<IPipeHolder> capPipeHolder;
    @CapabilityInject(value=IPipe.class)
    private static Capability<IPipe> capPipe;
    @CapabilityInject(value=PipePluggable.class)
    private static Capability<PipePluggable> capPlug;
    @CapabilityInject(value=IInjectable.class)
    private static Capability<IInjectable> capInjectable;

    public static FluidTransferInfo getFluidTransferInfo(PipeDefinition def) {
        FluidTransferInfo info = fluidTransferData.get(def);
        if (info == null) {
            return fluidInfoDefault;
        }
        return info;
    }

    public static PowerTransferInfo getPowerTransferInfo(PipeDefinition def) {
        PowerTransferInfo info = powerTransferData.get(def);
        if (info == null) {
            return powerInfoDefault;
        }
        return info;
    }

    static {
        fluidInfoDefault = new FluidTransferInfo(20, 10);
        powerInfoDefault = PowerTransferInfo.createFromResistance(8000000L, 31250L, false);
        fluidTransferData = new IdentityHashMap<PipeDefinition, FluidTransferInfo>();
        powerTransferData = new IdentityHashMap<PipeDefinition, PowerTransferInfo>();
        CapabilitiesHelper.registerCapability(IPipe.class);
        CapabilitiesHelper.registerCapability(IPipeHolder.class);
        CapabilitiesHelper.registerCapability(IInjectable.class);
        CapabilitiesHelper.registerCapability(PipePluggable.class);
        CAP_PIPE = CapabilitiesHelper.ensureRegistration(capPipe, IPipe.class);
        CAP_PLUG = CapabilitiesHelper.ensureRegistration(capPlug, PipePluggable.class);
        CAP_PIPE_HOLDER = CapabilitiesHelper.ensureRegistration(capPipeHolder, IPipeHolder.class);
        CAP_INJECTABLE = CapabilitiesHelper.ensureRegistration(capInjectable, IInjectable.class);
    }

    public static class PowerTransferInfo {
        public final long transferPerTick;
        public final long lossPerTick;
        public final long resistancePerTick;
        public final boolean isReceiver;

        public static PowerTransferInfo createFromLoss(long transferPerTick, long lossPerTick, boolean isReceiver) {
            return new PowerTransferInfo(transferPerTick, lossPerTick, lossPerTick * 1000000L / transferPerTick, isReceiver);
        }

        public static PowerTransferInfo createFromResistance(long transferPerTick, long resistancePerTick, boolean isReceiver) {
            return new PowerTransferInfo(transferPerTick, resistancePerTick, resistancePerTick * transferPerTick / 1000000L, isReceiver);
        }

        public PowerTransferInfo(long transferPerTick, long lossPerTick, long resistancePerTick, boolean isReceiver) {
            if (transferPerTick < 10L) {
                transferPerTick = 10L;
            }
            this.transferPerTick = transferPerTick;
            this.lossPerTick = lossPerTick;
            this.resistancePerTick = resistancePerTick;
            this.isReceiver = isReceiver;
        }
    }

    public static class FluidTransferInfo {
        public final int transferPerTick;
        public final double transferDelayMultiplier;

        public FluidTransferInfo(int transferPerTick, int transferDelay) {
            this.transferPerTick = transferPerTick;
            if (transferDelay <= 0) {
                transferDelay = 1;
            }
            this.transferDelayMultiplier = transferDelay;
        }
    }
}

