/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StatementParameterItemStack
implements IStatementParameter {
    @Nonnull
    private static final ItemStack EMPTY_STACK;
    @Nonnull
    protected ItemStack stack = EMPTY_STACK;

    @Override
    public TextureAtlasSprite getGuiSprite() {
        return null;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public boolean onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        if (stack != null) {
            this.stack = stack.func_77946_l();
            this.stack.func_190920_e(1);
        } else {
            this.stack = EMPTY_STACK;
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        if (!this.stack.func_190926_b()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.stack.func_77955_b(tagCompound);
            compound.func_74782_a("stack", (NBTBase)tagCompound);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        ItemStack read = new ItemStack(compound.func_74775_l("stack"));
        this.stack = read.func_190926_b() ? EMPTY_STACK : read;
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterItemStack) {
            StatementParameterItemStack param = (StatementParameterItemStack)object;
            return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)param.stack) && ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)param.stack);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.stack);
    }

    @Override
    public String getDescription() {
        if (this.stack.func_190926_b()) {
            return "";
        }
        return this.stack.func_82833_r();
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:stack";
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source, IStatement stmt) {
        return null;
    }

    static {
        ItemStack stack = ItemStack.field_190927_a;
        if (stack == null) {
            throw new Error("Somehow ItemStack.EMPTY was null!");
        }
        EMPTY_STACK = stack;
    }
}

