/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.recipes;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.recipes.StackDefinition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public final class IntegrationRecipe {
    public final ResourceLocation name;
    public final long requiredMicroJoules;
    public final StackDefinition target;
    public final ImmutableList<StackDefinition> toIntegrate;
    @Nonnull
    public final ItemStack output;
    @Nullable
    public final NBTTagCompound recipeTag;

    public IntegrationRecipe(ResourceLocation name, long requiredMicroJoules, StackDefinition target, List<StackDefinition> toIntegrate, @Nonnull ItemStack output, @Nullable NBTTagCompound recipeTag) {
        this.name = name;
        this.requiredMicroJoules = requiredMicroJoules;
        this.target = target;
        this.toIntegrate = ImmutableList.copyOf(toIntegrate);
        this.output = output;
        this.recipeTag = recipeTag;
    }

    public IntegrationRecipe(String name, long requiredMicroJoules, StackDefinition target, List<StackDefinition> toIntegrate, @Nonnull ItemStack output, @Nullable NBTTagCompound recipeTag) {
        this(BuildCraftAPI.nameToResourceLocation(name), requiredMicroJoules, target, toIntegrate, output, recipeTag);
    }

    public IntegrationRecipe(ResourceLocation name, long requiredMicroJoules, StackDefinition target, List<StackDefinition> toIntegrate, @Nonnull ItemStack output) {
        this(name, requiredMicroJoules, target, toIntegrate, output, null);
    }

    public IntegrationRecipe(String name, long requiredMicroJoules, StackDefinition target, List<StackDefinition> toIntegrate, @Nonnull ItemStack output) {
        this(name, requiredMicroJoules, target, toIntegrate, output, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationRecipe that = (IntegrationRecipe)o;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

