/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.recipes;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.recipes.StackDefinition;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public final class AssemblyRecipe
implements Comparable<AssemblyRecipe> {
    public final ResourceLocation name;
    public final long requiredMicroJoules;
    public final ImmutableSet<StackDefinition> requiredStacks;
    @Nonnull
    public final ItemStack output;
    @Nullable
    public final NBTTagCompound recipeTag;

    public AssemblyRecipe(ResourceLocation name, long requiredMicroJoules, Set<StackDefinition> requiredStacks, @Nonnull ItemStack output, @Nullable NBTTagCompound recipeTag) {
        this.name = name;
        this.requiredMicroJoules = requiredMicroJoules;
        this.requiredStacks = ImmutableSet.copyOf(requiredStacks);
        this.output = output;
        this.recipeTag = recipeTag;
    }

    public AssemblyRecipe(String name, long requiredMicroJoules, Set<StackDefinition> requiredStacks, @Nonnull ItemStack output, @Nullable NBTTagCompound recipeTag) {
        this(BuildCraftAPI.nameToResourceLocation(name), requiredMicroJoules, requiredStacks, output, recipeTag);
    }

    public AssemblyRecipe(ResourceLocation name, long requiredMicroJoules, Set<StackDefinition> requiredStacks, @Nonnull ItemStack output) {
        this(name, requiredMicroJoules, requiredStacks, output, null);
    }

    public AssemblyRecipe(String name, long requiredMicroJoules, Set<StackDefinition> requiredStacks, @Nonnull ItemStack output) {
        this(name, requiredMicroJoules, requiredStacks, output, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssemblyRecipe that = (AssemblyRecipe)o;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(AssemblyRecipe o) {
        return this.name.toString().compareTo(o.name.toString());
    }
}

