/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.core.CapabilitiesHelper;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjEffectManager;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.IMjRedstoneReceiver;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class MjAPI {
    public static final long ONE_MINECRAFT_JOULE = 1000000L;
    public static final long MJ = 1000000L;
    public static final DecimalFormat MJ_DISPLAY_FORMAT = new DecimalFormat("#,##0.##");
    public static IMjEffectManager EFFECT_MANAGER = NullaryEffectManager.INSTANCE;
    @Nonnull
    public static final Capability<IMjConnector> CAP_CONNECTOR;
    @Nonnull
    public static final Capability<IMjReceiver> CAP_RECEIVER;
    @Nonnull
    public static final Capability<IMjRedstoneReceiver> CAP_REDSTONE_RECEIVER;
    @Nonnull
    public static final Capability<IMjReadable> CAP_READABLE;
    @Nonnull
    public static final Capability<IMjPassiveProvider> CAP_PASSIVE_PROVIDER;
    @CapabilityInject(value=IMjConnector.class)
    private static final Capability<IMjConnector> CAP_CONNECTOR_FIRST;
    @CapabilityInject(value=IMjReceiver.class)
    private static final Capability<IMjReceiver> CAP_RECEIVER_FIRST;
    @CapabilityInject(value=IMjRedstoneReceiver.class)
    private static final Capability<IMjRedstoneReceiver> CAP_REDSTONE_RECEIVER_FIRST;
    @CapabilityInject(value=IMjReadable.class)
    private static final Capability<IMjReadable> CAP_READABLE_FIRST;
    @CapabilityInject(value=IMjPassiveProvider.class)
    private static final Capability<IMjPassiveProvider> CAP_PASSIVE_PROVIDER_FIRST;

    public static String formatMj(long microMj) {
        return MjAPI.formatMjInternal((double)microMj / 1000000.0);
    }

    private static String formatMjInternal(double val) {
        return MJ_DISPLAY_FORMAT.format(val);
    }

    static {
        CAP_CONNECTOR_FIRST = null;
        CAP_RECEIVER_FIRST = null;
        CAP_REDSTONE_RECEIVER_FIRST = null;
        CAP_READABLE_FIRST = null;
        CAP_PASSIVE_PROVIDER_FIRST = null;
        CapabilitiesHelper.registerCapability(IMjConnector.class);
        CapabilitiesHelper.registerCapability(IMjReceiver.class);
        CapabilitiesHelper.registerCapability(IMjRedstoneReceiver.class);
        CapabilitiesHelper.registerCapability(IMjReadable.class);
        CapabilitiesHelper.registerCapability(IMjPassiveProvider.class);
        CAP_CONNECTOR = CapabilitiesHelper.ensureRegistration(CAP_CONNECTOR_FIRST, IMjConnector.class);
        CAP_RECEIVER = CapabilitiesHelper.ensureRegistration(CAP_RECEIVER_FIRST, IMjReceiver.class);
        CAP_REDSTONE_RECEIVER = CapabilitiesHelper.ensureRegistration(CAP_REDSTONE_RECEIVER_FIRST, IMjRedstoneReceiver.class);
        CAP_READABLE = CapabilitiesHelper.ensureRegistration(CAP_READABLE_FIRST, IMjReadable.class);
        CAP_PASSIVE_PROVIDER = CapabilitiesHelper.ensureRegistration(CAP_PASSIVE_PROVIDER_FIRST, IMjPassiveProvider.class);
    }

    public static enum NullaryEffectManager implements IMjEffectManager
    {
        INSTANCE;


        @Override
        public void createPowerLossEffect(World world, Vec3d center, long microJoulesLost) {
        }

        @Override
        public void createPowerLossEffect(World world, Vec3d center, EnumFacing direction, long microJoulesLost) {
        }

        @Override
        public void createPowerLossEffect(World world, Vec3d center, Vec3d direction, long microJoulesLost) {
        }
    }
}

