/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import buildcraft.api.core.BCLog;
import java.util.Locale;
import net.minecraft.world.World;

public class BCDebugging {
    private static final DebugStatus DEBUG_STATUS;

    public static boolean shouldDebugComplex(String string) {
        return BCDebugging.shouldDebug(string, DebugLevel.COMPLEX);
    }

    public static boolean shouldDebugLog(String string) {
        return BCDebugging.shouldDebug(string, DebugLevel.LOG);
    }

    private static boolean shouldDebug(String option, DebugLevel type) {
        String prop = BCDebugging.getProp(option);
        String actual = System.getProperty(prop);
        if ("false".equals(actual)) {
            BCLog.logger.info("[debugger] Debugging manually disabled for \"" + option + "\" (" + (Object)((Object)type) + ").");
            return false;
        }
        if ("true".equals(actual)) {
            BCLog.logger.info("[debugger] Debugging enabled for \"" + option + "\" (" + (Object)((Object)type) + ").");
            return true;
        }
        if (type.isAllOn) {
            BCLog.logger.info("[debugger] Debugging automatically enabled for \"" + option + "\" (" + (Object)((Object)type) + ").");
            return true;
        }
        if ("complex".equals(actual) || type.name.equals(actual)) {
            BCLog.logger.info("[debugger] Debugging enabled for \"" + option + "\" (" + (Object)((Object)type) + ").");
            return true;
        }
        StringBuilder log = new StringBuilder();
        log.append("[debugger] To enable debugging for ");
        log.append(option);
        log.append(" add the option \"-D");
        log.append(prop);
        log.append("=true\" to your launch config as a VM argument (").append((Object)type).append(").");
        BCLog.logger.info((Object)log);
        return false;
    }

    private static String getProp(String string) {
        return "buildcraft." + string + ".debug";
    }

    static {
        String value = System.getProperty("buildcraft.debug");
        DEBUG_STATUS = "enable".equals(value) ? DebugStatus.ENABLE : ("all".equals(value) ? DebugStatus.ALL : ("disable".equals(value) ? DebugStatus.NONE : ("log".equals(value) ? DebugStatus.LOGGING_ONLY : (World.class.getName().contains("World") ? DebugStatus.ENABLE : DebugStatus.NONE))));
        if (DEBUG_STATUS == DebugStatus.ALL) {
            BCLog.logger.info("[debugger] Debugging automatically enabled for ALL of buildcraft. Prepare for log spam.");
        } else if (DEBUG_STATUS == DebugStatus.LOGGING_ONLY) {
            BCLog.logger.info("[debugger] Debugging automatically enabled for some non-spammy parts of buildcraft.");
        } else if (DEBUG_STATUS == DebugStatus.ENABLE) {
            BCLog.logger.info("[debugger] Debugging not automatically enabled for all of buildcraft. Logging all possible debug options.");
            BCLog.logger.info("              To enable it for only logging messages add \"-Dbuildcraft.debug=log\" to your launch VM arguments");
            BCLog.logger.info("              To enable it for ALL debugging \"-Dbuildcraft.debug=all\" to your launch VM arguments");
            BCLog.logger.info("              To remove this message and all future ones add \"-Dbuildcraft.debug=disable\" to your launch VM arguments");
        }
        DebugLevel.COMPLEX.isAllOn = DEBUG_STATUS == DebugStatus.ALL;
        DebugLevel.LOG.isAllOn = DEBUG_STATUS == DebugStatus.ALL || DEBUG_STATUS == DebugStatus.LOGGING_ONLY;
    }

    static enum DebugLevel {
        LOG,
        COMPLEX;

        final String name = this.name().toLowerCase(Locale.ROOT);
        boolean isAllOn;
    }

    public static enum DebugStatus {
        NONE,
        ENABLE,
        LOGGING_ONLY,
        ALL;

    }
}

