/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.core.BCLog;
import java.util.Locale;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public enum BCModules {
    LIB,
    CORE,
    BUILDERS,
    ENERGY,
    FACTORY,
    ROBOTICS,
    SILICON,
    TRANSPORT,
    COMPAT;

    public static final BCModules[] VALUES;
    private static final String MODID_START = "buildcraft";
    private final String modid;
    private final String part = this.name().toLowerCase(Locale.ROOT);

    private BCModules() {
        this.modid = MODID_START + this.part;
    }

    public static void fmlPreInit() {
    }

    public static boolean isBcMod(String modid) {
        if (!modid.startsWith(MODID_START)) {
            return false;
        }
        String post = modid.substring(MODID_START.length());
        for (BCModules module : VALUES) {
            if (!post.equals(module.part)) continue;
            return true;
        }
        return false;
    }

    public boolean isLoaded() {
        return Loader.isModLoaded((String)this.modid);
    }

    public String getModId() {
        return this.modid;
    }

    static {
        VALUES = BCModules.values();
        if (!Loader.instance().hasReachedState(LoaderState.CONSTRUCTING)) {
            throw new RuntimeException("Accessed BC modules too early! You can only use them from construction onwards!");
        }
        for (BCModules module : BCModules.values()) {
            if (module.isLoaded()) {
                BCLog.logger.info("[api.modules] Module " + module.name().toLowerCase(Locale.ROOT) + " is loaded!");
                continue;
            }
            BCLog.logger.warn("[api.modules] Module " + module.name().toLowerCase(Locale.ROOT) + " is NOT loaded!");
        }
    }
}

