/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class BCItems {
    private static final boolean DEBUG = BCDebugging.shouldDebugLog("api.items");
    public static final Item LIB_GUIDE;
    public static final Item LIB_DEBUGGER;
    public static final Item CORE_WRENCH;
    public static final Item CORE_DIAMOND_SHARD;
    public static final Item CORE_LIST;
    public static final Item CORE_MAP_LOCATION;
    public static final Item CORE_PAINTBRUSH;
    public static final Item CORE_GEAR_WOOD;
    public static final Item CORE_GEAR_STONE;
    public static final Item CORE_GEAR_IRON;
    public static final Item CORE_GEAR_GOLD;
    public static final Item CORE_GEAR_DIAMOND;
    public static final Item CORE_MARKER_CONNECTOR;
    public static final Item CORE_GOGGLES;
    public static final Item BUILDERS_SINGLE_SCHEMATIC;
    public static final Item BUILDERS_SNAPSHOT;
    public static final Item ENERGY_GLOB_OF_OIL;
    public static final Item FACTORY_PLASTIC_SHEET;
    public static final Item ROBOTICS_REDSTONE_BOARD;
    public static final Item ROBOTICS_ROBOT;
    public static final Item ROBOTICS_ROBOT_GOGGLES;
    public static final Item ROBOTICS_PLUGGABLE_ROBOT_STATION;
    public static final Item SILICON_REDSTONE_CHIPSET;
    public static final Item TRANSPORT_WATERPROOF;
    public static final Item TRANSPORT_GATE_COPIER;
    public static final Item TRANSPORT_PLUGGABLE_GATE;
    public static final Item TRANSPORT_PLUGGABLE_WIRE;
    public static final Item TRANSPORT_PLUGGABLE_BLOCKER;
    public static final Item TRANSPORT_PLUGGABLE_LENS;
    public static final Item TRANSPORT_PLUGGABLE_POWER_ADAPTOR;
    public static final Item TRANSPORT_PLUGGABLE_FACADE;
    public static final Item TRANSPORT_PIPE_WOOD_ITEM;
    public static final Item TRANSPORT_PIPE_WOOD_FLUID;
    public static final Item TRANSPORT_PIPE_WOOD_POWER;
    public static final Item TRANSPORT_PIPE_DIAMOND_ITEM;
    private static final Set<String> SCANNED;

    private static Item getRegisteredItem(String module, String regName) {
        String modid = "buildcraft" + module;
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, regName));
        if (item != null) {
            if (DEBUG) {
                BCLog.logger.info("[api.items] Found the item " + regName + " from the module " + module);
                SCANNED.add(modid + ":" + regName);
            }
            return item;
        }
        if (DEBUG) {
            if (Loader.isModLoaded((String)modid)) {
                BCLog.logger.info("[api.items] Did not find the item " + regName + " despite the appropriate mod being loaded (" + modid + ")");
            } else {
                BCLog.logger.info("[api.items] Did not find the item " + regName + " probably because the mod is not loaded (" + modid + ")");
            }
        }
        return null;
    }

    static {
        HashSet hashSet = SCANNED = DEBUG ? new HashSet() : null;
        if (!Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new RuntimeException("Accessed BC items too early! You can only use them from init onwards!");
        }
        String lib = "lib";
        LIB_GUIDE = BCItems.getRegisteredItem("lib", "guide");
        LIB_DEBUGGER = BCItems.getRegisteredItem("lib", "debugger");
        String core = "core";
        CORE_WRENCH = BCItems.getRegisteredItem("core", "wrench");
        CORE_DIAMOND_SHARD = BCItems.getRegisteredItem("core", "diamond_shard");
        CORE_LIST = BCItems.getRegisteredItem("core", "list");
        CORE_MAP_LOCATION = BCItems.getRegisteredItem("core", "map_location");
        CORE_PAINTBRUSH = BCItems.getRegisteredItem("core", "paintbrush");
        CORE_GEAR_WOOD = BCItems.getRegisteredItem("core", "gear_wood");
        CORE_GEAR_STONE = BCItems.getRegisteredItem("core", "gear_stone");
        CORE_GEAR_IRON = BCItems.getRegisteredItem("core", "gear_iron");
        CORE_GEAR_GOLD = BCItems.getRegisteredItem("core", "gear_gold");
        CORE_GEAR_DIAMOND = BCItems.getRegisteredItem("core", "gear_diamond");
        CORE_MARKER_CONNECTOR = BCItems.getRegisteredItem("core", "marker_connector");
        CORE_GOGGLES = BCItems.getRegisteredItem("core", "goggles");
        String builders = "builders";
        BUILDERS_SINGLE_SCHEMATIC = BCItems.getRegisteredItem("builders", "single_schematic");
        BUILDERS_SNAPSHOT = BCItems.getRegisteredItem("builders", "snapshot");
        String energy = "energy";
        ENERGY_GLOB_OF_OIL = BCItems.getRegisteredItem("energy", "glob_oil");
        String factory = "factory";
        FACTORY_PLASTIC_SHEET = BCItems.getRegisteredItem("factory", "plastic_sheet");
        String robotics = "robotics";
        ROBOTICS_REDSTONE_BOARD = BCItems.getRegisteredItem("robotics", "redstone_board");
        ROBOTICS_ROBOT = BCItems.getRegisteredItem("robotics", "robot");
        ROBOTICS_PLUGGABLE_ROBOT_STATION = BCItems.getRegisteredItem("robotics", "robot_station");
        ROBOTICS_ROBOT_GOGGLES = BCItems.getRegisteredItem("robotics", "robot_goggles");
        String silicon = "silicon";
        SILICON_REDSTONE_CHIPSET = BCItems.getRegisteredItem("silicon", "redstone_chipset");
        String transport = "transport";
        TRANSPORT_WATERPROOF = BCItems.getRegisteredItem("transport", "waterproof");
        TRANSPORT_GATE_COPIER = BCItems.getRegisteredItem("transport", "gate_copier");
        TRANSPORT_PLUGGABLE_GATE = BCItems.getRegisteredItem("transport", "plug_gate");
        TRANSPORT_PLUGGABLE_WIRE = BCItems.getRegisteredItem("transport", "plug_wire");
        TRANSPORT_PLUGGABLE_BLOCKER = BCItems.getRegisteredItem("transport", "plug_blocker");
        TRANSPORT_PLUGGABLE_LENS = BCItems.getRegisteredItem("transport", "plug_lens");
        TRANSPORT_PLUGGABLE_FACADE = BCItems.getRegisteredItem("transport", "plug_facade");
        TRANSPORT_PLUGGABLE_POWER_ADAPTOR = BCItems.getRegisteredItem("transport", "plug_power_adapter");
        TRANSPORT_PIPE_WOOD_ITEM = BCItems.getRegisteredItem("transport", "pipe_wood_item");
        TRANSPORT_PIPE_WOOD_FLUID = BCItems.getRegisteredItem("transport", "pipe_wood_fluid");
        TRANSPORT_PIPE_WOOD_POWER = BCItems.getRegisteredItem("transport", "pipe_wood_power");
        TRANSPORT_PIPE_DIAMOND_ITEM = BCItems.getRegisteredItem("transport", "pipe_diamond_item");
        if (DEBUG) {
            for (Item item : Item.field_150901_e) {
                ResourceLocation id = item.getRegistryName();
                if (!id.func_110624_b().startsWith("buildcraft") || SCANNED.contains(id.toString())) continue;
                BCLog.logger.warn("[api.items] Found an item " + id.toString() + " that was not registered with the API! Is this a bug?");
            }
        }
    }
}

