/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class BCBlocks {
    private static final boolean DEBUG = BCDebugging.shouldDebugLog("api.blocks");
    public static final Block CORE_DECORATED;
    public static final Block CORE_ENGINE;
    public static final Block CORE_MARKER_VOLUME;
    public static final Block CORE_MARKER_PATH;
    public static final Block FACTORY_TANK;
    public static final Block FACTORY_PUMP;
    public static final Block FACTORY_CHUTE;
    public static final Block FACTORY_FLOOD_GATE;
    public static final Block FACTORY_MINING_WELL;
    public static final Block FACTORY_AUTOWORKBENCH_ITEM;
    public static final Block FACTORY_DISTILLER;
    public static final Block FACTORY_HEAT_EXCHANGE_START;
    public static final Block FACTORY_HEAT_EXCHANGE_MIDDLE;
    public static final Block FACTORY_HEAT_EXCHANGE_END;
    public static final Block SILICON_LASER;
    public static final Block SILICON_TABLE_ASSEMBLY;
    public static final Block SILICON_TABLE_INTEGRATION;
    public static final Block SILICON_TABLE_ADV_CRAFT;
    public static final Block SILICON_TABLE_CHARGING;
    public static final Block SILICON_TABLE_PROGRAMMING;
    private static final Set<String> SCANNED;

    private static Block getRegisteredBlock(String module, String regName) {
        String modid = "buildcraft" + module;
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modid, regName));
        if (block != Blocks.field_150350_a) {
            if (DEBUG) {
                BCLog.logger.info("[api.blocks] Found the block " + regName + " from the module " + module);
                SCANNED.add(modid + ":" + regName);
            }
            return block;
        }
        if (DEBUG) {
            if (Loader.isModLoaded((String)modid)) {
                BCLog.logger.info("[api.blocks] Did not find the block " + regName + " despite the appropriate mod being loaded (" + modid + ")");
            } else {
                BCLog.logger.info("[api.blocks] Did not find the block " + regName + " probably because the mod is not loaded (" + modid + ")");
            }
        }
        return null;
    }

    static {
        HashSet hashSet = SCANNED = DEBUG ? new HashSet() : null;
        if (!Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new RuntimeException("Accessed BC blocks too early! You can only use them from init onwards!");
        }
        String core = "core";
        CORE_DECORATED = BCBlocks.getRegisteredBlock(core, "decorated");
        CORE_ENGINE = BCBlocks.getRegisteredBlock(core, "engine");
        CORE_MARKER_VOLUME = BCBlocks.getRegisteredBlock(core, "marker_volume");
        CORE_MARKER_PATH = BCBlocks.getRegisteredBlock(core, "marker_path");
        String energy = "energy";
        String factory = "factory";
        FACTORY_TANK = BCBlocks.getRegisteredBlock(factory, "tank");
        FACTORY_PUMP = BCBlocks.getRegisteredBlock(factory, "pump");
        FACTORY_CHUTE = BCBlocks.getRegisteredBlock(factory, "chute");
        FACTORY_FLOOD_GATE = BCBlocks.getRegisteredBlock(factory, "flood_gate");
        FACTORY_MINING_WELL = BCBlocks.getRegisteredBlock(factory, "mining_well");
        FACTORY_AUTOWORKBENCH_ITEM = BCBlocks.getRegisteredBlock(factory, "autoworkbench_item");
        FACTORY_DISTILLER = BCBlocks.getRegisteredBlock(factory, "distiller");
        FACTORY_HEAT_EXCHANGE_START = BCBlocks.getRegisteredBlock(factory, "heat_exchange_start");
        FACTORY_HEAT_EXCHANGE_MIDDLE = BCBlocks.getRegisteredBlock(factory, "heat_exchange_middle");
        FACTORY_HEAT_EXCHANGE_END = BCBlocks.getRegisteredBlock(factory, "heat_exchange_end");
        String silicon = "silicon";
        SILICON_LASER = BCBlocks.getRegisteredBlock(silicon, "laser");
        SILICON_TABLE_ASSEMBLY = BCBlocks.getRegisteredBlock(silicon, "assembly_table");
        SILICON_TABLE_INTEGRATION = BCBlocks.getRegisteredBlock(silicon, "integration_table");
        SILICON_TABLE_ADV_CRAFT = BCBlocks.getRegisteredBlock(silicon, "advanced_crafting_table");
        SILICON_TABLE_CHARGING = BCBlocks.getRegisteredBlock(silicon, "charging_table");
        SILICON_TABLE_PROGRAMMING = BCBlocks.getRegisteredBlock(silicon, "programming_table");
        if (DEBUG) {
            for (Block block : Block.field_149771_c) {
                ResourceLocation id = block.getRegistryName();
                if (!id.func_110624_b().startsWith("buildcraft") || SCANNED.contains(id.toString())) continue;
                BCLog.logger.warn("[api.blocks] Found a block " + id.toString() + " that was not registered with the API! Is this a bug?");
            }
        }
    }
}

