/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory;

import buildcraft.api.core.IStackFilter;
import buildcraft.lib.inventory.AbstractInvItemTransactor;
import buildcraft.lib.inventory.InventoryWrapper;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public final class SidedInventoryWrapper
extends AbstractInvItemTransactor {
    private final ISidedInventory sided;
    private final InventoryWrapper normal;
    private final EnumFacing face;
    private final int[] slots;

    public SidedInventoryWrapper(ISidedInventory sided, EnumFacing face) {
        this.sided = sided;
        this.normal = new InventoryWrapper((IInventory)sided);
        this.face = face;
        this.slots = sided.func_180463_a(face);
    }

    @Override
    @Nonnull
    protected ItemStack insert(int externalSlot, @Nonnull ItemStack stack, boolean simulate) {
        int sidedSlot = this.slots[externalSlot];
        if (this.sided.func_180462_a(sidedSlot, stack, this.face)) {
            return this.normal.insert(sidedSlot, stack, simulate);
        }
        return stack;
    }

    @Override
    @Nonnull
    protected ItemStack extract(int externalSlot, IStackFilter filter, int min, int max, boolean simulate) {
        int sidedSlot = this.slots[externalSlot];
        ItemStack current = this.sided.func_70301_a(sidedSlot);
        if (this.sided.func_180461_b(sidedSlot, current, this.face)) {
            return this.normal.extract(sidedSlot, filter, min, max, simulate);
        }
        return StackUtil.EMPTY;
    }

    @Override
    protected int getSlots() {
        return this.slots.length;
    }

    @Override
    protected boolean isEmpty(int slot) {
        return this.normal.isEmpty(this.slots[slot]);
    }
}

