/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.config;

import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.gui.config.GuiConfigSet;
import buildcraft.lib.gui.config.GuiPropertyBoolean;
import buildcraft.lib.gui.config.GuiPropertyConstructor;
import buildcraft.lib.misc.MessageUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.util.ResourceLocation;

public class GuiConfigManager {
    public static final Map<String, GuiPropertyConstructor> customGuiProperties = new HashMap<String, GuiPropertyConstructor>();
    private static final Map<ResourceLocation, GuiConfigSet> properties;
    private static boolean isDirty;

    public static IVariableNode getOrAddProperty(ResourceLocation gui, String name, IExpressionNode value) {
        GuiConfigSet props = properties.computeIfAbsent(gui, r -> new GuiConfigSet());
        return props.getOrAddProperty(name, value);
    }

    public static IVariableNode.IVariableNodeBoolean getOrAddBoolean(ResourceLocation gui, String name, boolean defaultValue) {
        return (IVariableNode.IVariableNodeBoolean)GuiConfigManager.getOrAddProperty(gui, name, NodeConstantBoolean.of(defaultValue));
    }

    public static void markDirty() {
        if (!isDirty && BCLibConfig.guiConfigFile != null) {
            MessageUtil.doDelayed(10, () -> {
                try (FileWriter fw = new FileWriter(BCLibConfig.guiConfigFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    try (BufferedWriter bw = new BufferedWriter(fw);){
                        JsonObject json = GuiConfigManager.writeToJson();
                        String str = gson.toJson((JsonElement)json);
                        bw.write(str);
                        bw.flush();
                        bw.close();
                    }
                }
                catch (IOException io) {
                    BCLog.logger.warn("[lib.gui.cfg] Failed to write the config file! " + io.getMessage());
                }
                isDirty = false;
            });
        }
        isDirty = true;
    }

    public static void loadFromConfigFile() {
        if (BCLibConfig.guiConfigFile != null) {
            List<String> lines;
            Gson gson = new Gson();
            try {
                lines = Files.readAllLines(BCLibConfig.guiConfigFile.toPath());
            }
            catch (IOException io) {
                BCLog.logger.warn("[lib.gui.cfg] Failed to read the config file! " + io.getMessage());
                return;
            }
            StringBuilder allLines = new StringBuilder();
            for (String line : lines) {
                allLines.append(line);
                allLines.append('\n');
            }
            try {
                GuiConfigManager.readFromJson((JsonObject)gson.fromJson(allLines.toString(), JsonObject.class));
                return;
            }
            catch (JsonSyntaxException jse) {
                BCLog.logger.warn("[lib.gui.cfg] There's a problem with the config file: try fixing it manually, or deleting it to let buildcraft overwrite it on save." + jse.getMessage());
            }
            catch (ClassCastException cce) {
                BCLog.logger.warn("[lib.gui.cfg] There's a major problem with the config file: try fixing it manually, or deleting it to let buildcraft overwrite it on save." + cce.getMessage());
            }
            BCLog.logger.info("File contents:");
            for (String line : lines) {
                BCLog.logger.info(line.replace("\u0000", "\\0"));
            }
        }
    }

    private static JsonObject writeToJson() {
        JsonObject json = new JsonObject();
        for (Map.Entry<ResourceLocation, GuiConfigSet> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            json.add(key, (JsonElement)entry.getValue().writeToJson());
        }
        return json;
    }

    private static void readFromJson(JsonObject json) {
        if (json == null) {
            throw new JsonSyntaxException("No json element!");
        }
        for (Map.Entry entry : json.entrySet()) {
            JsonElement elem;
            ResourceLocation location = new ResourceLocation((String)entry.getKey());
            GuiConfigSet set = properties.get(location);
            if (set == null) {
                set = new GuiConfigSet();
                properties.put(location, set);
            }
            if (!(elem = (JsonElement)entry.getValue()).isJsonObject()) {
                BCLog.logger.warn("[lib.gui.config] Found a non-object element in '" + location + "'");
                continue;
            }
            set.readFromJson(elem.getAsJsonObject());
        }
    }

    static {
        isDirty = false;
        properties = new TreeMap<ResourceLocation, GuiConfigSet>((a, b) -> a.toString().compareTo(b.toString()));
        customGuiProperties.put(NodeTypes.getName(Boolean.TYPE), GuiPropertyBoolean::new);
    }
}

