/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import net.minecraft.world.gen.feature.WorldGenGlowStone2;
import net.minecraft.world.gen.feature.WorldGenHellLava;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderGenerateBOPHell
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState NETHERRACK = Blocks.field_150424_aL.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState SOUL_SAND = Blocks.field_150425_aM.func_176223_P();
    private final World world;
    private final boolean generateStructures;
    private final Random rand;
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private double[] noiseArray;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private NoiseGeneratorPerlin stoneNoiseGen;
    private final WorldGenFire fireFeature = new WorldGenFire();
    private final WorldGenGlowStone1 lightGemGen = new WorldGenGlowStone1();
    private final WorldGenGlowStone2 hellPortalGen = new WorldGenGlowStone2();
    private final WorldGenerator quartzGen = new WorldGenMinable(Blocks.field_150449_bY.func_176223_P(), 14, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private final WorldGenerator magmaGen = new WorldGenMinable(Blocks.field_189877_df.func_176223_P(), 33, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private final WorldGenHellLava lavaTrapGen = new WorldGenHellLava((Block)Blocks.field_150356_k, true);
    private final WorldGenHellLava hellSpringGen = new WorldGenHellLava((Block)Blocks.field_150356_k, false);
    private final WorldGenBush brownMushroomFeature = new WorldGenBush(Blocks.field_150338_P);
    private final WorldGenBush redMushroomFeature = new WorldGenBush(Blocks.field_150337_Q);
    private MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private MapGenBase genNetherCaves = new MapGenCavesHell();
    private double[] xyzBalanceNoiseArray;
    private double[] xyzNoiseArrayA;
    private double[] xyzNoiseArrayB;
    private double[] noiseData4;
    private double[] depthRegion;
    private double[] stoneNoiseArray;

    public ChunkProviderGenerateBOPHell(World worldIn, boolean p_i45637_2_, long seed) {
        this.world = worldIn;
        this.generateStructures = p_i45637_2_;
        this.rand = new Random(seed);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.stoneNoiseGen = new NoiseGeneratorPerlin(this.rand, 4);
        worldIn.func_181544_b(63);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.scaleNoise, this.depthNoise);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.slowsandGravelNoiseGen = ctx.getPerlin2();
        this.netherrackExculsivityNoiseGen = ctx.getPerlin3();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
        this.stoneNoiseArray = new double[256];
        this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.genNetherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.genNetherCaves = TerrainGen.getModdedMapGen((MapGenBase)this.genNetherCaves, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
    }

    public void setChunkLavaNetherrack(int chunkX, int chunkZ, ChunkPrimer primer) {
        int seaLevel = this.world.func_181545_F() / 2 + 1;
        this.noiseArray = this.getHeights(this.noiseArray, chunkX * 4, 0, chunkZ * 4, 5, 17, 5);
        double oneEighth = 0.125;
        double oneQuarter = 0.25;
        for (int ix = 0; ix < 4; ++ix) {
            int k_x0 = ix * 5;
            int k_x1 = (ix + 1) * 5;
            for (int iz = 0; iz < 4; ++iz) {
                int k_x0z0 = (k_x0 + iz) * 17;
                int k_x0z1 = (k_x0 + iz + 1) * 17;
                int k_x1z0 = (k_x1 + iz) * 17;
                int k_x1z1 = (k_x1 + iz + 1) * 17;
                for (int iy = 0; iy < 16; ++iy) {
                    double n_x0y0z0 = this.noiseArray[k_x0z0 + iy];
                    double n_x0y0z1 = this.noiseArray[k_x0z1 + iy];
                    double n_x1y0z0 = this.noiseArray[k_x1z0 + iy];
                    double n_x1y0z1 = this.noiseArray[k_x1z1 + iy];
                    double n_x0y1z0 = this.noiseArray[k_x0z0 + iy + 1];
                    double n_x0y1z1 = this.noiseArray[k_x0z1 + iy + 1];
                    double n_x1y1z0 = this.noiseArray[k_x1z0 + iy + 1];
                    double n_x1y1z1 = this.noiseArray[k_x1z1 + iy + 1];
                    double noiseStepY00 = (n_x0y1z0 - n_x0y0z0) * oneEighth;
                    double noiseStepY01 = (n_x0y1z1 - n_x0y0z1) * oneEighth;
                    double noiseStepY10 = (n_x1y1z0 - n_x1y0z0) * oneEighth;
                    double noiseStepY11 = (n_x1y1z1 - n_x1y0z1) * oneEighth;
                    double noiseStartX0 = n_x0y0z0;
                    double noiseStartX1 = n_x0y0z1;
                    double noiseEndX0 = n_x1y0z0;
                    double noiseEndX1 = n_x1y0z1;
                    for (int jy = 0; jy < 8; ++jy) {
                        double noiseStartZ = noiseStartX0;
                        double noiseEndZ = noiseStartX1;
                        double noiseStepX0 = (noiseEndX0 - noiseStartX0) * oneQuarter;
                        double noiseStepX1 = (noiseEndX1 - noiseStartX1) * oneQuarter;
                        for (int jx = 0; jx < 4; ++jx) {
                            double noiseStepZ = (noiseEndZ - noiseStartZ) * oneQuarter;
                            double noiseVal = noiseStartZ;
                            for (int jz = 0; jz < 4; ++jz) {
                                if (noiseVal > 0.0) {
                                    primer.func_177855_a(ix * 4 + jx, iy * 8 + jy, iz * 4 + jz, NETHERRACK);
                                } else if (iy * 8 + jy < seaLevel) {
                                    primer.func_177855_a(ix * 4 + jx, iy * 8 + jy, iz * 4 + jz, LAVA);
                                }
                                noiseVal += noiseStepZ;
                            }
                            noiseStartZ += noiseStepX0;
                            noiseEndZ += noiseStepX1;
                        }
                        noiseStartX0 += noiseStepY00;
                        noiseStartX1 += noiseStepY01;
                        noiseEndX0 += noiseStepY10;
                        noiseEndX1 += noiseStepY11;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomes) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.stoneNoiseArray = this.stoneNoiseGen.func_151599_a(this.stoneNoiseArray, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                Biome biome = biomes[localZ + localX * 16];
                biome.func_180622_a(this.world, this.rand, primer, chunkX * 16 + localX, chunkZ * 16 + localZ, this.stoneNoiseArray[localZ + localX * 16]);
            }
        }
    }

    public void buildSurfaces(int chunkX, int chunkZ, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int i = this.world.func_181545_F() + 1;
        double d0 = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, chunkX * 16, 109, chunkZ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.depthBuffer = this.netherrackExculsivityNoiseGen.func_76304_a(this.depthBuffer, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int ix = 0; ix < 16; ++ix) {
            for (int iz = 0; iz < 16; ++iz) {
                boolean flag = this.slowsandNoise[ix + iz * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[ix + iz * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                int l = (int)(this.depthBuffer[ix + iz * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                IBlockState iblockstate = NETHERRACK;
                IBlockState iblockstate1 = NETHERRACK;
                for (int iy = 127; iy >= 0; --iy) {
                    if (iy < 127 - this.rand.nextInt(5) && iy > this.rand.nextInt(5)) {
                        IBlockState iblockstate2 = primer.func_177856_a(iz, iy, ix);
                        if (iblockstate2.func_177230_c() != null && iblockstate2.func_185904_a() != Material.field_151579_a) {
                            if (iblockstate2.func_177230_c() != Blocks.field_150424_aL) continue;
                            if (i1 == -1) {
                                if (l <= 0) {
                                    iblockstate = AIR;
                                    iblockstate1 = NETHERRACK;
                                } else if (iy >= i - 4 && iy <= i + 1) {
                                    iblockstate = NETHERRACK;
                                    iblockstate1 = NETHERRACK;
                                    if (flag1) {
                                        iblockstate = GRAVEL;
                                        iblockstate1 = NETHERRACK;
                                    }
                                    if (flag) {
                                        iblockstate = SOUL_SAND;
                                        iblockstate1 = SOUL_SAND;
                                    }
                                }
                                if (iy < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                                    iblockstate = LAVA;
                                }
                                i1 = l;
                                if (iy >= i - 1) {
                                    primer.func_177855_a(iz, iy, ix, iblockstate);
                                    continue;
                                }
                                primer.func_177855_a(iz, iy, ix, iblockstate1);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            primer.func_177855_a(iz, iy, ix, iblockstate1);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    primer.func_177855_a(iz, iy, ix, BEDROCK);
                }
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setChunkLavaNetherrack(chunkX, chunkZ, chunkprimer);
        this.buildSurfaces(chunkX, chunkZ, chunkprimer);
        this.genNetherCaves.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        if (this.generateStructures) {
            this.genNetherBridge.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        }
        Biome[] biomes = this.world.func_72959_q().func_76933_b((Biome[])null, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkZ, chunkprimer, biomes);
        Chunk chunk = new Chunk(this.world, chunkprimer, chunkX, chunkZ);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)biomes[i]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] getHeights(double[] noiseArray, int subchunkX, int subchunkY, int subchunkZ, int sizeX, int sizeY, int sizeZ) {
        if (noiseArray == null) {
            noiseArray = new double[sizeX * sizeY * sizeZ];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, noiseArray, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        this.depthRegion = this.depthNoise.func_76304_a(this.depthRegion, subchunkX, subchunkY, subchunkZ, sizeX, 1, sizeZ, 100.0, 0.0, 100.0);
        double coordinateScale = 684.412;
        double heightScale = 2053.236;
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 60.0;
        double mainNoiseScaleZ = 80.0;
        this.xyzBalanceNoiseArray = this.perlinNoise1.func_76304_a(this.xyzBalanceNoiseArray, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, coordinateScale / mainNoiseScaleX, heightScale / mainNoiseScaleY, coordinateScale / mainNoiseScaleZ);
        this.xyzNoiseArrayA = this.lperlinNoise1.func_76304_a(this.xyzNoiseArrayA, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, coordinateScale, heightScale, coordinateScale);
        this.xyzNoiseArrayB = this.lperlinNoise2.func_76304_a(this.xyzNoiseArrayB, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, coordinateScale, heightScale, coordinateScale);
        int xyzCounter = 0;
        double[] yBalanceArray = new double[sizeY];
        for (int iy = 0; iy < sizeY; ++iy) {
            yBalanceArray[iy] = Math.cos((double)iy * Math.PI * 6.0 / (double)sizeY) * 2.0;
            double jy = iy;
            if (iy > sizeY / 2) {
                jy = sizeY - 1 - iy;
            }
            if (!(jy < 4.0)) continue;
            jy = 4.0 - jy;
            int n = iy;
            yBalanceArray[n] = yBalanceArray[n] - jy * jy * jy * 10.0;
        }
        for (int ix = 0; ix < sizeX; ++ix) {
            for (int iz = 0; iz < sizeZ; ++iz) {
                for (int iy = 0; iy < sizeY; ++iy) {
                    double yBalance = yBalanceArray[iy];
                    double xyzNoiseA = this.xyzNoiseArrayA[xyzCounter] / 512.0;
                    double xyzNoiseB = this.xyzNoiseArrayB[xyzCounter] / 512.0;
                    double balance = (this.xyzBalanceNoiseArray[xyzCounter] / 10.0 + 1.0) / 2.0;
                    double xyzNoiseValue = balance < 0.0 ? xyzNoiseA : (balance > 1.0 ? xyzNoiseB : xyzNoiseA + (xyzNoiseB - xyzNoiseA) * balance);
                    xyzNoiseValue -= yBalance;
                    if (iy > sizeY - 4) {
                        double closeToTopOfChunkFactor = (float)(iy - (sizeY - 4)) / 3.0f;
                        xyzNoiseValue = xyzNoiseValue * (1.0 - closeToTopOfChunkFactor) + -10.0 * closeToTopOfChunkFactor;
                    }
                    noiseArray[xyzCounter] = xyzNoiseValue;
                    ++xyzCounter;
                }
            }
        }
        return noiseArray;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        boolean prevLogging = ForgeModContainer.logCascadingWorldGeneration;
        ForgeModContainer.logCascadingWorldGeneration = false;
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos blockpos = new BlockPos(x, 0, z);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        this.genNetherBridge.func_175794_a(this.world, this.rand, chunkpos);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA)) {
            for (int k = 0; k < 8; ++k) {
                this.hellSpringGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(x, 0, z));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE)) {
            for (int i1 = 0; i1 < this.rand.nextInt(this.rand.nextInt(10) + 1) + 1; ++i1) {
                this.fireFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE)) {
            for (int j1 = 0; j1 < this.rand.nextInt(this.rand.nextInt(10) + 1); ++j1) {
                this.lightGemGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
            for (int k1 = 0; k1 < 10; ++k1) {
                this.hellPortalGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        if (TerrainGen.decorate((World)this.world, (Random)this.rand, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            if (this.rand.nextBoolean()) {
                this.brownMushroomFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
            if (this.rand.nextBoolean()) {
                this.redMushroomFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
        }
        if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.quartzGen, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.QUARTZ)) {
            for (int l1 = 0; l1 < 16; ++l1) {
                this.quartzGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(108) + 10, this.rand.nextInt(16)));
            }
        }
        int i2 = this.world.func_181545_F() / 2 + 1;
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_MAGMA)) {
            for (int l = 0; l < 4; ++l) {
                this.magmaGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16), i2 - 5 + this.rand.nextInt(10), this.rand.nextInt(16)));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA2)) {
            for (int j2 = 0; j2 < 16; ++j2) {
                this.lavaTrapGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(108) + 10, this.rand.nextInt(16)));
            }
        }
        BlockFalling.field_149832_M = false;
        ForgeModContainer.logCascadingWorldGeneration = prevLogging;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.genNetherBridge.func_175795_b(pos)) {
                return this.genNetherBridge.func_75059_a();
            }
            if (this.genNetherBridge.func_175796_a(this.world, pos) && this.world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                return this.genNetherBridge.func_75059_a();
            }
        }
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean p_180513_4_) {
        return "Fortress".equals(structureName) && this.genNetherBridge != null ? this.genNetherBridge.func_180706_b(worldIn, position, p_180513_4_) : null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        this.genNetherBridge.func_186125_a(this.world, x, z, (ChunkPrimer)null);
    }
}

