/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.init;

import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.integration.ThaumcraftCompat;
import biomesoplenty.core.BiomesOPlenty;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ModCompatibility {
    public static final Function<BiomeManager.BiomeEntry, WrappedBiomeEntry> WRAP_BIOME_ENTRIES = new Function<BiomeManager.BiomeEntry, WrappedBiomeEntry>(){

        public WrappedBiomeEntry apply(BiomeManager.BiomeEntry input) {
            return new WrappedBiomeEntry(input);
        }
    };

    public static void postInit() {
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            try {
                ThaumcraftCompat.init();
            }
            catch (Exception e) {
                BiomesOPlenty.logger.error("There was an error while integrating Thaumcraft with Biomes O' Plenty", (Throwable)e);
            }
        }
        ModCompatibility.copyModBiomeWeights();
    }

    private static void copyModBiomeWeights() {
        try {
            List[] vanillaBiomes = (List[])ReflectionHelper.findMethod(BiomeManager.class, null, (String[])new String[]{"setupBiomes"}, (Class[])new Class[0]).invoke(null, new Object[0]);
            for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
                List entries = Lists.transform((List)Lists.newArrayList((Iterable)BiomeManager.getBiomes((BiomeManager.BiomeType)type)), WRAP_BIOME_ENTRIES);
                ArrayList vanillaEntries = type.ordinal() < vanillaBiomes.length ? Lists.transform((List)vanillaBiomes[type.ordinal()], WRAP_BIOME_ENTRIES) : Lists.newArrayList();
                entries.removeAll(vanillaEntries);
                for (WrappedBiomeEntry wrappedEntry : entries) {
                    ModCompatibility.remapBiomeToBoP(((WrappedBiomeEntry)wrappedEntry).biomeEntry.biome, type, ((WrappedBiomeEntry)wrappedEntry).biomeEntry.field_76292_a);
                }
            }
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("An error has occurred whilst copying mod biomes");
            e.printStackTrace();
            return;
        }
    }

    private static void remapBiomeToBoP(Biome biome, BiomeManager.BiomeType type, int weight) {
        for (BOPClimates climate : BOPClimates.values()) {
            if (climate.biomeType != type) continue;
            climate.addBiome(weight, biome);
        }
    }

    private static class WrappedBiomeEntry {
        private BiomeManager.BiomeEntry biomeEntry;

        private WrappedBiomeEntry(BiomeManager.BiomeEntry biomeEntry) {
            this.biomeEntry = biomeEntry;
        }

        public boolean equals(Object input) {
            if (input == null) {
                return false;
            }
            if (input == this) {
                return true;
            }
            if (!(input instanceof WrappedBiomeEntry)) {
                return false;
            }
            WrappedBiomeEntry other = (WrappedBiomeEntry)input;
            return other.biomeEntry.field_76292_a == this.biomeEntry.field_76292_a && other.biomeEntry.biome == this.biomeEntry.biome;
        }
    }
}

