/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.handler;

import biomesoplenty.api.achievement.BOPAchievements;
import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPFlower;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.block.BlockBOPSapling;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.JsonSerializableSet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class AchievementEventHandler {
    private static final Set<Biome> BOP_BIOMES_TO_EXPLORE = Sets.union(BOPBiomes.REG_INSTANCE.getPresentBiomes(), (Set)Biome.field_150597_n);

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        Item item = stack.func_77973_b();
        IBlockState state = Block.func_149634_a((Item)item).func_176203_a(item.getMetadata(stack));
        Block block = state.func_177230_c();
        EntityPlayer player = event.getEntityPlayer();
        if (block instanceof BlockBOPLog) {
            player.func_71029_a((StatBase)AchievementList.field_187983_g);
        }
        if (block instanceof BlockBOPFlower || block == Blocks.field_150328_O || block == Blocks.field_150327_N) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_flowers);
        }
        if (item == BOPItems.berries) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_berry);
        }
        if (block == BOPBlocks.coral) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_coral);
        }
        if (state == BlockBOPFlower.paging.getVariantState(BOPFlowers.MINERS_DELIGHT)) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_miners_delight);
        }
        if (state == BlockBOPPlant.paging.getVariantState(BOPPlants.THORN)) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_thorn);
        }
        if (state == BlockBOPFlower.paging.getVariantState(BOPFlowers.DEATHBLOOM)) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_deathbloom);
        }
        if (state == BlockBOPFlower.paging.getVariantState(BOPFlowers.WILTED_LILY)) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_wilted_lily);
        }
        if (item == BOPItems.turnip) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_turnip);
        }
        if (item == BOPItems.soul) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_soul);
        }
        if (item == BOPItems.filled_honeycomb) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_honeycomb);
        }
        if (item == BOPItems.pixie_dust) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_pixie_dust);
        }
        if (item == BOPItems.crystal_shard) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_celestial_crystal);
        }
    }

    @SubscribeEvent
    public void onItemUsed(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
    }

    @SubscribeEvent
    public void onItemUsed(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        Item item = stack.func_77973_b();
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (item == BOPItems.shroompowder) {
                player.func_71029_a((StatBase)BOPAchievements.eat_shroom_powder);
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        ItemStack stack = event.getItemInHand();
        if (stack != null) {
            Item item = stack.func_77973_b();
            IBlockState state = Block.func_149634_a((Item)item).func_176203_a(item.getMetadata(stack));
            try {
                if (state == BlockBOPSapling.paging.getVariantState(BOPTrees.SACRED_OAK)) {
                    event.getPlayer().func_71029_a((StatBase)BOPAchievements.grow_sacred_oak);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        EntityPlayer player = event.player;
        if (item == BOPItems.ambrosia) {
            player.func_71029_a((StatBase)BOPAchievements.craft_ambrosia);
        }
        if (item == BOPItems.terrestrial_artifact) {
            player.func_71029_a((StatBase)BOPAchievements.craft_terrestrial_artifact);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            if (player.field_70173_aa % 20 * 5 == 0) {
                if (!player.func_147099_x().func_77443_a(BOPAchievements.use_biome_finder)) {
                    this.updateBiomeRadarExplore(player);
                }
                if (!player.func_147099_x().func_77443_a(BOPAchievements.explore_all_biomes)) {
                    this.updateBiomesExplored(player);
                }
            }
        }
    }

    private void updateBiomeRadarExplore(EntityPlayerMP player) {
        Biome currentBiome = player.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v)));
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            int biomeIdToFind;
            if (stack.func_190926_b() || stack.func_77973_b() != BOPItems.biome_finder || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("biomeIDToFind") || (biomeIdToFind = stack.func_77978_p().func_74762_e("biomeIDToFind")) != Biome.func_185362_a((Biome)currentBiome)) continue;
            player.func_71029_a((StatBase)BOPAchievements.use_biome_finder);
            return;
        }
    }

    private void updateBiomesExplored(EntityPlayerMP player) {
        Biome currentBiome = player.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v)));
        String biomeName = currentBiome.func_185359_l();
        JsonSerializableSet exploredBiomeNames = (JsonSerializableSet)player.func_147099_x().func_150870_b((StatBase)BOPAchievements.explore_all_biomes);
        if (exploredBiomeNames == null) {
            exploredBiomeNames = (JsonSerializableSet)player.func_147099_x().func_150872_a((StatBase)BOPAchievements.explore_all_biomes, (IJsonSerializable)new JsonSerializableSet());
        }
        exploredBiomeNames.add((Object)biomeName);
        if (player.func_147099_x().func_77442_b(BOPAchievements.explore_all_biomes) && exploredBiomeNames.size() >= BOP_BIOMES_TO_EXPLORE.size()) {
            HashSet set = Sets.newHashSet(BOP_BIOMES_TO_EXPLORE);
            for (String exploredBiomeName : exploredBiomeNames) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Biome biome = (Biome)iterator.next();
                    if (!biome.func_185359_l().equals(exploredBiomeName)) continue;
                    iterator.remove();
                }
                if (!set.isEmpty()) continue;
                break;
            }
            if (set.isEmpty()) {
                player.func_71029_a((StatBase)BOPAchievements.explore_all_biomes);
            }
        }
    }
}

