/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.entities;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.api.particle.BOPParticleTypes;
import biomesoplenty.api.sound.BOPSounds;
import biomesoplenty.core.BiomesOPlenty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityPixie
extends EntityFlying
implements IMob {
    public EntityPixie(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
        this.field_70765_h = new PixieMoveHelper();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIPixieRandomFly());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
    }

    protected SoundEvent func_184639_G() {
        return BOPSounds.pixie_ambient;
    }

    protected SoundEvent func_184601_bQ() {
        return BOPSounds.pixie_hurt;
    }

    protected Item func_146068_u() {
        return BOPItems.pixie_dust;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 7; ++i) {
                if (this.field_70146_Z.nextInt(2) != 0) continue;
                BiomesOPlenty.proxy.spawnParticle(BOPParticleTypes.PIXIETRAIL, this.field_70165_t + this.field_70146_Z.nextDouble() * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + this.field_70146_Z.nextDouble() * (double)this.field_70130_N, new Object[0]);
            }
        }
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int light = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int oldSkyLightSubtracted = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            light = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(oldSkyLightSubtracted);
        }
        return light <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return this.isValidLightLevel() && super.func_70601_bi();
    }

    class AIPixieRandomFly
    extends EntityAIBase {
        private EntityPixie pixie;
        private PixieMoveTargetPos targetPos;

        public AIPixieRandomFly() {
            this.pixie = EntityPixie.this;
            this.targetPos = new PixieMoveTargetPos();
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !this.pixie.func_70605_aq().func_75640_a();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random rand = this.pixie.func_70681_au();
            if (this.tryGoingRandomDirection(rand, 6.0)) {
                return;
            }
            if (this.tryGoingRandomDirection(rand, 2.0)) {
                return;
            }
            List<EnumFacing> directions = Arrays.asList(EnumFacing.values());
            Collections.shuffle(directions);
            for (EnumFacing facing : directions) {
                if (!this.tryGoingAlongAxis(rand, facing, 1.0)) continue;
                return;
            }
        }

        public boolean tryGoingRandomDirection(Random rand, double maxDistance) {
            double dirX = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            double dirY = (rand.nextDouble() * 2.0 - 1.1) * maxDistance;
            double dirZ = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            return this.tryGoing(dirX, dirY, dirZ);
        }

        public boolean tryGoingAlongAxis(Random rand, EnumFacing facing, double maxDistance) {
            double dirX = 0.0;
            double dirY = 0.0;
            double dirZ = 0.0;
            switch (facing.func_176740_k()) {
                case X: {
                    dirX = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                case Y: {
                    dirY = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                default: {
                    dirZ = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                }
            }
            return this.tryGoing(dirX, dirY, dirZ);
        }

        public boolean tryGoing(double dirX, double dirY, double dirZ) {
            this.targetPos.setTarget(this.pixie.field_70165_t + dirX, this.pixie.field_70163_u + dirY, this.pixie.field_70161_v + dirZ);
            boolean result = this.targetPos.isPathClear(5.0);
            if (result) {
                this.pixie.func_70605_aq().func_75642_a(this.targetPos.posX, this.targetPos.posY, this.targetPos.posZ, 1.0);
            }
            return result;
        }
    }

    class PixieMoveHelper
    extends EntityMoveHelper {
        private EntityPixie pixie;
        private int courseChangeCooldown;
        private double closeEnough;
        private PixieMoveTargetPos targetPos;

        public PixieMoveHelper() {
            super((EntityLiving)EntityPixie.this);
            this.pixie = EntityPixie.this;
            this.courseChangeCooldown = 0;
            this.closeEnough = 0.3;
            this.targetPos = new PixieMoveTargetPos();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            super.func_75642_a(x, y, z, speedIn);
            this.targetPos.setTarget(x, y, z);
        }

        public void func_75641_c() {
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                return;
            }
            if (this.courseChangeCooldown-- > 0) {
                return;
            }
            this.courseChangeCooldown += this.pixie.func_70681_au().nextInt(2) + 2;
            this.targetPos.refresh();
            double acceleration = 0.1;
            this.pixie.field_70159_w += this.targetPos.aimX * acceleration;
            this.pixie.field_70181_x += this.targetPos.aimY * acceleration;
            this.pixie.field_70179_y += this.targetPos.aimZ * acceleration;
            this.pixie.field_70761_aq = this.pixie.field_70177_z = -((float)Math.atan2(this.targetPos.distX, this.targetPos.distZ)) * 180.0f / (float)Math.PI;
            if (!this.targetPos.isPathClear(5.0)) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else if (this.targetPos.dist < this.closeEnough) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            }
        }
    }

    class PixieMoveTargetPos {
        private EntityPixie pixie;
        public double posX;
        public double posY;
        public double posZ;
        public double distX;
        public double distY;
        public double distZ;
        public double dist;
        public double aimX;
        public double aimY;
        public double aimZ;

        public PixieMoveTargetPos() {
            this(0.0, 0.0, 0.0);
        }

        public PixieMoveTargetPos(double posX, double posY, double posZ) {
            this.pixie = EntityPixie.this;
            this.setTarget(posX, posY, posZ);
        }

        public void setTarget(double posX, double posY, double posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.refresh();
        }

        public void refresh() {
            this.distX = this.posX - this.pixie.field_70165_t;
            this.distY = this.posY - this.pixie.field_70163_u;
            this.distZ = this.posZ - this.pixie.field_70161_v;
            this.dist = MathHelper.func_76133_a((double)(this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ));
            if (this.dist == 0.0) {
                this.aimX = 0.0;
                this.aimY = 0.0;
                this.aimZ = 0.0;
            } else {
                this.aimX = this.distX / this.dist;
                this.aimY = this.distY / this.dist;
                this.aimZ = this.distZ / this.dist;
            }
        }

        public boolean isBoxBlocked(AxisAlignedBB box) {
            return !this.pixie.field_70170_p.func_184144_a((Entity)this.pixie, box).isEmpty();
        }

        public boolean isPathClear(double howFar) {
            howFar = Math.min(howFar, this.dist);
            AxisAlignedBB box = this.pixie.func_174813_aQ();
            for (double i = 0.5; i < howFar; i += 1.0) {
                if (!this.isBoxBlocked(box.func_72317_d(this.aimX * i, this.aimY * i, this.aimZ * i))) continue;
                return false;
            }
            return !this.isBoxBlocked(box.func_72317_d(this.aimX * howFar, this.aimY * howFar, this.aimZ * howFar));
        }
    }
}

