/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.config.GameplayConfigurationHandler;
import biomesoplenty.common.item.ItemBOPFlower;
import biomesoplenty.common.util.block.VariantPagingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IHornHarvestable;

@Optional.Interface(iface="vazkii.botania.api.item.IHornHarvestable", modid="botania")
public class BlockBOPFlower
extends BlockBOPDecoration
implements IShearable,
IHornHarvestable {
    public static VariantPagingHelper<BlockBOPFlower, BOPFlowers> paging = new VariantPagingHelper(16, BOPFlowers.class);
    private static IProperty currentVariantProperty;
    public IProperty variantProperty;

    public static void createAllPages() {
        int numPages = paging.getNumPages();
        for (int i = 0; i < numPages; ++i) {
            currentVariantProperty = paging.getVariantProperty(i);
            paging.addBlock(i, new BlockBOPFlower());
        }
    }

    protected BlockStateContainer func_180661_e() {
        this.variantProperty = currentVariantProperty;
        return new BlockStateContainer((Block)this, new IProperty[]{this.variantProperty});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPFlower.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{this.variantProperty};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))).func_176610_l();
    }

    public BlockBOPFlower() {
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)paging.getVariant(this, meta)));
    }

    public int func_176201_c(IBlockState state) {
        BOPFlowers flower = (BOPFlowers)((Object)state.func_177229_b(this.variantProperty));
        return paging.getIndex(flower);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        BOPFlowers flower = (BOPFlowers)((Object)state.func_177229_b(this.variantProperty));
        switch (flower) {
            case CLOVER: {
                return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.09375, 0.9375);
            }
            case SWAMPFLOWER: 
            case VIOLET: 
            case WHITE_ANEMONE: 
            case BLUEBELLS: {
                return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.4000000357627869, 0.9375);
            }
            case BLUE_HYDRANGEA: 
            case BURNING_BLOSSOM: {
                return new AxisAlignedBB(0.20000001788, 0.0, 0.20000001788, 0.79999998211, (double)0.6f, 0.79999998211);
            }
            case ENDERLOTUS: 
            case BROMELIAD: 
            case PINK_HIBISCUS: 
            case LILY_OF_THE_VALLEY: 
            case LAVENDER: {
                return new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
            }
        }
        return new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);
    }

    public int func_149750_m(IBlockState state) {
        switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
            case GLOWFLOWER: {
                return 9;
            }
            case ENDERLOTUS: {
                return 5;
            }
            case BURNING_BLOSSOM: {
                return 9;
            }
        }
        return super.func_149750_m(state);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tileentity, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tileentity, stack);
        if (player.func_184586_b(EnumHand.MAIN_HAND) == null || !(player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemShears)) {
            switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
                case DEATHBLOOM: {
                    player.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 300));
                    break;
                }
                case BURNING_BLOSSOM: {
                    player.func_70015_d(5);
                    break;
                }
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
            case DEATHBLOOM: {
                if (!(entity instanceof EntityLivingBase)) break;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200));
                break;
            }
            case BURNING_BLOSSOM: {
                if (!(entity instanceof EntityLivingBase)) break;
                entity.func_70015_d(1);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
            case DEATHBLOOM: {
                if (rand.nextInt(4) != 0) {
                    world.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
                if (rand.nextInt(4) != 0) break;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case BURNING_BLOSSOM: {
                if (rand.nextInt(2) == 0) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
                if (rand.nextInt(4) != 0) break;
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState groundState = world.func_180495_p(pos.func_177977_b());
        Block groundBlock = groundState.func_177230_c();
        boolean onFertile = groundBlock == Blocks.field_150346_d || groundBlock == Blocks.field_150458_ak || groundBlock == BOPBlocks.farmland_0 || groundBlock == BOPBlocks.farmland_1 || groundBlock == BOPBlocks.dirt || groundBlock == Blocks.field_150349_c;
        boolean onDry = groundBlock == Blocks.field_150405_ch || groundBlock == BOPBlocks.sand || groundBlock == Blocks.field_150354_m || groundBlock == BOPBlocks.white_sand;
        boolean onNetherrack = groundBlock == Blocks.field_150424_aL;
        boolean onStone = groundBlock == Blocks.field_150348_b;
        boolean onDriedSand = groundBlock == BOPBlocks.dried_sand;
        boolean onSpectralMoss = false;
        if (groundBlock instanceof BlockBOPGrass) {
            switch ((BlockBOPGrass.BOPGrassType)((Object)groundState.func_177229_b((IProperty)BlockBOPGrass.VARIANT))) {
                case SPECTRAL_MOSS: {
                    onSpectralMoss = true;
                    break;
                }
                case OVERGROWN_NETHERRACK: {
                    onFertile = true;
                    onNetherrack = true;
                    break;
                }
                case MYCELIAL_NETHERRACK: {
                    onNetherrack = true;
                    break;
                }
                default: {
                    onFertile = true;
                }
            }
        }
        switch ((BOPFlowers)((Object)state.func_177229_b(this.variantProperty))) {
            case ENDERLOTUS: {
                return onSpectralMoss;
            }
            case BROMELIAD: {
                return onDry;
            }
            case WILTED_LILY: {
                return onDriedSand;
            }
            case BURNING_BLOSSOM: {
                return onNetherrack;
            }
            case MINERS_DELIGHT: {
                return onStone;
            }
        }
        return onFertile;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return GameplayConfigurationHandler.flowerDropsNeedShears;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        EntityPlayer player = (EntityPlayer)this.harvesters.get();
        if (GameplayConfigurationHandler.flowerDropsNeedShears && player != null) {
            boolean usingShears;
            boolean bl = usingShears = player.func_184586_b(EnumHand.MAIN_HAND) != null && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemShears;
            if (!usingShears) {
                return;
            }
        }
        super.func_180653_a(world, pos, state, chance, fortune);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPFlowers flower = (BOPFlowers)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (flower) {
            case BURNING_BLOSSOM: {
                return 0;
            }
        }
        return Blocks.field_150328_O.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPFlowers flower = (BOPFlowers)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (flower) {
            case BURNING_BLOSSOM: {
                return 0;
            }
        }
        return Blocks.field_150328_O.getFireSpreadSpeed(world, pos, face);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Optional.Method(modid="botania")
    public boolean canHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        if (hornType != IHornHarvestable.EnumHornType.WILD) {
            return false;
        }
        BOPFlowers flower = (BOPFlowers)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (flower) {
            default: 
        }
        return true;
    }

    @Optional.Method(modid="botania")
    public boolean hasSpecialHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return false;
    }

    @Optional.Method(modid="botania")
    public void harvestByHorn(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
    }
}

