/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBasicTree;
import biomesoplenty.common.world.generator.tree.GeneratorBigTree;
import biomesoplenty.common.world.generator.tree.GeneratorTaigaTree;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class BiomeGenOminousWoods
extends BOPOverworldBiome {
    public BiomeGenOminousWoods() {
        super("ominous_woods", new BOPBiome.PropsBuilder("Ominous Woods").withGuiColour(4145489).withTemperature(Float.valueOf(0.45f)).withRainfall(Float.valueOf(0.6f)).withWaterColor(1973030));
        this.terrainSettings.avgHeight(68.0).heightVariation(5.0, 15.0);
        this.skyColor = 0x34333D;
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.LOAMY));
        this.field_76753_B = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.LOAMY));
        this.canGenerateRivers = false;
        this.canGenerateVillages = false;
        this.canSpawnInBiome = false;
        this.beachBiomeLocation = null;
        this.fogColor = 0x34333D;
        this.fogDensity = 0.145f;
        this.addWeight(BOPClimates.COLD_SWAMP, 1);
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.addGenerator("poison_lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.1f)).liquid(BOPBlocks.poison).frozenLiquid((IBlockState)null).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(12.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("umbran_moss", 4, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BOPWoods.UMBRAN)).leaves(BOPTrees.UMBRAN)).minHeight(8)).maxHeight(12)).leaves(BlockBOPLeaves.paging.getVariantState(BOPTrees.UMBRAN).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, (Comparable)Boolean.valueOf(false)))).maxLeavesRadius(2)).vine(BOPBlocks.tree_moss.func_176223_P())).create());
        treeGenerator.add("umbran_spruce", 5, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BOPWoods.UMBRAN)).leaves(BOPTrees.UMBRAN)).maxHeight(20)).create());
        treeGenerator.add("dead_tree", 3, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(5)).maxHeight(12)).foliageHeight(0).foliageDensity(0.5).log(BOPWoods.DEAD)).leaves(Blocks.field_150350_a.func_176223_P())).create());
        treeGenerator.add("mega_umbran", 4, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BOPWoods.UMBRAN)).leaves(BOPTrees.UMBRAN)).minHeight(20)).maxHeight(30)).trunkWidth(2).create());
        treeGenerator.add("dying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(5)).maxHeight(12)).foliageHeight(1).log(BOPWoods.DEAD)).leaves(BOPTrees.DEAD)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(1.2f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.7f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("deathbloom", 2, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.DEATHBLOOM)).create());
        this.addGenerator("poison_ivy", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).generationAttempts(16)).with(BOPPlants.POISONIVY)).create());
        this.addGenerator("thorns", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.8f)).with(BOPPlants.THORN)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).placeOn(BlockQueries.fertile)).with(BOPPlants.DEADLEAFPILE)).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).with(Blocks.field_150337_Q.func_176223_P())).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(Blocks.field_150338_P.func_176223_P())).create());
        this.addGenerator("malachite", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.MALACHITE)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("malachite");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.POISON_IVY)) {
            this.removeGenerator("poison_ivy");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.THORNS)) {
            this.removeGenerator("thorns");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.LIQUID_POISON)) {
            this.removeGenerator("poison_lakes");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.SOILS)) {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.WATER_PLANTS)) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("flowers");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(9.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("umbran_moss", 4, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).leaves(Blocks.field_150361_u.func_176203_a(BlockPlanks.EnumType.DARK_OAK.func_176839_a()).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, (Comparable)Boolean.valueOf(false)))).minHeight(8)).maxHeight(12)).maxLeavesRadius(2)).vine(Blocks.field_150395_bd.func_176223_P())).create());
            treeGenerator.add("umbran_spruce", 5, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).maxHeight(20)).create());
            treeGenerator.add("dead_tree", 3, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(5)).maxHeight(12)).foliageHeight(0).foliageDensity(0.5).log(BlockPlanks.EnumType.DARK_OAK)).leaves(Blocks.field_150350_a.func_176223_P())).create());
            treeGenerator.add("mega_umbran", 4, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).minHeight(20)).maxHeight(30)).trunkWidth(2).create());
            treeGenerator.add("dying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(5)).maxHeight(12)).foliageHeight(1).log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).create());
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 4145489;
    }

    public int func_180625_c(BlockPos pos) {
        return 4145489;
    }
}

