/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorDoubleFlora;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWaterside;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBasicTree;
import biomesoplenty.common.world.generator.tree.GeneratorPineTree;
import com.google.common.base.CaseFormat;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;

public class BiomeGenMountain
extends BOPOverworldBiome {
    public MountainType type;
    public IBlockState grassBlock;
    public IBlockState dirtBlock;
    public IBlockState coarseDirtBlock;
    public IBlockState stoneBlock;

    public BiomeGenMountain(MountainType type) {
        super(type.name().toLowerCase(), new BOPBiome.PropsBuilder(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, type.toString())).withGuiColour(8430421).withTemperature(Float.valueOf(0.5f)).withRainfall(Float.valueOf(0.1f)));
        this.type = type;
        this.canSpawnInBiome = false;
        switch (type) {
            case MOUNTAIN: {
                this.terrainSettings.avgHeight(140.0).heightVariation(30.0, 60.0).octaves(1.0, 1.0, 2.0, 2.0, 3.0, 3.0).sidewaysNoise(0.1);
                break;
            }
            case MOUNTAIN_FOOTHILLS: {
                this.terrainSettings.avgHeight(100.0).heightVariation(15.0, 30.0).octaves(0.0, 1.0, 1.0, 3.0, 1.0, 0.0).sidewaysNoise(0.1);
                this.hasBiomeEssence = false;
            }
        }
        this.canGenerateRivers = false;
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.beachBiomeLocation = null;
        if (type == MountainType.MOUNTAIN) {
            this.canGenerateVillages = false;
            this.addWeight(BOPClimates.DRY_TEMPERATE, 3);
            this.field_76762_K.clear();
            this.field_76762_K.add(new Biome.SpawnListEntry(EntitySheep.class, 12, 4, 6));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 4, 4, 4));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityLlama.class, 5, 4, 6));
        }
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        this.addGenerator("gravel", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(6.0f)).maxRadius(7).with(Blocks.field_150351_n.func_176223_P())).create());
        this.addGenerator("lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(1.8f)).waterLakeForBiome(this).create());
        IBlockPosQuery suitableTreePosition = BlockQuery.buildAnd().withAltitudeBetween(64, 140).materials(Material.field_151578_c, Material.field_151577_b).create();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("pine", 2, ((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)new GeneratorPineTree.Builder().minHeight(6)).maxHeight(18)).log(BOPWoods.PINE)).leaves(BOPTrees.PINE)).placeOn(suitableTreePosition)).create());
        treeGenerator.add("oak", 1, new GeneratorBasicTree.Builder().create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(1.5f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).generationAttempts(128)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).generationAttempts(128)).create());
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).generationAttempts(128)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).generationAttempts(128)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).generationAttempts(128)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(BOPPlants.SHRUB)).generationAttempts(type == MountainType.MOUNTAIN_FOOTHILLS ? 64 : 32)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.8f)).placeOn(BlockQueries.fertile)).with(BOPPlants.LEAFPILE)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.2f)).placeOn(BlockQueries.fertile)).with(BOPPlants.DEADLEAFPILE)).create());
        if (type == MountainType.MOUNTAIN_FOOTHILLS) {
            this.addGenerator("flax", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPDoublePlant.DoublePlantType.FLAX).create());
            this.addGenerator("berry_bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(BOPPlants.BERRYBUSH)).create());
            this.addGenerator("water_reeds", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.4f)).with(BOPPlants.REED)).generationAttempts(32)).create());
        }
        this.addGenerator("emeralds", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(Blocks.field_150412_bA.func_176223_P())).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLAX)) {
            this.removeGenerator("flax");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.BERRY_BUSHES)) {
            this.removeGenerator("berry_bushes");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.WATER_PLANTS)) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            IBlockPosQuery suitableTreePosition = BlockQuery.buildAnd().withAltitudeBetween(64, 140).materials(Material.field_151578_c, Material.field_151577_b).create();
            GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("pine", 2, ((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)new GeneratorPineTree.Builder().minHeight(6)).maxHeight(18)).log(BlockPlanks.EnumType.SPRUCE)).leaves(BlockPlanks.EnumType.SPRUCE)).placeOn(suitableTreePosition)).create());
            treeGenerator.add("oak", 1, new GeneratorBasicTree.Builder().create());
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public static enum MountainType {
        MOUNTAIN,
        MOUNTAIN_FOOTHILLS;

    }
}

